/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.widgets;

import alma.common.horizonsparser.HorizonParser;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.widgets.OTFileArea;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.OTHorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFileChooser;

public class OTEphemerisWindow {
    private JFileChooser fileChooser;
    private OTFileArea master = null;

    public OTEphemerisWindow(String string, OTFileArea oTFileArea) {
        if (oTFileArea == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: master");
        }
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: title");
        }
        this.master = oTFileArea;
        this.fileChooser = GuiFactory.getFactory().giveFileChooser("ephemeris");
        this.fileChooser.setDialogTitle(string);
    }

    public void getEphemerisFromUser() throws IOException {
        String string;
        assert (this.fileChooser != null);
        int n = this.fileChooser.showOpenDialog(this.master);
        if (n != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        Log.logger(OTEphemerisWindow.class).fine("Loading ephemeris file : " + file.getName());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            GUIUtilities.error(null, "File not found : " + fileNotFoundException.getMessage());
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                GUIUtilities.error(null, "Unable to read file : " + iOException.getMessage());
                return;
            }
            if (string == null) break;
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        string = stringBuffer.toString();
        Log.Logger logger = Log.logger((Object)this);
        OTHorizonParser oTHorizonParser = null;
        try {
            oTHorizonParser = new OTHorizonParser(new OTLoggerAdapter(logger, this.getClass().getName(), null), string);
            oTHorizonParser.parseEphemeris();
        }
        catch (HorizonParser.UnableToParseEphemerisDataException | IOException | NullPointerException throwable) {
            GUIUtilities.error(null, "Unable to parse ephemeris file: " + throwable.getMessage());
            bufferedReader.close();
            return;
        }
        assert (oTHorizonParser != null);
        this.master.setText(stringBuffer.toString(), true);
    }

    public void SetMaster(OTFileArea oTFileArea) {
        this.master = oTFileArea;
    }
}

