/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.AttachTASummaryInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryObsProposal;
import alma.obsprep.services.summaryfeedback.FeedbackSummarySgCollection;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.util.FileUtilities;
import java.io.File;
import java.io.IOException;

public class AttachTASummaryPerformer
extends Performer {
    private static final String TA_COVER_NAME = "TA_Cover.pdf";
    private static final String TA_SCIGOALS_NAME = "TA_ScienceGoals.pdf";

    public AttachTASummaryPerformer(AttachTASummaryInteractor attachTASummaryInteractor) {
        super(attachTASummaryInteractor);
    }

    @Override
    public void perform() {
        AttachTASummaryInteractor attachTASummaryInteractor = (AttachTASummaryInteractor)this.getGui();
        ObsProposal obsProposal = attachTASummaryInteractor.getProposal();
        try {
            this.generateAndAttachPdf(obsProposal);
            ActionLog.performed(new Object[]{"Attach TASummary to", obsProposal});
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning(unknownEntityException.getMessage());
        }
    }

    private void generateAndAttachPdf(ObsProposal obsProposal) throws UnknownEntityException {
        DocumentLink documentLink;
        DocumentLink documentLink2;
        File file;
        DocumentLink documentLink3;
        if (obsProposal == null) {
            return;
        }
        ObsAttachment obsAttachment = obsProposal.getDocuments();
        if (obsAttachment == null) {
            obsAttachment = ObsAttachment.createObsAttachment();
            obsProposal.setDocuments(obsAttachment);
        }
        if ((documentLink3 = obsAttachment.getDocumentLink(DocumentLink.DOCUMENTCLASS_TA_COVERPAGE)) != null) {
            obsAttachment.removeDocumentLink(documentLink3);
        }
        if ((file = this.generateTACoverPdf(obsProposal)) != null) {
            obsAttachment.attachDocument(file, DocumentLink.DOCUMENTCLASS_TA_COVERPAGE);
        }
        if ((documentLink2 = obsAttachment.getDocumentLink(DocumentLink.DOCUMENTCLASS_TA_SCIENCEGOALS)) != null) {
            obsAttachment.removeDocumentLink(documentLink2);
        }
        if ((file = this.generateTAScienceGoalsPdf(obsProposal)) != null && file.length() > 0L) {
            obsAttachment.attachDocument(file, DocumentLink.DOCUMENTCLASS_TA_SCIENCEGOALS);
        }
        if ((documentLink = obsAttachment.getDocumentLink(DocumentLink.DOCUMENTCLASS_TA_FLAGSHEET)) != null) {
            obsAttachment.removeDocumentLink(documentLink);
        }
    }

    private String makeUniqueName(ObsProposal obsProposal) {
        String string = obsProposal.getPrincipalInvestigator().getUserId();
        String string2 = obsProposal.getTitle();
        string = string.replaceAll("\\W", "");
        string2 = string2.replaceAll("\\W", "");
        int n = Math.min(15, string2.length());
        string2 = string2.substring(0, n);
        String string3 = string + "_" + string2 + "_";
        return string3;
    }

    private File generateTACoverPdf(ObsProposal obsProposal) {
        File file;
        Object object;
        FeedbackSummaryObsProposal feedbackSummaryObsProposal = new FeedbackSummaryObsProposal(obsProposal);
        try {
            object = this.makeUniqueName(obsProposal) + TA_COVER_NAME;
            file = new File(FileUtilities.getTmpDir(), (String)object);
        }
        catch (IOException iOException) {
            Log.logger((Object)this).warning(iOException.getMessage());
            return null;
        }
        file.deleteOnExit();
        object = feedbackSummaryObsProposal.getPdfExporter();
        object.exportToPdf(file);
        return file;
    }

    private File generateTAScienceGoalsPdf(ObsProposal obsProposal) {
        File file;
        Object object;
        ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator(obsProposal, true);
        FeedbackSummarySgCollection feedbackSummarySgCollection = new FeedbackSummarySgCollection(obsProposal, obsProposalScienceGoalNavigator);
        try {
            object = this.makeUniqueName(obsProposal) + TA_SCIGOALS_NAME;
            file = new File(FileUtilities.getTmpDir(), (String)object);
        }
        catch (IOException iOException) {
            Log.logger((Object)this).warning(iOException.getMessage());
            return null;
        }
        file.deleteOnExit();
        object = feedbackSummarySgCollection.getPdfExporter();
        object.exportToPdf(file);
        return file;
    }
}

