/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.CalToolInteractor;
import alma.obsprep.ot.actions.CalToolPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Status;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.help.CSH;
import javax.swing.JFrame;

public class CalTool
extends OTAction
implements CalToolInteractor,
EventReceiver {
    JFrame frame;
    protected BusinessObject m_selectedBO = null;
    protected ProjectTreeNode m_selectedNode = null;
    private final QuerySourceAdapter adapter = new QuerySourceAdapter(QuerySource.createQuerySource());
    private final CalibratorExpertModel m_model = new CalibratorExpertModel(this.adapter);
    private final CalibratorExpertEditor m_editor = new CalibratorExpertEditor(this.m_model);
    private final CalibratorExpertController m_controller = new CalibratorExpertController();

    public CalTool(ProjectTree projectTree) {
        this.adapter.setRadius(10.0);
        this.adapter.setMaxSources(40);
        this.adapter.setMinFrequency(Frequency.createFrequencyGHZ(84.0));
        this.m_model.setDocument(this.adapter);
        this.m_model.subscribe(this.m_controller);
        this.m_editor.setPTree(projectTree);
        this.frame = GuiFactory.getFactory().giveFrame("ALMA Calibrator Selection Tool");
        this.frame.getContentPane().add(this.m_editor);
        this.frame.pack();
        CSH.setHelpIDString((Component)this.frame, (String)"TOC-Tools and Simulators-Calibrator Selection Tool");
        CalToolPerformer calToolPerformer = new CalToolPerformer(this);
        this.setPerformer(calToolPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public void showPanel() {
        this.m_editor.updateCoordinates();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width * 2 / 3;
        int n2 = this.frame.getPreferredSize().height;
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        this.frame.setSize(n, n2);
        this.frame.setLocation(n3, n4);
        this.frame.setVisible(true);
    }

    private void setEnableFor(BusinessObject businessObject) {
        if (this.isPhaseIProject(businessObject)) {
            this.setVisible(false);
            this.setEnabled(false);
        } else {
            this.setVisible(true);
            this.setEnabled(true);
        }
    }

    private boolean isPhaseIProject(BusinessObject businessObject) {
        ObsProject obsProject = businessObject.findProject();
        if (obsProject == null) {
            return false;
        }
        return obsProject.getStatus() == Status.STATE_NEWPHASE1 || obsProject.getStatus() == Status.STATE_PHASE1SUBMITTED;
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_selectedNode = (ProjectTreeNode)event.getSource();
        this.m_selectedBO = (BusinessObject)this.m_selectedNode.getUserObject();
        this.setEnableFor(this.m_selectedBO);
    }
}

