/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.actions.DisplayProjectTimeSummaryInteractor;
import alma.obsprep.ot.actions.DisplayProjectTimeSummaryPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.editors.sciencegoals.StandardProjectTimeEstimateSummary;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.util.GUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DisplayProjectTimeSummary
extends OTAction
implements DisplayProjectTimeSummaryInteractor {
    private ProjectTree oustree;
    private ObservingToolGui gui;

    public DisplayProjectTimeSummary(ProjectTree projectTree, ObservingToolGui observingToolGui) {
        this.oustree = projectTree;
        this.gui = observingToolGui;
        DisplayProjectTimeSummaryPerformer displayProjectTimeSummaryPerformer = new DisplayProjectTimeSummaryPerformer(this);
        this.setPerformer(displayProjectTimeSummaryPerformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display() {
        try {
            AbstractScienceGoal[] abstractScienceGoalArray = null;
            if (this.oustree == null || this.oustree.getProject() == null || this.oustree.getProject().getObsProposal() == null && this.oustree.getProject().getObsProgram() == null) {
                this.error("No observing proposal or observing project is defined");
                return;
            }
            if (this.oustree.getProject().getObsProgram() != null) {
                abstractScienceGoalArray = this.oustree.getProject().getObsProgram().getAbstractScienceGoal();
                if (abstractScienceGoalArray.length == 0) {
                    abstractScienceGoalArray = this.oustree.getProject().getObsProposal().getAbstractScienceGoal();
                }
            } else {
                abstractScienceGoalArray = this.oustree.getProject().getObsProposal().getAbstractScienceGoal();
            }
            assert (abstractScienceGoalArray != null);
            boolean bl = false;
            for (AbstractScienceGoal object : abstractScienceGoalArray) {
                if (!(object instanceof ScienceGoal)) continue;
                bl = true;
            }
            if (!bl) {
                this.error("There are no science goals defined");
                return;
            }
            StandardProjectTimeEstimateSummary standardProjectTimeEstimateSummary = new StandardProjectTimeEstimateSummary(abstractScienceGoalArray);
            this.busy(true);
            String string = null;
            try {
                string = standardProjectTimeEstimateSummary.info();
            }
            catch (Exception exception) {
                String string2 = "Unable to display project time summary :" + exception.getMessage();
                Log.logger(DisplayProjectTimeSummary.class).warning(string2);
                exception.printStackTrace();
                GUIUtilities.warning(null, string2);
            }
            finally {
                this.busy(false);
            }
            if (string != null) {
                JDialog jDialog = this.buildProjectSummaryWindow(string);
                jDialog.setVisible(true);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    public JDialog buildProjectSummaryWindow(String string) {
        JDialog jDialog = new JDialog();
        jDialog.setTitle("Project Summary");
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setDefaultCloseOperation(2);
        jDialog.setSize(1200, 800);
        GuiFactory guiFactory = GuiFactory.getFactory();
        JFrame jFrame = guiFactory.getParentWindow();
        jDialog.setLocationRelativeTo(jFrame);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        JFXPanel jFXPanel = new JFXPanel();
        Platform.runLater(() -> this.initFXHTMLPanel(jFXPanel, string));
        container.add((Component)jFXPanel, "Center");
        JButton jButton = new JButton("Close");
        jButton.addActionListener(actionEvent -> {
            jDialog.setVisible(false);
            jDialog.dispose();
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jButton, "Last");
        container.add((Component)jPanel, "Last");
        return jDialog;
    }

    private void initFXHTMLPanel(JFXPanel jFXPanel, String string) {
        Scene scene = this.createScene(string);
        jFXPanel.setScene(scene);
    }

    private Scene createScene(String string) {
        BorderPane borderPane = new BorderPane();
        Scene scene = new Scene((Parent)borderPane, (Paint)Color.WHITE);
        borderPane.setCenter((Node)new Browser(string));
        return scene;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
        this.busy(false);
    }

    @Override
    public void busy(boolean bl) {
        this.gui.showAsBusy(bl);
    }

    class Browser
    extends Region {
        final WebView browser = new WebView();
        final WebEngine webEngine = this.browser.getEngine();

        public Browser(String string) {
            this.webEngine.loadContent(string);
            this.getChildren().add((Object)this.browser);
        }

        protected void layoutChildren() {
            double d = this.getWidth();
            double d2 = this.getHeight();
            this.layoutInArea((Node)this.browser, 0.0, 0.0, d, d2, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }
}

