/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.XmlConversionException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.ExportInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.MendMyStruct;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ExportPerformer
extends Performer {
    public ExportPerformer(ExportInteractor exportInteractor) {
        super(exportInteractor);
    }

    @Override
    public void perform() {
        ExportInteractor exportInteractor = (ExportInteractor)this.getGui();
        File file = exportInteractor.getExportPathname();
        if (file == null) {
            return;
        }
        ObsProject obsProject = exportInteractor.getItemToExport();
        try {
            String string = file.getCanonicalPath();
            File file2 = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            MendMyStruct.sanitizeEntityRefs(obsProject);
            ImpexFactory.exportProject(obsProject, fileOutputStream);
            exportInteractor.exportDone(obsProject, file);
            ActionLog.performed("Save", obsProject, "to disk");
        }
        catch (IOException iOException) {
            exportInteractor.error("I/O error: " + iOException.getMessage());
        }
        catch (UnknownEntityException unknownEntityException) {
            exportInteractor.error("Entity error: " + unknownEntityException.getMessage());
        }
        catch (EntityException entityException) {
            exportInteractor.error("Entity error: " + entityException.getMessage());
        }
        catch (XmlConversionException xmlConversionException) {
            exportInteractor.error("XmlConversion error: " + xmlConversionException.getMessage());
        }
    }
}

