/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.data.DocumentLinkData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.AttachTASummaryInteractor;
import alma.obsprep.ot.actions.AttachTASummaryPerformer;
import alma.obsprep.ot.actions.GenerateWholePDFInteractor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GenerateWholePDFPerformer
extends AttachTASummaryPerformer {
    private static DialogId DIALOG_OVERWRITE_FILE = new DialogId("WholePDF.OverwriteFile");
    String[] documents = new String[]{DocumentLinkData.DOCUMENTCLASS_TA_COVERPAGE, DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE, DocumentLinkData.DOCUMENTCLASS_TA_SCIENCEGOALS};

    public GenerateWholePDFPerformer(AttachTASummaryInteractor attachTASummaryInteractor) {
        super(attachTASummaryInteractor);
    }

    @Override
    public void perform() {
        GenerateWholePDFInteractor generateWholePDFInteractor = (GenerateWholePDFInteractor)this.getGui();
        ObsProposal obsProposal = generateWholePDFInteractor.getProposal();
        try {
            super.perform();
            this.generateAndAttachPdf(obsProposal);
            ActionLog.performed(new Object[]{"Generate PDFs for", obsProposal});
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning(unknownEntityException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAndAttachPdf(ObsProposal obsProposal) throws UnknownEntityException {
        File file = this.selectOutputPDFName();
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        String string2 = FileUtilities.getExtension(string);
        if (string2 == null || !string2.equals("pdf")) {
            string = string + ".pdf";
        }
        PdfCopy pdfCopy = null;
        Document document = new Document();
        try {
            pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream(string));
            document.open();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.logger((Object)this).warning(fileNotFoundException.getMessage());
            GUIUtilities.warning(null, fileNotFoundException.getMessage());
            return;
        }
        catch (DocumentException documentException) {
            Log.logger((Object)this).warning(documentException.getMessage());
            GUIUtilities.warning(null, documentException.getMessage());
            return;
        }
        DocumentLink documentLink = null;
        PdfReader pdfReader = null;
        for (String string3 : this.documents) {
            File file2;
            String string4;
            documentLink = obsProposal.getDocuments().gettrueDocumentLink(string3);
            if (documentLink == null || (string4 = documentLink.getFileName()) == null || string4.length() == 0) continue;
            try {
                file2 = documentLink.getCacheFile();
            }
            catch (IOException iOException) {
                Log.logger((Object)this).warning(iOException.getMessage());
                GUIUtilities.warning(null, iOException.getMessage());
                continue;
            }
            if (file2 == null) continue;
            try {
                String string5 = file2.getAbsolutePath();
                pdfReader = new PdfReader(string5);
                pdfCopy.addDocument(pdfReader);
            }
            catch (IOException iOException) {
                Log.logger((Object)this).warning(iOException.getMessage());
                GUIUtilities.warning(null, iOException.getMessage());
            }
            catch (DocumentException documentException) {
                Log.logger((Object)this).warning(documentException.getMessage());
                GUIUtilities.warning(null, documentException.getMessage());
            }
            finally {
                if (pdfReader != null) {
                    try {
                        pdfCopy.freeReader(pdfReader);
                    }
                    catch (IOException iOException) {
                        GUIUtilities.warning(null, iOException.getMessage());
                    }
                }
                pdfReader.close();
            }
        }
        document.close();
        if (pdfCopy != null) {
            try {
                pdfCopy.close();
            }
            catch (Exception exception) {
                GUIUtilities.warning(null, exception.getMessage());
            }
        }
    }

    public File selectOutputPDFName() {
        File file;
        block2: {
            int n;
            file = null;
            JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser("pdf");
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("PDF file", "pdf");
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            do {
                int n2 = jFileChooser.showSaveDialog(null);
                file = jFileChooser.getSelectedFile();
                if (n2 != 0 || file == null) {
                    return null;
                }
                if (!file.exists() || (n = GUIUtilities.offer(DIALOG_OVERWRITE_FILE, "File '" + file.getAbsolutePath() + "' already exists, do you want to overwrite it?", "Yes", "No", "Cancel")) == 0) break block2;
            } while (n == 1);
            return null;
        }
        return file;
    }
}

