/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.ImportInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.exolab.castor.xml.XMLException;

public class ImportPerformer
extends Performer {
    private boolean showsConfirmationDialog = true;

    public ImportPerformer(ImportInteractor importInteractor) {
        super(importInteractor);
    }

    @Override
    public void perform() {
        ImportInteractor importInteractor = (ImportInteractor)this.getGui();
        URL uRL = importInteractor.getImportURL();
        if (uRL == null) {
            return;
        }
        String string = FileUtilities.getExtension(uRL.toExternalForm());
        if (!"aot".equals(string)) {
            importInteractor.error("Can only import ALMA OT (*.aot) files");
            return;
        }
        ObsProject obsProject = null;
        try {
            obsProject = ImpexFactory.importObsProject(uRL, this.showsConfirmationDialog);
        }
        catch (PersistenceException persistenceException) {
            importInteractor.error("Usage error: " + persistenceException.getMessage());
        }
        catch (IOException iOException) {
            importInteractor.error("I/O error: " + iOException.getMessage());
        }
        catch (XMLException xMLException) {
            importInteractor.error("XML (syntax or validity) error: " + xMLException.getMessage());
        }
        catch (UnknownEntityPartException unknownEntityPartException) {
            importInteractor.error("Data integrity error: " + unknownEntityPartException.getMessage());
        }
        if (obsProject == null) {
            return;
        }
        obsProject.getObsProgram();
        File file = null;
        String string2 = uRL.toExternalForm();
        if (string2.startsWith("file:")) {
            file = new File(string2.substring(5));
        }
        importInteractor.display(obsProject, file);
        ActionLog.performed("Open", obsProject, "from disk");
    }

    public void setShowsConfirmationDialog(boolean bl) {
        this.showsConfirmationDialog = bl;
    }
}

