/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.ImportBase;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.ObservingToolGuiProjectCompartment;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.MiscUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.tree.TreePath;

public class ImportStandardLibrary
extends ImportBase {
    private ObsProject standardLibrary;

    public ImportStandardLibrary(ObservingToolGui observingToolGui) {
        super(observingToolGui);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment : this.gui.allProjectCompartments()) {
            if (observingToolGuiProjectCompartment.getProjectTreePanels().getObsProject() != this.standardLibrary) continue;
            this.gui.bringToFront(this.standardLibrary);
            return;
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public URL getImportURL() {
        URL uRL = MiscUtils.findResource(null, "config/OTStandardLibrary.aot");
        if (uRL == null) {
            Log.logger((Object)this).info("Cannot open the Standard Library, it is not available!");
        }
        return uRL;
    }

    @Override
    public void display(ObsProject obsProject, File file) {
        this.standardLibrary = obsProject;
        ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.gui.addSecondaryProject(obsProject, file, true);
        ProjectTree projectTree = observingToolGuiProjectCompartment.getProjectTreePanels().getPhase1Tree();
        ProjectTreeNode projectTreeNode = projectTree.findNodeBelow(projectTree.getTop(), PhaseISciencePlanCollection.class);
        if (projectTreeNode != null) {
            TreePath treePath = new TreePath(projectTreeNode.getPath());
            projectTree.getTree().expandPath(treePath);
        }
    }
}

