/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.actions.PostRetrievalActionInterface;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.services.userlookup.User;
import alma.obsprep.services.userlookup.UserLookup;
import alma.obsprep.services.userlookup.UserLookupException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class ProjectRepositoryPerformer
extends Performer
implements Performer.Async2,
PostRetrievalActionInterface {
    private final ProjectRepository projectRepository;

    public ProjectRepositoryPerformer(Interactor interactor, ProjectRepository projectRepository) {
        super(interactor);
        this.projectRepository = projectRepository;
    }

    @Override
    public abstract void perform();

    protected ProjectRepository projectRepository() {
        return this.projectRepository;
    }

    protected boolean updateExecutivesOfInvestigators(ObsProject obsProject) throws UnknownEntityException, UserLookupException {
        boolean bl = false;
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProject");
        }
        UserLookup userLookup = ObservingToolController.getMyInstance().getUserLookup();
        if (userLookup == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: userLookup");
        }
        ArrayList<Investigator> arrayList = new ArrayList<Investigator>();
        ObsProposal obsProposal = obsProject.getObsProposal();
        arrayList.addAll(Arrays.asList(obsProposal.getCoInvestigator()));
        arrayList.addAll(Arrays.asList(obsProposal.getCoPrincipalInvestigator()));
        arrayList.add(obsProposal.getPrincipalInvestigator());
        String[] stringArray = (String[])arrayList.stream().map(investigator -> investigator.getUserId()).toArray(String[]::new);
        List<User> list = userLookup.matchUid(stringArray);
        for (Investigator investigator2 : arrayList) {
            Optional<User> optional = list.stream().filter(user -> investigator2.getUserId().equals(user.getUid())).findFirst();
            if (optional.isPresent()) {
                User user2 = optional.get();
                Investigator investigator3 = Investigator.createInvestigator(user2);
                String string = investigator3.getAllowedExec();
                String string2 = investigator2.getAllowedExec();
                if (!string2.equals(Investigator.ALLOWEDEXEC_NA_EA) && string.equals(Investigator.ALLOWEDEXEC_NA_EA)) {
                    Log.logger(ProjectRepositoryPerformer.class).fine("Investigator " + investigator2.getUserId() + " is now a Taiwanese investigator");
                    investigator2.setAssociatedExec(Investigator.ASSOCIATEDEXEC_EA);
                    investigator2.setAllowedExec(Investigator.ALLOWEDEXEC_NA_EA);
                    investigator2.setOrganisation(investigator3.getOrganisation());
                    investigator2.setOrganisationId(investigator3.getOrganisationId());
                    investigator2.setEMail(investigator3.getEMail());
                    investigator2.setTelephone(investigator3.getTelephone());
                    bl = true;
                } else {
                    investigator2.setAllowedExec(investigator3.getAllowedExec());
                    if (!investigator3.getAllowedExec().equals(Investigator.ALLOWEDEXEC_NA_EA)) {
                        investigator2.setAssociatedExec(investigator3.getAssociatedExec());
                    }
                    investigator2.setOrganisation(investigator3.getOrganisation());
                    investigator2.setOrganisationId(investigator3.getOrganisationId());
                    investigator2.setEMail(investigator3.getEMail());
                    investigator2.setTelephone(investigator3.getTelephone());
                }
                ObservingToolController.publishModelForBo(ObsProposal.class);
                continue;
            }
            Log.logger((Object)this).warning("Unable to find user " + investigator2.getEMail() + " in the user database - unable to check affiliation/executive for that user");
        }
        return bl;
    }
}

