/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.ResumeInteractor;
import alma.obsprep.ot.actions.ResumePerformer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.GUIUtilities;
import javax.swing.tree.TreePath;

public class Resume
extends OTAction
implements ResumeInteractor,
EventReceiver {
    private static DialogId DIALOG_RESUME = new DialogId("Resume.Confirm");
    private final ProjectTree projectTree;
    private BusinessObject selectedBO = null;
    private BusinessObject parentBO = null;
    private ProjectTreeNode selectedNode = null;
    private ProjectTreeNode parentNode = null;

    public Resume(ProjectTree projectTree) {
        this.projectTree = projectTree;
        ResumePerformer resumePerformer = new ResumePerformer(this);
        this.setPerformer(resumePerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public void receiveEvent(Event event) {
        this.selectedNode = (ProjectTreeNode)event.getSource();
        this.selectedBO = (BusinessObject)this.selectedNode.getUserObject();
        this.parentNode = (ProjectTreeNode)this.selectedNode.getParent();
        this.parentBO = this.parentNode != null ? (BusinessObject)this.parentNode.getUserObject() : null;
        boolean bl = this.enabledFor(this.selectedBO);
        this.setEnabled(bl);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.selectedBO;
    }

    @Override
    public BusinessObject getParentBO() {
        return this.parentBO;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public void info(String string) {
        GUIUtilities.info(null, string);
    }

    @Override
    public boolean confirmResume() {
        String string = String.format("<html>Do you want to resume<br><br>&nbsp;&nbsp;&nbsp;%s?</html>", this.selectedBO.toTreeString(1, false, false));
        return GUIUtilities.confirm(DIALOG_RESUME, string);
    }

    @Override
    public void updateDisplay(BusinessObject businessObject) {
        ProjectTreeNode projectTreeNode;
        if (businessObject != null && (projectTreeNode = this.projectTree.findNodeRepresentingBo(businessObject)) != null) {
            this.projectTree.select(new TreePath(projectTreeNode.getPath()));
        }
    }

    private boolean enabledFor(BusinessObject businessObject) {
        SchedBlock schedBlock;
        return businessObject instanceof SchedBlock && (schedBlock = (SchedBlock)businessObject).getStatus().equals(SchedBlock.STATUS_CSVSUSPENDED);
    }
}

