/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.RetrieveAsNewPerformer;
import alma.obsprep.ot.actions.RetrieveInteractor;
import alma.obsprep.ot.persistence.ProjectRepository;

public class RetrieveAsNewDDTProposalPerformer
extends RetrieveAsNewPerformer {
    public RetrieveAsNewDDTProposalPerformer(Interactor interactor, ProjectRepository projectRepository) {
        super(interactor, projectRepository);
    }

    @Override
    public boolean postRetrieveProcessing(ObsProject obsProject) {
        ObsProposal obsProposal;
        RetrieveInteractor retrieveInteractor = (RetrieveInteractor)this.getGui();
        if (!this.isProjectDDT && !retrieveInteractor.getUserConfirmation("Converting proposal to DDT. Cancel if this is not what you intended.", "Convert", "Cancel")) {
            return false;
        }
        this.recycleProjectAsNewProject(obsProject);
        try {
            obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            retrieveInteractor.error((Exception)((Object)unknownEntityException));
            return false;
        }
        obsProposal.setCycle(AlmaPolicies.getInstance().getDDTCycleNumber());
        obsProject.setIsDDT(true);
        obsProject.resetAfterImport();
        return true;
    }
}

