/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.RetrieveAsNew;
import alma.obsprep.ot.actions.RetrieveInteractor;
import alma.obsprep.ot.actions.RetrievePerformer;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.services.userlookup.UserLookupException;

public class RetrieveAsNewPerformer
extends RetrievePerformer {
    public RetrieveAsNewPerformer(Interactor interactor, ProjectRepository projectRepository) {
        super(interactor, projectRepository);
    }

    @Override
    public boolean postRetrieveProcessing(ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProject");
        }
        RetrieveInteractor retrieveInteractor = (RetrieveInteractor)this.getGui();
        if (this.isProjectDDT && !retrieveInteractor.getUserConfirmation("Converting DDT proposal to non-DDT. Cancel if this is not what you intended", "Convert", "Cancel")) {
            return false;
        }
        this.recycleProjectAsNewProject(obsProject);
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        try {
            obsProject.getObsProposal().setCycle(almaPolicies.getCycleNumber());
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(RetrieveAsNewPerformer.class).warning("Unable to get obsproposal " + unknownEntityException.getMessage());
        }
        obsProject.setIsDDT(false);
        obsProject.resetAfterImport();
        return true;
    }

    protected void recycleProjectAsNewProject(ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProject");
        }
        try {
            ObsProposal obsProposal = obsProject.getObsProposal();
            ObsProgram obsProgram = obsProject.getObsProgram();
            boolean bl = obsProgram.getAbstractScienceGoalCount() == obsProposal.getAbstractScienceGoalCount() || obsProposal.getAbstractScienceGoalCount() == 0;
            MendMyStruct.recycleProjectAsNewProject(obsProject, bl);
            if (this.updateExecutivesOfInvestigators(obsProject)) {
                RetrieveInteractor retrieveInteractor = (RetrieveInteractor)this.getGui();
                retrieveInteractor.info("Please check that the executive assigned to all Taiwanese investigators is correct.");
            }
        }
        catch (EntityException | UnknownEntityException | UserLookupException throwable) {
            Log.logger(RetrieveAsNew.class).warning("Unable to reset required XML elements when reusing an existing project " + throwable.getMessage());
        }
    }
}

