/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.actions.SetRepresentativeInteractor;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;

public class SetRepresentativePerformer
extends Performer {
    public SetRepresentativePerformer(SetRepresentativeInteractor setRepresentativeInteractor) {
        super(setRepresentativeInteractor);
    }

    private void performOnceConfirmed(SetRepresentativeInteractor setRepresentativeInteractor) {
        String string;
        Frequency frequency;
        SkyCoordinates skyCoordinates;
        Target target = setRepresentativeInteractor.getSelectedTarget();
        SchedBlock schedBlock = target.getSchedBlock();
        schedBlock.getSchedulingConstraints().setRepresentativeTarget(target);
        try {
            skyCoordinates = target.getFieldSource().getSourceCoordinates();
            schedBlock.getSchedulingConstraints().setRepresentativeCoordinates(skyCoordinates);
        }
        catch (Exception exception) {
            GUIUtilities.error(null, "Could not get coordinate information from representative target");
            skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
            schedBlock.getSchedulingConstraints().setRepresentativeCoordinates(skyCoordinates);
        }
        try {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            frequency = spectralSpec.getLO1Frequency().deepCopy();
            schedBlock.getSchedulingConstraints().setRepresentativeFrequency(frequency);
            string = spectralSpec.getFrequencySetup().getReceiverBand();
            schedBlock.getSchedulingConstraints().setRepresentativeReceiverBand(string);
        }
        catch (Exception exception) {
            GUIUtilities.error(null, "Could not get frequency information from representative target");
            frequency = Frequency.createFrequencyGHZ(0.0);
            schedBlock.getSchedulingConstraints().setRepresentativeFrequency(frequency);
            string = FrequencySetup.RECEIVERBAND_UNDEFINED;
            schedBlock.getSchedulingConstraints().setRepresentativeReceiverBand(string);
        }
        ActionLog.performed(new Object[]{"Set Representatives on", schedBlock, "to", skyCoordinates, frequency, string});
    }

    @Override
    public void perform() {
        Target target;
        SetRepresentativeInteractor setRepresentativeInteractor = (SetRepresentativeInteractor)this.getGui();
        if (setRepresentativeInteractor.confirmSet((BusinessObject)(target = setRepresentativeInteractor.getSelectedTarget()))) {
            this.performOnceConfirmed(setRepresentativeInteractor);
        }
    }
}

