/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.guiutil.mvc.widgets.IndeterminateProgressMonitor;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.StoreInteractor;
import alma.obsprep.ot.actions.StorePerformer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.submission.RemoteProgressListener;
import alma.obsprep.services.summaryfeedback.ConguratulationsDialog;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.IHelpfulError;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.JobUtility;
import java.io.File;

public class Store
extends OTAction
implements StoreInteractor {
    private static DialogId DIALOG_SAVE_CURRENT_PROJECT = new DialogId("Store.SaveCurrentProject", "Save current project before creating new project");
    private static final String SAVE_OR_DISCARD_CHANGES = "Please now save this proposal to disk to ensure that any future updates\nof your proposal before the deadline are submitted correctly";
    private final ObservingToolGui gui;
    private final boolean asNew;
    private final ProjectRepository.StoreVariant variant;
    private static final DialogId DIALOG_SAVE_AS_NEW = new DialogId("Store.ConfirmSaveAsNew");
    private volatile IndeterminateProgressMonitor progressMonitor;
    private final String PROGRESS_MONITOR_MESSAGE = "Submitting Project...";
    private RemoteProgressListener m_progressListener = new RemoteProgressListener(){

        @Override
        public void remoteProgress(int n, int n2, String string) {
            if (Store.this.progressMonitor != null) {
                Store.this.setProgressNote(true, "Server " + string);
            }
        }
    };

    public Store(ObservingToolController observingToolController, ObservingToolGui observingToolGui, boolean bl, ProjectRepository projectRepository) {
        this.gui = observingToolGui;
        this.asNew = bl;
        this.variant = ProjectRepository.StoreVariant.submit;
        UserAuthenticator userAuthenticator = null;
        if (observingToolController != null) {
            userAuthenticator = observingToolController.getUserAuthenticator();
        }
        RoleDirectoryService roleDirectoryService = null;
        if (observingToolController != null) {
            roleDirectoryService = observingToolController.getRoleDirectory();
        }
        StorePerformer storePerformer = new StorePerformer(this, projectRepository, userAuthenticator, roleDirectoryService);
        this.setPerformer(storePerformer);
        this.setEnabled(projectRepository != null);
    }

    @Override
    public void error(Exception exception) {
        String string;
        String string2 = string = exception instanceof IHelpfulError ? ((IHelpfulError)((Object)exception)).getUserMeaning() : exception.getMessage();
        if (string == null) {
            string = "store failed";
        }
        GUIUtilities.error(null, "Store operation cancelled: " + string, exception);
    }

    @Override
    public ObsProject duplicate(ObsProject obsProject) {
        return null;
    }

    @Override
    public void info(String string) {
        GUIUtilities.info(null, string);
    }

    @Override
    public void info(ObsProject obsProject) {
        ConguratulationsDialog.showDialog(null, obsProject);
    }

    @Override
    public boolean isAsNew() {
        return this.asNew;
    }

    @Override
    public boolean isValidationSkippable() {
        return false;
    }

    @Override
    public boolean confirmAsNew() {
        return GUIUtilities.confirm(DIALOG_SAVE_AS_NEW, "This will store your project as a completely new project. \nPlease confirm this is what you intend");
    }

    @Override
    public ProjectRepository.StoreVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean confirmSubmit(boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            string = string + "By submitting this" + (bl2 ? " DDT " : " ") + "proposal, the PI takes full responsibility for its contents" + "\n(including the names of the Co-Is) and agrees to act according to the ALMA policies" + "\nas stated in the Proposer's Guide and the Users' Policies document." + "\n\n";
        }
        string = string + "Please confirm you really want to submit this project to ALMA now.";
        return GUIUtilities.confirm(null, string);
    }

    @Override
    public boolean confirmSubmitAsNonPI(boolean bl) {
        String string = "You are about to submit a" + (bl ? " DDT " : " ") + "project for someone else." + "\nNote that there will be no email sent to the PI/CoIs." + "\n\nPlease confirm you want to submit this project now.";
        return GUIUtilities.confirm(null, string);
    }

    @Override
    public boolean confirmSubmitToNewerCycle(String string, boolean bl) {
        String string2 = !bl ? "This proposal was originally made for a different cycle " + string + "\nPlease confirm you want to submit it now to the current cycle." : "This proposal was previously submitted to a different cycle " + string + "\nSubmitting it now will turn it into a COMPLETELY NEW proposal, with a new project code." + "\nPlease confirm this is what you intend.";
        return GUIUtilities.confirm(null, string2);
    }

    @Override
    public boolean confirmSubmitForceUpdate() {
        int n = GUIUtilities.offer(null, "<html>A more recent version of this project was found in the archive.<br>The archive version will be overwritten if you continue with this submission.<br><br>Alternatively, you can cancel this submission and obtain the newer version from the archive.</html>", "Cancel", "Continue and submit older version");
        return n == 1;
    }

    @Override
    public boolean confirmResubmit() {
        if (this.asNew) {
            return true;
        }
        return GUIUtilities.offer(null, "<html>This project has already been submitted, do you want<br>to re-submit and <strong>overwrite</strong> the previous version?</html>", "Re-submit", "Cancel") == 0;
    }

    @Override
    public ObsProject getObsProject() {
        return this.gui.getPrimaryProject();
    }

    private void setProgressNote(boolean bl, final String string) {
        new AbstractJob("Update progress note", false, JobUtility.swing){

            @Override
            public void job() throws Exception {
                if (Store.this.progressMonitor != null) {
                    Store.this.progressMonitor.setNote(string);
                }
            }
        }.go();
    }

    @Override
    public void busy(boolean bl, String string) {
        try {
            if ("preparing" == string) {
                new AbstractJob("Open progress dialogue", false, JobUtility.swing){

                    @Override
                    public void job() {
                        Store.this.progressMonitor = Store.this.gui.showProgressMonitor(true, "Submitting Project...");
                    }
                }.go();
                this.setEnabled(false);
                return;
            }
            if ("finished" == string) {
                new AbstractJob("Close progress dialogue", false, JobUtility.swing){

                    @Override
                    public void job() {
                        if (Store.this.progressMonitor != null) {
                            Store.this.gui.showProgressMonitor(false, "Submitting Project...");
                        }
                        Store.this.progressMonitor = null;
                    }
                }.go();
                this.setEnabled(true);
                return;
            }
            String string2 = string;
            if ("storing" == string) {
                switch (this.variant) {
                    case forceupdate: 
                    case submit: {
                        string2 = "Sending Project to Server";
                        break;
                    }
                    case storeback: {
                        string2 = "Storing Project back";
                    }
                }
            }
            if ("validating" == string) {
                string2 = "Checking Validity of Project";
            }
            if (" " == string) {
                string2 = " ";
            }
            if ("summarising" == string) {
                string2 = "Generating Summaries";
            }
            if ("sanitising" == string) {
                string2 = "Conditioning Project";
            }
            if ("post-processing" == string) {
                string2 = "Submission Done";
            }
            this.setProgressNote(bl, string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public void displayAfterStore(ObsProject obsProject) {
        File file = this.gui.primaryProjectCompartment().getFileLocation();
        this.gui.setPrimaryProject(obsProject, file, true);
    }

    @Override
    public void saveProjectAfterStore() {
        if (this.gui != null) {
            int n = GUIUtilities.offer(DIALOG_SAVE_CURRENT_PROJECT, SAVE_OR_DISCARD_CHANGES, "Save", "Save As", "Do not Save");
            if (n == 0) {
                this.gui.primaryProjectCompartment().getProjectTiedActions().save.actionPerformed(null);
            } else if (n == 1) {
                this.gui.primaryProjectCompartment().getProjectTiedActions().saveAs.actionPerformed(null);
            }
        } else {
            GUIUtilities.info(DIALOG_SAVE_CURRENT_PROJECT, SAVE_OR_DISCARD_CHANGES);
        }
    }

    @Override
    public RemoteProgressListener getProgressListener() {
        return this.m_progressListener;
    }
}

