/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.ProjectRepositoryPerformer;
import alma.obsprep.ot.actions.StoreInteractor;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.ValidatorSet;
import alma.obsprep.ot.valdef.ValidatorSetFactory;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.StaleSBDetector;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.services.summaryfeedback.TASummaryGenerator;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class StorePerformer
extends ProjectRepositoryPerformer {
    private final RoleDirectoryService roleDirectory;
    private final UserAuthenticator userAuthenticator;
    private final Collection<String> csvStates = ObsProject.getCsvStates();
    private final Collection<String> operationalStates = ObsProject.getOperationalStates();
    static final String BUSY_START = "preparing";
    static final String BUSY_OTHER = " ";
    static final String BUSY_VALIDATING = "validating";
    static final String BUSY_SUMMARIES = "summarising";
    static final String BUSY_CONDITIONING = "sanitising";
    static final String BUSY_STORING_DATA = "storing";
    static final String BUSY_POSTPROCESS = "post-processing";
    static final String BUSY_END = "finished";

    public StorePerformer(StoreInteractor storeInteractor, ProjectRepository projectRepository, UserAuthenticator userAuthenticator, RoleDirectoryService roleDirectoryService) {
        super(storeInteractor, projectRepository);
        this.userAuthenticator = userAuthenticator;
        this.roleDirectory = roleDirectoryService;
        this.operationalStates.remove(ObsProject.STATUS_NEWPHASE1);
        this.operationalStates.remove(ObsProject.STATUS_NEWPHASE2);
    }

    private void checkDataOK(ObsProject obsProject, StoreInteractor storeInteractor) throws PersistenceException {
        StringBuffer stringBuffer = new StringBuffer();
        if (obsProject.getPI().equals("")) {
            stringBuffer.append("- No PI specified\n");
        }
        if (obsProject.getProjectName().equals("")) {
            stringBuffer.append("- No project name specified\n");
        }
        if (obsProject.getVersion().equals("")) {
            stringBuffer.append("- No project version specified\n");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "Your project is missing required data\n");
            String string = "Project is incomplete";
            String string2 = "Enter the required data, then retry";
            String string3 = string;
            throw new PersistenceException(string3, null, string, string2, stringBuffer.toString(), null);
        }
        String string = obsProject.getStatus();
        boolean bl = obsProject.getIsCommissioning();
        boolean bl2 = storeInteractor.isAsNew();
        if (string.equals(ObsProject.STATUS_REJECTED)) {
            throw new PersistenceException("Is rejected project: " + obsProject.getEntityID(), null, "This is a rejected project", "Sorry, you cannot submit a rejected project");
        }
        if (!bl2 && this.csvStates.contains(string) && !bl) {
            throw new PersistenceException("Is not a commissioning project: " + obsProject.getEntityID(), null, "Cannot migrate a commisioning project to the operational lifecycle.", "You must use 'Submit as New', or re-enable the 'is Commissioning' flag");
        }
        if (!bl2 && this.operationalStates.contains(string) && bl) {
            throw new PersistenceException("Is a commissioning project: " + obsProject.getEntityID(), null, "Cannot migrate a normal project to the CSV lifecycle.", "You must use 'Submit as New', or disable the 'is Commissioning' flag");
        }
    }

    private void checkObjectionsAgainstUserSubmitting(ObsProject obsProject, StoreInteractor storeInteractor) throws PersistenceException, ConfirmationNotGivenException {
        Set<ScienceGoal> set;
        if (this.userAuthenticator == null) {
            return;
        }
        try {
            this.roleDirectory.ensureLoggedIn("Submitting a project to ALMA");
        }
        catch (IOException iOException) {
            String string = "Failure at login of user '" + this.userAuthenticator.getUsername() + "': " + iOException.getMessage();
            throw new PersistenceException(string, iOException);
        }
        if (!RoleDirectoryServiceHelper.isUserP2G() && !(set = this.isSBsNeedingToBeRefreshed(obsProject)).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("<html> The following science goals need their SBs regenerating: <P><ul>");
            set.stream().forEach(scienceGoal -> stringBuilder.append("<li>" + scienceGoal.getName() + "</li>"));
            stringBuilder.append("</ul></html>");
            throw new ConfirmationNotGivenException(stringBuilder.toString());
        }
        boolean bl = obsProject.getPI().equals(this.userAuthenticator.getUsername());
        try {
            if (!bl && !this.roleDirectory.canExecute(OTOperation.STORE_AS_NON_PI)) {
                if (obsProject.isProjectWithStatus(ObsProject.STATUS_PHASE2SUBMITTED, ObsProject.STATUS_APPROVED) && RoleDirectoryServiceHelper.isPhase2ProposalDelegate(obsProject)) {
                    return;
                }
                boolean bl2 = RoleDirectoryServiceHelper.isContactScientist(obsProject);
                String string = bl2 ? "Your user id. is that of a contact scientist for this proposal and you cannot resubmit it." : "User is not PI, User cannot " + OTOperation.STORE_AS_NON_PI.getDescription();
                throw new PersistenceException(string, null, "Your username and the project PI do not match", "Ensure you are the project PI or a phase 2 proposal delegate and your username is given in the Connection preferences.", "Only privileged users or Phase 2 proposal delegates can submit projects for other users.", null);
            }
        }
        catch (IOException iOException) {
            String string = "Error while determining privileges of user '" + this.userAuthenticator.getUsername() + "'";
            throw new PersistenceException(string, iOException);
        }
    }

    private Set<ScienceGoal> isSBsNeedingToBeRefreshed(ObsProject obsProject) {
        HashSet<ScienceGoal> hashSet = new HashSet<ScienceGoal>();
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProject");
        }
        ObsProgram obsProgram = obsProject.getObsProgram();
        if (obsProgram == null) {
            return hashSet;
        }
        StaleSBDetector staleSBDetector = StaleSBDetector.getInstance();
        for (ScienceGoal scienceGoal : obsProgram.getAbstractScienceGoalScienceGoal()) {
            for (SchedBlock schedBlock : SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal))) {
                if (!staleSBDetector.isSBNeedingRegenerating(schedBlock, scienceGoal) || hashSet.contains(scienceGoal)) continue;
                hashSet.add(scienceGoal);
            }
        }
        return hashSet;
    }

    private void generatePdfs(ObsProposal obsProposal) {
        obsProposal.getProposalFeedback().getTimeAllocationBreakdown();
        TASummaryGenerator.attachTASummary(obsProposal);
        Log.Logger logger = Log.logger((Object)this);
        TimeAllocationBreakdown timeAllocationBreakdown = obsProposal.getProposalFeedback().getTimeAllocationBreakdown();
        logger.info("TimeAllocationBreakdown " + (Object)((Object)timeAllocationBreakdown));
        if (!timeAllocationBreakdown.testExecutives()) {
            logger.warning("Invalid TimeAllocationBreakdown structure found.");
        }
        if (!timeAllocationBreakdown.testTotal()) {
            logger.warning("Invalid TimeAllocationBreakdown data found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        StoreInteractor storeInteractor = (StoreInteractor)this.getGui();
        Log.Logger logger = Log.logger((Object)this);
        try {
            Object object;
            boolean bl;
            boolean bl2;
            boolean bl3;
            Object object2;
            Object object3;
            storeInteractor.busy(false, BUSY_START);
            logger.finer("Storing project to repository");
            ObsProject obsProject = storeInteractor.getObsProject();
            boolean bl4 = storeInteractor.isAsNew();
            if (bl4 && !storeInteractor.confirmAsNew()) {
                throw new ConfirmationNotGivenException();
            }
            storeInteractor.busy(false, BUSY_OTHER);
            this.checkDataOK(obsProject, storeInteractor);
            this.checkObjectionsAgainstUserSubmitting(obsProject, storeInteractor);
            if (obsProject.getIsDDT() && obsProject.getStatus() == Status.STATE_PHASE1SUBMITTED) {
                storeInteractor.info("This DDT proposal has already been submitted.\nSorry, you cannot re-submit a DDT proposal nor use it as a basis for a new project");
                return;
            }
            boolean bl5 = obsProject.getStatus() == Status.STATE_NEWPHASE1 || obsProject.getStatus() == Status.STATE_PHASE1SUBMITTED;
            boolean bl6 = obsProject.getPI().equals(this.userAuthenticator.getUsername());
            if (bl6 && bl5 && this.updateExecutivesOfInvestigators(obsProject)) {
                GUIUtilities.warning(null, "One or more investigators have changed to a Taiwanese institute since their details were first entered. Please check that their Executives are set correctly and resubmit.");
                return;
            }
            boolean bl7 = storeInteractor.isValidationSkippable();
            if (bl7) {
                logger.info("Be aware that client-side validation on submission was skipped");
            } else {
                storeInteractor.busy(true, BUSY_VALIDATING);
                object3 = new DefaultProblemListModel();
                object2 = ValidatorSetFactory.createStandardValidatorSet();
                ((ValidatorSet)object2).validate((BusinessObject)obsProject, (ProblemListModel)object3);
                if (object3.hasErrorOrWorse()) {
                    String string = "project has validation errors";
                    String string2 = null;
                    String string3 = "This project cannot be submitted because it is invalid.";
                    String string4 = "Rerun validation and correct all errors, first. Then retry to submit.";
                    throw new PersistenceException(string, null, string2, string4, string3, null);
                }
            }
            storeInteractor.busy(false, BUSY_OTHER);
            if (bl5) {
                if (!bl4) {
                    object3 = obsProject.getObsProposal().getCycle();
                    if (obsProject.getIsDDT()) {
                        object2 = AlmaPolicies.getInstance().getDDTCycleNumber();
                        if (!((String)object3).equals(object2)) {
                            MendMyStruct.moveToCurrentCycle(obsProject, (String)object2);
                        }
                    } else {
                        object2 = AlmaPolicies.getInstance().getCycleNumber();
                        if (!((String)object3).equals(object2)) {
                            boolean bl8 = bl3 = obsProject.getStatus() == Status.STATE_PHASE1SUBMITTED;
                            if (!storeInteractor.confirmSubmitToNewerCycle((String)object3, bl3)) {
                                throw new ConfirmationNotGivenException("Submission of old project to new cycle cancelled");
                            }
                            MendMyStruct.moveToCurrentCycle(obsProject, (String)object2);
                            bl4 = true;
                        }
                    }
                }
                storeInteractor.busy(true, BUSY_SUMMARIES);
                this.generatePdfs(obsProject.getObsProposal());
            }
            storeInteractor.busy(true, BUSY_CONDITIONING);
            if (bl4) {
                try {
                    MendMyStruct.renewIds(obsProject, true);
                }
                catch (EntityException | UnknownEntityException throwable) {
                    logger.fine("Failure while renewing Entity-Ids of the project: " + throwable);
                }
                if (!ObsProject.STATUS_NEWPHASE1.equals(obsProject.getStatus())) {
                    if (ObsProject.STATUS_PHASE1SUBMITTED.equals(obsProject.getStatus())) {
                        MendMyStruct.resetStatusFromPhase1SubmittedToNewPhase1(obsProject);
                    } else {
                        MendMyStruct.resetStatusToNewPhase2(obsProject);
                    }
                }
                obsProject.clearSubmissionRecord();
            }
            boolean bl9 = !(bl2 = ObsProject.getSubmittableStates().contains(obsProject.getStatus()));
            boolean bl10 = bl3 = storeInteractor.getVariant() == ProjectRepository.StoreVariant.storeback;
            if (bl9) {
                // empty if block
            }
            if (bl9 && !storeInteractor.confirmResubmit()) {
                throw new ConfirmationNotGivenException();
            }
            if (!bl3 && bl2 && !bl4 && !storeInteractor.confirmSubmit(bl = ObsProject.STATUS_NEWPHASE1.equals(obsProject.getStatus()), obsProject.getIsDDT())) {
                throw new ConfirmationNotGivenException();
            }
            boolean bl11 = bl = this.userAuthenticator != null && !obsProject.getPI().equals(this.userAuthenticator.getUsername());
            if (bl && !storeInteractor.confirmSubmitAsNonPI(obsProject.getIsDDT())) {
                throw new ConfirmationNotGivenException();
            }
            if (!bl4) {
                object = obsProject.getStatus();
                if (((String)object).equals(Status.STATE_BROKEN)) {
                    try {
                        MendMyStruct.pushStatusFromBrokenToRepaired(obsProject);
                    }
                    catch (UnknownEntityException unknownEntityException) {
                        storeInteractor.error((Exception)((Object)unknownEntityException));
                    }
                } else if (((String)object).equals(Status.STATE_APPROVED)) {
                    obsProject.setStatus(Status.STATE_PHASE2SUBMITTED);
                }
            }
            try {
                MendMyStruct.renewIds(obsProject, false);
            }
            catch (EntityException | UnknownEntityException throwable) {
                logger.fine("Failure while randomising fake entity IDs: " + throwable);
            }
            try {
                object = obsProject.getObsProgram().getObsPlan();
                List<SchedBlock> list = ((ObsUnitSet)object).findSchedBlocks();
                String string = obsProject.getPI();
                for (SchedBlock schedBlock : list) {
                    schedBlock.setPIName(string);
                }
                MendMyStruct.sanitizeEntityRefs(obsProject);
            }
            catch (EntityException | UnknownEntityException throwable) {
                storeInteractor.error((Exception)throwable);
            }
            object = null;
            try {
                storeInteractor.busy(true, BUSY_STORING_DATA);
                object = this.projectRepository().store(obsProject, storeInteractor.getVariant(), storeInteractor.getProgressListener());
            }
            catch (PersistenceException persistenceException) {
                if (persistenceException.getErrorCode() != 409) {
                    storeInteractor.busy(false, BUSY_END);
                    throw persistenceException;
                }
                if (!storeInteractor.confirmSubmitForceUpdate()) {
                    storeInteractor.busy(false, BUSY_END);
                    throw new ConfirmationNotGivenException("Submission over conflicting version cancelled");
                }
                object = this.projectRepository().store(obsProject, ProjectRepository.StoreVariant.forceupdate, storeInteractor.getProgressListener());
            }
            ActionLog.performed("Submit", obsProject, "to archive");
            storeInteractor.busy(false, BUSY_POSTPROCESS);
            UserEditRestrictionController.getInstance().projectDocumentReset((ObsProject)object, new ImpexFactory.WorkingPersistenceData());
            StaleSBDetector.getInstance().resetSBFreshnessMap((ObsProject)object);
            storeInteractor.busy(false, BUSY_END);
            storeInteractor.info((ObsProject)object);
            storeInteractor.displayAfterStore((ObsProject)object);
            storeInteractor.saveProjectAfterStore();
        }
        catch (ConfirmationNotGivenException confirmationNotGivenException) {
            storeInteractor.busy(false, BUSY_END);
            logger.info(confirmationNotGivenException.getMessage());
            storeInteractor.info(confirmationNotGivenException.getMessage());
        }
        catch (Exception exception) {
            storeInteractor.busy(false, BUSY_END);
            logger.log(Level.SEVERE, "Encountered failure while storing the project: " + exception, (Throwable)exception);
            storeInteractor.error(exception);
        }
        finally {
            storeInteractor.busy(false, BUSY_END);
        }
    }

    private class ConfirmationNotGivenException
    extends Exception {
        ConfirmationNotGivenException() {
            super("Store cancelled by user");
        }

        ConfirmationNotGivenException(String string) {
            super(string);
        }
    }
}

