/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.boEditors;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.boEditors.ValueUnitPairVerifier;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.valuetypes.Frequency;
import javax.swing.JTextField;

public class FrequencyVerifier
extends ValueUnitPairVerifier {
    public static final double GHZ_MIN = 0.0;
    public static final double GHZ_MAX = 2000.0;
    private boolean validateReceiver;

    public FrequencyVerifier(ValueUnitPairEditor valueUnitPairEditor) {
        this(valueUnitPairEditor, true);
    }

    public FrequencyVerifier(ValueUnitPairEditor valueUnitPairEditor, boolean bl) {
        super(valueUnitPairEditor, (double)Double.MIN_VALUE, 2000.0);
        this.validateReceiver = bl;
    }

    public FrequencyVerifier(ValueUnitPairEditor valueUnitPairEditor, double d, double d2) {
        super(valueUnitPairEditor, d, d2);
        this.validateReceiver = false;
    }

    public FrequencyVerifier(ValueUnitPairEditor valueUnitPairEditor, double ... dArray) {
        super(valueUnitPairEditor, dArray);
        this.validateReceiver = false;
    }

    public Object _validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
        Double d;
        if (this.validateReceiver) {
            d = (Double)super.validate(jTextField);
            this.checkReceiverBand(d);
        } else {
            d = (Double)super.validate(jTextField);
        }
        return d;
    }

    protected void checkReceiverBand(Double d) throws OutOfRangeException {
        ValueUnitPair valueUnitPair = (ValueUnitPair)this.vuped.getModel().getDocument();
        double d2 = Frequency.createFrequency((double)d, (String)valueUnitPair.getUnit()).getContentInGHz();
        if (d2 != 0.0) {
            try {
                String string = ReceiverBand.getReceiverBandName(d2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                stringBuilder.append(illegalArgumentException.getMessage().replaceAll("\n", "<br>"));
                stringBuilder.append("</html>");
                throw new OutOfRangeException(stringBuilder.toString());
            }
        }
    }

    @Override
    public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
        try {
            return this._validate(jTextField);
        }
        catch (NumberFormatException numberFormatException) {
            this.vuped.flashBackground();
            throw numberFormatException;
        }
        catch (OutOfRangeException outOfRangeException) {
            this.vuped.flashBackground();
            throw new OutOfRangeException(outOfRangeException.getMessage());
        }
    }
}

