/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.investigator;

import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.ot.editors.investigator.InvestigatorsEditor;
import alma.obsprep.ot.editors.investigator.TableInvestigator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class InvestigatorsTableModel
extends AbstractTableModel {
    String[] columnNames = new String[]{"Type", "Full name", "Email", "Affiliation", "ALMA ID", "Executive"};
    LinkedList<TableInvestigator> investigators = new LinkedList();

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.investigators.size();
    }

    public TableInvestigator getUserAt(int n) {
        return this.investigators.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TableInvestigator tableInvestigator = this.getUserAt(n);
        switch (n2) {
            case 0: {
                if (tableInvestigator.getUserType() == TableInvestigator.USER_TYPE.PI) {
                    return "PI";
                }
                if (tableInvestigator.getUserType() == TableInvestigator.USER_TYPE.COPI) {
                    return "CoPI";
                }
                return "CoI";
            }
            case 1: {
                return tableInvestigator.getFullName().equals("") ? "Not set" : tableInvestigator.getFullName();
            }
            case 2: {
                return tableInvestigator.getEMail().equals("") ? "Not set" : tableInvestigator.getEMail();
            }
            case 3: {
                return tableInvestigator.getOrganisation().equals("") ? "Not set" : tableInvestigator.getOrganisation();
            }
            case 4: {
                return tableInvestigator.getUserId().equals("") ? "Not set" : tableInvestigator.getUserId();
            }
            case 5: {
                String string = tableInvestigator.getAssociatedExec();
                return InvestigatorsEditor.Executive.fromSoValue(string);
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        TableInvestigator tableInvestigator;
        String string;
        return 5 == n2 && Investigator.ALLOWEDEXEC_NA_EA.equals(string = (tableInvestigator = this.getUserAt(n)).getAssociatedArc());
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        TableInvestigator tableInvestigator = this.getUserAt(n);
        if (object instanceof String) {
            String string = (String)object;
            switch (n2) {
                case 1: {
                    tableInvestigator.setFullName(string);
                    tableInvestigator.setVerfiedUser(false);
                    break;
                }
                case 2: {
                    tableInvestigator.setEMail(string);
                    tableInvestigator.setVerfiedUser(false);
                    break;
                }
                case 3: {
                    tableInvestigator.setOrganisation(string);
                    tableInvestigator.setVerfiedUser(false);
                    break;
                }
                case 4: {
                    tableInvestigator.setUserId(string);
                    tableInvestigator.setVerfiedUser(false);
                }
            }
            this.fireTableCellUpdated(n, n2);
        } else if (object instanceof InvestigatorsEditor.Executive) {
            InvestigatorsEditor.Executive executive = (InvestigatorsEditor.Executive)((Object)object);
            tableInvestigator.setAssociatedExec(executive.getSoValue());
            tableInvestigator.setVerfiedUser(false);
            this.fireTableCellUpdated(n, n2);
        } else {
            throw new IllegalArgumentException("Unhandled table value: " + object);
        }
    }

    public void clearAll() {
        this.investigators.clear();
    }

    public void setPi(Investigator investigator) {
        if (investigator != null) {
            this.removePi();
            this.investigators.push(new TableInvestigator(investigator, TableInvestigator.USER_TYPE.PI));
        }
        this.fireTableDataChanged();
    }

    public void setPi(List<Investigator> list) {
        if (list.size() > 0) {
            this.setPi(list.get(0));
        }
    }

    public void addCois(List<Investigator> list) {
        for (Investigator investigator : list) {
            this.investigators.add(new TableInvestigator(investigator, TableInvestigator.USER_TYPE.COI));
        }
        this.fireTableDataChanged();
    }

    public void removeCois(List<TableInvestigator> list) {
        for (TableInvestigator tableInvestigator : list) {
            if (tableInvestigator.getUserType() != TableInvestigator.USER_TYPE.COI) continue;
            this.investigators.remove(tableInvestigator);
        }
        this.fireTableDataChanged();
    }

    private int getIndexOfLastCoPI() {
        int n = 1;
        for (int i = this.investigators.size() - 1; i > 1; --i) {
            TableInvestigator tableInvestigator = this.investigators.get(i);
            if (!TableInvestigator.USER_TYPE.COPI.equals((Object)tableInvestigator.getUserType())) continue;
            n = i;
            break;
        }
        return n;
    }

    public void addCoPis(List<Investigator> list) {
        ArrayList<TableInvestigator> arrayList = new ArrayList<TableInvestigator>();
        for (Investigator investigator : list) {
            arrayList.add(new TableInvestigator(investigator, TableInvestigator.USER_TYPE.COPI));
        }
        int n = this.getIndexOfLastCoPI();
        this.investigators.addAll(n, arrayList);
        this.fireTableDataChanged();
    }

    public void removeCoPis(List<TableInvestigator> list) {
        for (TableInvestigator tableInvestigator : list) {
            if (tableInvestigator.getUserType() != TableInvestigator.USER_TYPE.COPI) continue;
            this.investigators.remove(tableInvestigator);
        }
        this.fireTableDataChanged();
    }

    private void removePi() {
        for (TableInvestigator tableInvestigator : this.investigators) {
            if (tableInvestigator.getUserType() != TableInvestigator.USER_TYPE.PI) continue;
            this.investigators.remove(tableInvestigator);
            return;
        }
    }
}

