/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.ot.editors.misc.CalendarButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CalendarPopup
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -8599066929113339509L;
    public static final Color DEFAULT_COLOR = Color.WHITE;
    public static final Color SELECT_COLOR = Color.RED;
    public static final Color HOVER_COLOR = new Color(65, 210, 240);
    public static final Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
    public static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    public static final String DATE_PARAM = "date";
    protected String dateParam = "date";
    public static final long KMS_IN_A_DAY = 86400000L;
    protected ZonedDateTime targetDate = null;
    protected ZonedDateTime targetPanelDate = null;
    protected ZonedDateTime selectedDate = null;
    protected ZonedDateTime nowDate = VisitConstraint.nowInUTC();
    protected boolean firstTime = true;
    protected int targetComponent = 0;
    protected ZonedDateTime calendar;
    protected StringBuffer stringBuffer = new StringBuffer();
    protected DateFormat dateFormat = DateFormat.getDateInstance(0);
    public static final String CALENDAR_ICON = "Calendar";
    private Color oldDayColor = DEFAULT_COLOR;
    protected boolean transferFocus = true;
    private JPanel monthPanel;
    private JButton previousMonthButton;
    private JLabel monthLabel;
    private JButton nextMonthButton;
    private JPanel yearPanel;
    private JButton previousYearButton;
    private JLabel yearLabel;
    private JButton nextYearButton;
    private JPanel panelDays;

    public CalendarPopup() {
    }

    public CalendarPopup(ZonedDateTime zonedDateTime) {
        this();
        this.init(null, zonedDateTime);
    }

    public CalendarPopup(String string, ZonedDateTime zonedDateTime) {
        this();
        this.init(string, zonedDateTime);
    }

    public void init(String string, ZonedDateTime zonedDateTime) {
        if (string != null) {
            this.dateParam = string;
        }
        this.initComponents();
        this.nowDate = VisitConstraint.nowInUTC();
        if (zonedDateTime == null) {
            zonedDateTime = this.nowDate;
        }
        this.selectedDate = zonedDateTime;
        this.calendar = zonedDateTime;
        this.targetDate = zonedDateTime.withHour(12).withMinute(0).withSecond(0);
        this.layoutCalendar(this.targetDate);
        if (zonedDateTime == this.nowDate) {
            this.selectedDate = this.targetDate;
        }
    }

    public void layoutCalendar(ZonedDateTime zonedDateTime) {
        this.targetPanelDate = zonedDateTime.withHour(12).withMinute(0).withSecond(0);
        ZonedDateTime zonedDateTime2 = this.targetPanelDate.withDayOfMonth(1);
        ZonedDateTime zonedDateTime3 = zonedDateTime2.plusMonths(1L).minusDays(1L);
        ZonedDateTime zonedDateTime4 = this.getFirstDateInCalendar(zonedDateTime2);
        ZonedDateTime zonedDateTime5 = ZonedDateTime.ofInstant(zonedDateTime4.toInstant(), ZoneOffset.UTC);
        this.targetComponent = zonedDateTime.getDayOfMonth();
        int n = zonedDateTime.getDayOfMonth();
        String string = String.valueOf(zonedDateTime.getYear());
        String string2 = zonedDateTime.getMonth().getDisplayName(TextStyle.SHORT, Locale.getDefault());
        this.monthLabel.setText(string2);
        this.yearLabel.setText(string);
        int n2 = 0;
        for (int i = 7; i < this.panelDays.getComponentCount(); ++i) {
            JLabel jLabel;
            if (n2 < 7) {
                jLabel = (JLabel)this.panelDays.getComponent(n2);
                String string3 = zonedDateTime5.getDayOfWeek().getDisplayName(TextStyle.SHORT_STANDALONE, Locale.getDefault());
                if (string3 != null && string3.length() > 0) {
                    jLabel.setText(string3.substring(0, 1));
                } else {
                    jLabel.setText(Integer.toString(n2));
                }
            }
            jLabel = (JLabel)this.panelDays.getComponent(i);
            int n3 = zonedDateTime5.getDayOfMonth();
            String string4 = String.valueOf(n3);
            jLabel.setText(string4);
            if (zonedDateTime5.isBefore(zonedDateTime2) || zonedDateTime5.isAfter(zonedDateTime3)) {
                jLabel.setForeground(Color.GRAY);
            } else {
                jLabel.setForeground(Color.BLACK);
            }
            jLabel.setBackground(this.panelDays.getBackground());
            if (n == n3 && zonedDateTime5.isBefore(zonedDateTime3) && zonedDateTime5.isAfter(zonedDateTime2)) {
                jLabel.setBackground(SELECT_COLOR);
            } else {
                jLabel.setBackground(DEFAULT_COLOR);
            }
            zonedDateTime5 = zonedDateTime5.plusDays(1L);
            if (this.firstTime) {
                jLabel.addMouseListener(this);
                jLabel.setName(Integer.toString(i - 7));
                jLabel.setBorder(EMPTY_BORDER);
                jLabel.setOpaque(true);
            }
            ++n2;
        }
        this.firstTime = false;
    }

    private void initComponents() {
        JLabel jLabel;
        int n;
        this.setLayout(new BoxLayout(this, 1));
        this.monthPanel = new JPanel();
        this.monthPanel.setLayout(new BoxLayout(this.monthPanel, 0));
        this.previousMonthButton = new JButton("<");
        this.previousMonthButton.setName("previousMonthButton");
        this.previousMonthButton.setMargin(new Insets(2, 2, 2, 2));
        this.previousMonthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPopup.this.prevMonthActionPerformed(actionEvent);
            }
        });
        this.monthPanel.add(this.previousMonthButton);
        this.monthPanel.add(Box.createHorizontalGlue());
        this.monthLabel = new JLabel("Month");
        this.monthLabel.setHorizontalAlignment(0);
        this.monthPanel.add(this.monthLabel);
        this.nextMonthButton = new JButton(">");
        this.nextMonthButton.setAlignmentX(1.0f);
        this.nextMonthButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextMonthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPopup.this.nextMonthActionPerformed(actionEvent);
            }
        });
        this.monthPanel.add(Box.createHorizontalGlue());
        this.monthPanel.add(this.nextMonthButton);
        this.add(this.monthPanel);
        this.yearPanel = new JPanel();
        this.yearPanel.setLayout(new BoxLayout(this.yearPanel, 0));
        this.previousYearButton = new JButton("<");
        this.previousYearButton.setMargin(new Insets(2, 2, 2, 2));
        this.previousYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPopup.this.prevYearActionPerformed(actionEvent);
            }
        });
        this.yearPanel.add(this.previousYearButton);
        this.yearPanel.add(Box.createHorizontalGlue());
        this.yearLabel = new JLabel("Year");
        this.yearLabel.setHorizontalAlignment(0);
        this.yearPanel.add(this.yearLabel);
        this.yearPanel.add(Box.createHorizontalGlue());
        this.nextYearButton = new JButton(">");
        this.nextYearButton.setAlignmentX(1.0f);
        this.nextYearButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPopup.this.nextYearActionPerformed(actionEvent);
            }
        });
        this.yearPanel.add(this.nextYearButton);
        this.add(this.yearPanel);
        this.panelDays = new JPanel();
        this.panelDays.setLayout(new GridLayout(7, 7));
        for (n = 1; n <= 7; ++n) {
            jLabel = new JLabel(Integer.toString(n));
            jLabel.setHorizontalAlignment(0);
            this.panelDays.add(jLabel);
        }
        for (n = 1; n <= 42; ++n) {
            jLabel = new JLabel();
            jLabel.setBorder(EMPTY_BORDER);
            jLabel.setHorizontalAlignment(0);
            this.panelDays.add(jLabel);
        }
        this.add(this.panelDays);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    private void nextMonthActionPerformed(ActionEvent actionEvent) {
        this.targetPanelDate = this.targetPanelDate.plusMonths(1L).withHour(12).withMinute(0).withSecond(0);
        this.layoutCalendar(this.targetPanelDate);
        this.calendar = this.targetPanelDate;
    }

    private void prevMonthActionPerformed(ActionEvent actionEvent) {
        this.targetPanelDate = this.targetPanelDate.minusMonths(1L).withHour(12).withMinute(0).withSecond(0);
        this.layoutCalendar(this.targetPanelDate);
        this.calendar = this.targetPanelDate;
    }

    private void nextYearActionPerformed(ActionEvent actionEvent) {
        this.targetPanelDate = this.targetPanelDate.plusYears(1L).withHour(12).withMinute(0).withSecond(0);
        this.layoutCalendar(this.targetPanelDate);
        this.calendar = this.targetPanelDate;
    }

    private void prevYearActionPerformed(ActionEvent actionEvent) {
        this.targetPanelDate = this.targetPanelDate.minusYears(1L).withHour(12).withMinute(0).withSecond(0);
        this.layoutCalendar(this.targetPanelDate);
        this.calendar = this.targetPanelDate;
    }

    public ZonedDateTime getFirstDateInCalendar(ZonedDateTime zonedDateTime) {
        int n = zonedDateTime.getDayOfWeek().getValue() < 7 ? zonedDateTime.getDayOfWeek().getValue() : 0;
        return zonedDateTime.minusDays(n);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Serializable serializable;
        ZonedDateTime zonedDateTime = this.targetPanelDate.withDayOfMonth(1);
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        int n = Integer.parseInt(jLabel.getText());
        ZonedDateTime zonedDateTime2 = this.selectedDate;
        int n2 = zonedDateTime2.getHour();
        int n3 = zonedDateTime2.getMinute();
        int n4 = zonedDateTime2.getSecond();
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            n2 = 12;
        }
        zonedDateTime2 = this.targetPanelDate.withDayOfMonth(n).withHour(n2).withMinute(n3);
        JPopupMenu jPopupMenu = this.getJPopupMenu();
        if (jPopupMenu != null) {
            serializable = jPopupMenu.getInvoker();
            this.getParent().remove(this);
            Container container = jPopupMenu.getParent();
            jPopupMenu.setVisible(false);
            container.remove(jPopupMenu);
            if (serializable != null && this.transferFocus) {
                ((Component)serializable).transferFocus();
            }
        }
        serializable = this.selectedDate;
        if (this.selectedDate == this.targetDate) {
            serializable = null;
        }
        this.firePropertyChange(this.dateParam, serializable, zonedDateTime2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        this.oldDayColor = jLabel.getBackground();
        jLabel.setBackground(HOVER_COLOR);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        jLabel.setBackground(this.oldDayColor);
    }

    private JPopupMenu getJPopupMenu() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JPopupMenu)) continue;
            return (JPopupMenu)container;
        }
        return null;
    }

    public static CalendarPopup createCalendarPopup(ZonedDateTime zonedDateTime, Component component) {
        return CalendarPopup.createCalendarPopup(null, zonedDateTime, component);
    }

    public static CalendarPopup createCalendarPopup(String string, ZonedDateTime zonedDateTime, Component component) {
        JPopupMenu jPopupMenu;
        JPopupMenu jPopupMenu2 = jPopupMenu = new JPopupMenu();
        jPopupMenu2.setLayout(new BorderLayout());
        CalendarPopup calendarPopup = new CalendarPopup(string, zonedDateTime);
        jPopupMenu2.add((Component)calendarPopup, "Center");
        jPopupMenu.show(component, 0, component.getBounds().height);
        return calendarPopup;
    }

    public static JButton createCalendarButton(String string, ZonedDateTime zonedDateTime) {
        CalendarButton calendarButton = new CalendarButton(string, zonedDateTime);
        calendarButton.setMargin(NO_INSETS);
        calendarButton.setOpaque(false);
        return calendarButton;
    }

    public void setTransferFocus(boolean bl) {
        this.transferFocus = bl;
    }
}

