/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.misc.CalendarButton;
import alma.obsprep.ot.editors.obsproject.FinaliseEditingInterface;
import alma.obsprep.ot.gui.toplevel.InitServices;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class CompactIsoDatePicker
extends JPanel {
    private static final long serialVersionUID = 8657646270715252064L;
    private static final String isoDateTimeFieldToolTip = "<html><p>Times are to the nearest minute.</p><p>Click on the displayed date to change it.</p><p>Hours and Minutes can be entered either where they are displayed or by using the up and down arrows</p></html>";
    private static final String calendarButtonToolTip = "Click on date to select using calendar";
    private static final DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private ZonedDateTime calendar;
    private Editor editor;
    private FieldID fid;
    private JTextField isoDateTimeField;
    private CalendarButton calendarButton;
    private JSpinner dateSpinner;
    private JSpinner hourSpinner;
    private JSpinner minuteSpinner;
    private JLabel minuteLabel;
    private FinaliseEditingInterface parentEditor = null;
    private boolean isCloseButtonNeeded = false;

    public static ZonedDateTime convertStringToDateTime(String string) throws DateTimeParseException {
        return LocalDateTime.parse(string, dateTimeFormat).atZone(ZoneOffset.UTC);
    }

    private static ZonedDateTime convertStringToDate(String string) throws DateTimeParseException {
        LocalDate localDate = LocalDate.parse(string, dateFormat);
        LocalTime localTime = LocalTime.of(0, 0);
        return ZonedDateTime.of(localDate, localTime, ZoneOffset.UTC);
    }

    private static String convertDateTimeToString(ZonedDateTime zonedDateTime) throws DateTimeException {
        return zonedDateTime.format(dateTimeFormat);
    }

    public CompactIsoDatePicker(Editor editor, FieldID fieldID, ZonedDateTime zonedDateTime) {
        this.setupDatePicker(editor, fieldID, zonedDateTime);
    }

    public CompactIsoDatePicker(Editor editor, FieldID fieldID, String string, boolean bl) {
        ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDateTime(string);
        this.isCloseButtonNeeded = bl;
        this.setupDatePicker(editor, fieldID, zonedDateTime);
    }

    private void setupDatePicker(Editor editor, FieldID fieldID, ZonedDateTime zonedDateTime) {
        this.editor = editor;
        this.fid = fieldID;
        this.calendar = zonedDateTime;
        this.initComponents(zonedDateTime);
    }

    public JTextField getIsoDateTimeField() {
        return this.isoDateTimeField;
    }

    void initComponents(ZonedDateTime zonedDateTime) {
        String string = CompactIsoDatePicker.convertDateTimeToString(zonedDateTime);
        this.isoDateTimeField = new JTextField(string);
        this.isoDateTimeField.setVisible(false);
        this.isoDateTimeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                try {
                    ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDateTime(CompactIsoDatePicker.this.isoDateTimeField.getText());
                    CompactIsoDatePicker.this.setDateTime(zonedDateTime, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.calendarButton = new CalendarButton();
        this.calendarButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() instanceof ZonedDateTime) {
                    int n = (Integer)CompactIsoDatePicker.this.hourSpinner.getValue();
                    int n2 = (Integer)CompactIsoDatePicker.this.minuteSpinner.getValue();
                    ZonedDateTime zonedDateTime = CompactIsoDatePicker.this.calendarButton.getTargetDate();
                    ZonedDateTime zonedDateTime2 = ((ZonedDateTime)propertyChangeEvent.getNewValue()).withHour(n).withMinute(n2);
                    if (zonedDateTime == null) {
                        CompactIsoDatePicker.this.setDateTime(zonedDateTime2, true);
                    } else if (!zonedDateTime.equals(zonedDateTime2)) {
                        CompactIsoDatePicker.this.setDateTime(zonedDateTime2, true);
                    }
                }
            }
        });
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setValue(Date.from(zonedDateTime.toInstant()));
        spinnerDateModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CompactIsoDatePicker.this.calendar = this.getCalculatedTimeBasedOnSpinners();
                Log.logger((Object)this).info("State change triggered: calendar is now " + CompactIsoDatePicker.this.calendar);
                CompactIsoDatePicker.this.setDateTime(CompactIsoDatePicker.this.calendar, true);
            }

            public ZonedDateTime getCalculatedTimeBasedOnSpinners() {
                SpinnerDateModel spinnerDateModel = (SpinnerDateModel)CompactIsoDatePicker.this.dateSpinner.getModel();
                int n = (Integer)CompactIsoDatePicker.this.hourSpinner.getValue();
                int n2 = (Integer)CompactIsoDatePicker.this.minuteSpinner.getValue();
                LocalTime localTime = LocalTime.of(n, n2);
                LocalDate localDate = spinnerDateModel.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                ZonedDateTime zonedDateTime = ZonedDateTime.of(localDate, localTime, ZoneOffset.UTC);
                return zonedDateTime;
            }
        });
        this.dateSpinner = new JSpinner(spinnerDateModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.dateSpinner, "yyyy-MM-dd");
        this.dateSpinner.setEditor(dateEditor);
        this.dateSpinner.addChangeListener(changeEvent -> this.syncModelToDateSpinner());
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(12, 0, 23, 1);
        this.hourSpinner = new JSpinner(spinnerNumberModel);
        this.hourSpinner.addChangeListener(changeEvent -> this.syncModelToHourSpinner());
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.hourSpinner.getEditor();
        JFormattedTextField jFormattedTextField = numberEditor.getTextField();
        jFormattedTextField.setColumns(2);
        this.minuteLabel = new JLabel(":");
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(0, 0, 59, 1);
        this.minuteSpinner = new JSpinner(spinnerNumberModel2);
        this.minuteSpinner.addChangeListener(changeEvent -> this.syncModelToMinutesSpinner());
        JSpinner.NumberEditor numberEditor2 = (JSpinner.NumberEditor)this.minuteSpinner.getEditor();
        JFormattedTextField jFormattedTextField2 = numberEditor2.getTextField();
        jFormattedTextField2.setColumns(2);
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalGlue());
        this.add(this.isoDateTimeField);
        this.add(this.dateSpinner);
        this.add(this.hourSpinner);
        this.add(this.minuteLabel);
        this.add(this.minuteSpinner);
        this.add(this.calendarButton);
        this.calendarButton.setToolTipText(calendarButtonToolTip);
        this.setToolTipText(isoDateTimeFieldToolTip);
        this.initDateTime(zonedDateTime);
        if (this.isCloseButtonNeeded) {
            this.add(Box.createHorizontalGlue());
            JButton jButton = new JButton("Close");
            jButton.setName("AcceptDateChanges");
            jButton.setToolTipText("Accept the date changes");
            jButton.addActionListener(actionEvent -> {
                if (this.parentEditor != null) {
                    this.parentEditor.finaliseEditing();
                }
            });
            this.add(jButton);
        }
    }

    private void updateIsoDateTimeInModel() {
        if (this.editor != null && this.fid != null && this.isoDateTimeField.getText() != null) {
            this.editor.updateField(this.fid);
        }
    }

    private void setDateTime(ZonedDateTime zonedDateTime, boolean bl) {
        String string = "";
        if (zonedDateTime != null) {
            string = dateTimeFormat.format(zonedDateTime);
            Log.logger((Object)this).info("setting new datetime: dateTime=" + zonedDateTime + " ,  dateTimeString =" + string);
            if (this.calendar != zonedDateTime) {
                ((SpinnerDateModel)this.dateSpinner.getModel()).setValue(Date.from(zonedDateTime.toInstant()));
                this.calendar = zonedDateTime;
            }
            this.calendarButton.setTargetDate(zonedDateTime);
        }
        if (!string.equals(this.isoDateTimeField.getText())) {
            this.isoDateTimeField.setText(string);
            this.updateIsoDateTimeInModel();
        }
        if (bl) {
            this.setTimeSpinners(zonedDateTime);
        }
    }

    private void initDateTime(ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null) {
            ((SpinnerDateModel)this.dateSpinner.getModel()).setValue(Date.from(zonedDateTime.toInstant()));
            this.calendarButton.setTargetDate(zonedDateTime);
            if (this.calendar != zonedDateTime) {
                this.calendar = zonedDateTime;
            }
            this.calendarButton.setTargetDate(zonedDateTime);
        }
        this.setTimeSpinners(zonedDateTime);
    }

    public void setValid(Boolean bl) {
        Color color = bl != false ? Color.BLACK : Color.RED;
        for (Component component : this.getComponents()) {
            component.setForeground(color);
        }
    }

    private void setTimeSpinners(ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null) {
            this.calendar = zonedDateTime;
            this.hourSpinner.setValue(zonedDateTime.getHour());
            this.minuteSpinner.setValue(zonedDateTime.getMinute());
        }
    }

    public void commitChanges() {
        this.commitOutstandingChangesInEditor();
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.dateSpinner.getEditor();
        String string = dateEditor.getTextField().getText();
        try {
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                int n;
                Log.logger((Object)this).fine("Date changes committed" + string);
                ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDate(string);
                int n2 = (Integer)this.hourSpinner.getValue();
                boolean bl = false;
                if (n2 != zonedDateTime.getHour()) {
                    zonedDateTime = zonedDateTime.withHour(n2);
                    bl = true;
                }
                if ((n = ((Integer)this.minuteSpinner.getValue()).intValue()) != zonedDateTime.getMinute()) {
                    zonedDateTime = zonedDateTime.withMinute(n);
                    bl = true;
                }
                if (bl) {
                    this.setDateTime(zonedDateTime, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void commitOutstandingChangesInEditor() {
        try {
            this.hourSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            this.minuteSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            this.dateSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void syncModelToMinutesSpinner() {
        String string = this.isoDateTimeField.getText();
        Log.logger((Object)this).info("syncModelToMinutesSpinner : dateTimeString =" + string);
        try {
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDateTime(string);
                int n = (Integer)this.minuteSpinner.getValue();
                if (n != zonedDateTime.getMinute()) {
                    this.calendar = zonedDateTime = zonedDateTime.withMinute(n);
                    this.setDateTime(zonedDateTime, true);
                }
            }
        }
        catch (Exception exception) {
            Log.logger((Object)this).warning(exception.getMessage());
        }
    }

    private void syncModelToHourSpinner() {
        String string = this.isoDateTimeField.getText();
        try {
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                ZonedDateTime zonedDateTime = CompactIsoDatePicker.convertStringToDate(string);
                int n = (Integer)this.hourSpinner.getValue();
                if (n != this.calendar.getHour()) {
                    this.calendar = zonedDateTime = zonedDateTime.withHour(n);
                    this.setDateTime(zonedDateTime, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void syncModelToDateSpinner() {
        SpinnerModel spinnerModel = this.dateSpinner.getModel();
        if (spinnerModel instanceof SpinnerDateModel) {
            int n = (Integer)this.hourSpinner.getValue();
            int n2 = (Integer)this.minuteSpinner.getValue();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(((SpinnerDateModel)spinnerModel).getDate().toInstant(), ZoneOffset.UTC).withHour(n).withMinute(n2);
            if (this.calendar != zonedDateTime) {
                this.calendar = zonedDateTime;
                this.setDateTime(this.calendar, true);
            }
        }
    }

    public void setEditingCompletionListener(FinaliseEditingInterface finaliseEditingInterface) {
        this.parentEditor = finaliseEditingInterface;
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Date Picker");
        jFrame.setDefaultCloseOperation(3);
        CompactIsoDatePicker compactIsoDatePicker = new CompactIsoDatePicker(null, null, "2015-09-01T10:01:36.000Z", false);
        jFrame.getContentPane().add((Component)compactIsoDatePicker, "Center");
        jFrame.setLocationRelativeTo(null);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

