/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.misc.CalendarButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IsoDatePicker
extends JPanel {
    private static final long serialVersionUID = 2672151291869829764L;
    private static final String isoDateTimeFieldToolTip = "<html>ISO date time format YYYY-MM-DDThh:mm:ss.mmmZ<br>T is a delimeter between date and time<br>Z implies zero offset from UTC</html>";
    private static final String calendarButtonToolTip = "Select date using calendar";
    private static final String hourSpinnerToolTip = "Select hour of day";
    private static final String minuteSpinnerToolTip = "Select minute";
    private static final DateTimeFormatter almaDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private Editor editor;
    private FieldID fid;
    private JTextField isoDateTimeField;
    private CalendarButton calendarButton;
    private JLabel hourLabel;
    private JSpinner hourSpinner;
    private JLabel minuteLabel;
    private JSpinner minuteSpinner;

    public static ZonedDateTime convertStringToDate(String string) throws DateTimeParseException {
        return LocalDateTime.parse(string, almaDateFormat).atZone(ZoneOffset.UTC);
    }

    public static String convertDateToString(ZonedDateTime zonedDateTime) throws DateTimeException {
        return zonedDateTime.format(almaDateFormat);
    }

    public IsoDatePicker(Editor editor, FieldID fieldID) {
        this.editor = editor;
        this.fid = fieldID;
        this.initComponents();
    }

    public JTextField getIsoDateTimeField() {
        return this.isoDateTimeField;
    }

    void initComponents() {
        this.isoDateTimeField = new JTextField(20);
        this.isoDateTimeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                IsoDatePicker.this.setDateTime(IsoDatePicker.this.isoDateTimeField.getText());
            }
        });
        this.isoDateTimeField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IsoDatePicker.this.refresh();
            }
        });
        this.calendarButton = new CalendarButton();
        this.calendarButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() instanceof ZonedDateTime) {
                    ZonedDateTime zonedDateTime = IsoDatePicker.this.calendarButton.getTargetDate();
                    if (zonedDateTime == null) {
                        IsoDatePicker.this.setDateTime((ZonedDateTime)propertyChangeEvent.getNewValue());
                    } else if (!zonedDateTime.equals((ZonedDateTime)propertyChangeEvent.getNewValue())) {
                        IsoDatePicker.this.setDateTime((ZonedDateTime)propertyChangeEvent.getNewValue());
                    }
                }
            }
        });
        this.hourLabel = new JLabel("Hour");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(12, 0, 23, 1);
        this.hourSpinner = new JSpinner(spinnerNumberModel);
        this.hourSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = IsoDatePicker.this.isoDateTimeField.getText();
                try {
                    if (string != null && string.length() > 0) {
                        ZonedDateTime zonedDateTime = IsoDatePicker.convertStringToDate(string);
                        int n = (Integer)IsoDatePicker.this.hourSpinner.getValue();
                        if (n != zonedDateTime.getHour()) {
                            IsoDatePicker.this.setDateTime(zonedDateTime.withHour(n));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.minuteLabel = new JLabel("Min");
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(0, 0, 59, 1);
        this.minuteSpinner = new JSpinner(spinnerNumberModel2);
        this.minuteSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = IsoDatePicker.this.isoDateTimeField.getText();
                try {
                    if (string != null && string.length() > 0) {
                        ZonedDateTime zonedDateTime = IsoDatePicker.convertStringToDate(string);
                        int n = (Integer)IsoDatePicker.this.minuteSpinner.getValue();
                        if (n != zonedDateTime.getMinute()) {
                            IsoDatePicker.this.setDateTime(zonedDateTime.withMinute(n));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalGlue());
        this.add(this.isoDateTimeField);
        this.isoDateTimeField.setToolTipText(isoDateTimeFieldToolTip);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.calendarButton);
        this.calendarButton.setToolTipText(calendarButtonToolTip);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.hourLabel);
        this.hourLabel.setToolTipText(hourSpinnerToolTip);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.hourSpinner);
        this.hourSpinner.setToolTipText(hourSpinnerToolTip);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.minuteLabel);
        this.minuteLabel.setToolTipText(minuteSpinnerToolTip);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.minuteSpinner);
        this.minuteSpinner.setToolTipText(minuteSpinnerToolTip);
        this.setToolTipText(isoDateTimeFieldToolTip);
    }

    private void updateIsoDateTimeInModel() {
        if (this.editor != null && this.fid != null && this.isoDateTimeField.getText() != null) {
            this.editor.updateField(this.fid);
        }
    }

    private void setTimeSpinners(ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null) {
            this.hourSpinner.setValue(zonedDateTime.getHour());
            this.minuteSpinner.setValue(zonedDateTime.getMinute());
        }
    }

    public void refresh() {
        String string = this.isoDateTimeField.getText();
        try {
            if (string != null && string.length() > 0) {
                ZonedDateTime zonedDateTime = IsoDatePicker.convertStringToDate(string);
                this.hourSpinner.setValue(zonedDateTime.getHour());
                this.minuteSpinner.setValue(zonedDateTime.getMinute());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDateTime(String string) {
        ZonedDateTime zonedDateTime = null;
        try {
            if (string != null && string.length() > 0) {
                zonedDateTime = IsoDatePicker.convertStringToDate(string);
            }
        }
        catch (Exception exception) {
            zonedDateTime = null;
        }
        this.setDateTime(zonedDateTime);
    }

    public void setDateTime(ZonedDateTime zonedDateTime) {
        String string = "";
        if (zonedDateTime != null) {
            string = IsoDatePicker.convertDateToString(zonedDateTime);
        }
        this.isoDateTimeField.setText(string);
        this.calendarButton.setTargetDate(zonedDateTime);
        this.setTimeSpinners(zonedDateTime);
        this.updateIsoDateTimeInModel();
    }

    public void setSpinners(ZonedDateTime zonedDateTime) {
        this.setTimeSpinners(zonedDateTime);
    }

    public JSpinner getHourSpinner() {
        return this.hourSpinner;
    }

    public JSpinner getMinuteSpinner() {
        return this.minuteSpinner;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Date Picker");
        jFrame.setDefaultCloseOperation(3);
        IsoDatePicker isoDatePicker = new IsoDatePicker(null, null);
        JTextField jTextField = isoDatePicker.getIsoDateTimeField();
        jTextField.setText("2015-09-01T10:01:36.000");
        isoDatePicker.refresh();
        jFrame.getContentPane().add((Component)isoDatePicker, "Center");
        jFrame.setLocationRelativeTo(null);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public JLabel getHourLabel() {
        return this.hourLabel;
    }

    public JLabel getMinuteLabel() {
        return this.minuteLabel;
    }
}

