/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.BOCollection;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.annotations.FieldTargetDocument;
import alma.obsprep.bo.annotations.FieldTargetPart;
import alma.obsprep.bo.annotations.SummaryTable;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.DecValueCellEditor;
import alma.obsprep.ot.editors.misc.RAValueCellEditor;
import alma.obsprep.ot.editors.misc.SummaryTableEditorCellRenderer;
import alma.obsprep.ot.editors.misc.ValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.schedblock.NameResolver;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.factory.TableActionEvent;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.misc.SummaryTableModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.UserAngle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;

public class SummaryTableEditor
extends Editor {
    private final int TABLEHEIGHT = 400;
    public static final FieldID FID_TABLE = new FieldID("SummaryTableEditor.table");
    protected JLabel message;
    protected Table basicTable;
    private Box buttonBox;
    private JViewport formEditorPane = null;

    public SummaryTableEditor(SummaryTableModel summaryTableModel) {
        this.setModel(summaryTableModel);
        this.build();
        summaryTableModel.publish();
    }

    public SummaryTableEditor(Model model) {
        this((SummaryTableModel)model);
    }

    protected SummaryTableEditor() {
    }

    @Override
    protected void build() {
        this.setLayout(new BoxLayout(this, 3));
        this.basicTable = new Table();
        this.basicTable.setModel(this.getMyModel());
        this.basicTable.getTableHeader().setReorderingAllowed(false);
        this.initEvents(this.basicTable, FID_TABLE);
        this.message = new JLabel();
        this.setupCellEditorAndRenderer();
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.basicTable);
        this.add(this.message);
        this.add(scrollWhenFocusedPane);
        this.setupControlButtons();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SummaryTableEditor.this.getMyModel().getDocument() instanceof PhaseISciencePlanCollection && actionEvent instanceof TableActionEvent) {
                    TableActionEvent tableActionEvent = (TableActionEvent)actionEvent;
                    ScienceGoal scienceGoal = (ScienceGoal)SummaryTableEditor.this.getMyModel().get(tableActionEvent.getRowIndex());
                    ObservingToolController.getOTGui().jumpToBO((BusinessObject)scienceGoal);
                }
            }
        };
        this.basicTable.addActionListener(actionListener);
    }

    public void setMessage(String string) {
        this.message.setText(string);
    }

    private void setupCellEditorAndRenderer() {
        this.basicTable.setDefaultEditor(Double.class, new ValueCellEditor.Double());
        this.basicTable.setDefaultEditor(Integer.class, new ValueCellEditor.Integer());
        this.basicTable.setDefaultEditor(Longitude.class, new RAValueCellEditor());
        this.basicTable.setDefaultEditor(Latitude.class, new DecValueCellEditor());
        this.basicTable.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        this.basicTable.setDefaultEditor(Angle.class, new ValueUnitPairCellEditor.AngleEditor());
        this.basicTable.setDefaultEditor(UserAngle.class, new ValueUnitPairCellEditor.UserAngleEditor());
        this.basicTable.setDefaultEditor(Sensitivity.class, new ValueUnitPairCellEditor.SensitivityEditor());
        this.basicTable.setDefaultRenderer(Object.class, new SummaryTableEditorCellRenderer(this));
        this.basicTable.setDefaultRenderer(Integer.class, new SummaryTableEditorCellRenderer(this));
        this.basicTable.setDefaultRenderer(Double.class, new SummaryTableEditorCellRenderer(this));
        this.basicTable.setDefaultRenderer(Longitude.class, new SummaryTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object != null) {
                    try {
                        Longitude longitude = (Longitude)((Object)object);
                        string = longitude.toHHMMSS();
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        this.basicTable.setDefaultRenderer(Latitude.class, new SummaryTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object != null) {
                    try {
                        Latitude latitude = (Latitude)((Object)object);
                        string = latitude.toDDMMSS();
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
    }

    private void setupControlButtons() {
        this.buttonBox = Box.createHorizontalBox();
        JButton jButton = new JButton("Add Science Goal");
        jButton.setToolTipText("Add science goal");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservingToolGui observingToolGui = ObservingToolController.getMyInstance().getGui();
                Object object = SummaryTableEditor.this.getMyModel().getDocument();
                SummaryTableEditor.this.getMyModel().addnew();
                if (observingToolGui != null) {
                    try {
                        observingToolGui.jumpToBO((BusinessObject)object);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        });
        this.buttonBox.add(jButton);
        jButton = new JButton("Delete Science Goal");
        jButton.setToolTipText("Delete science goal");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = SummaryTableEditor.this.basicTable.getSelectedRows();
                SummaryTableEditor.this.getMyModel().deleteSelected(nArray);
                if (nArray.length != 0) {
                    int n = SummaryTableEditor.this.getMyModel().getRowCount() - 1;
                    if (nArray[0] < n) {
                        n = nArray[0];
                    }
                    SummaryTableEditor.this.basicTable.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        this.buttonBox.add(jButton);
        jButton = new JButton("Load Science Goal List");
        jButton.setToolTipText("Load a list of partially defined science goals from a file");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservingToolGui observingToolGui = ObservingToolController.getMyInstance().getGui();
                Object object = SummaryTableEditor.this.getMyModel().getDocument();
                SummaryTableEditor.this.loadFromFile();
                if (observingToolGui != null) {
                    try {
                        observingToolGui.jumpToBO((BusinessObject)object);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        });
        this.buttonBox.add(jButton);
        jButton = new JButton("Save Science Goal List (incomplete)");
        jButton.setToolTipText("Save the science goals to a file - note this does not  save all information!");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SummaryTableEditor.this.saveToFile();
            }
        });
        this.buttonBox.add(jButton);
        this.buttonBox.add(Box.createHorizontalStrut(10));
        jButton = new JButton("Resolve Targets");
        jButton.setToolTipText("Resolve target co-ordinates");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SummaryTableEditor.this.resolveSourceName();
            }
        });
        this.buttonBox.add(jButton);
        this.buttonBox.setVisible(false);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FID_TABLE) {
            this.updateColumns();
            this.updateButtonBox();
            return;
        }
        super.update(fieldID, object);
    }

    private void updateColumns() {
        for (int i = 0; i < this.getMyModel().getColumnCount(); ++i) {
            Object[] objectArray = this.getMyModel().getSummaryColumnItemList(i);
            if (objectArray == null) continue;
            TableColumn tableColumn = this.basicTable.getColumnModel().getColumn(i);
            tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(objectArray)));
        }
        ColumnResizer.initColumnSizes(this.basicTable, this.getMyModel().getLongValues());
    }

    private void updateButtonBox() {
        boolean bl = false;
        try {
            SummaryTable summaryTable = (SummaryTable)this.getMyModel().getDocument();
            if (summaryTable != null) {
                bl = summaryTable.showsControlButtons();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.buttonBox.setVisible(bl);
    }

    private SummaryTableModel getMyModel() {
        return (SummaryTableModel)this.getModel();
    }

    private void loadFromFile() {
        File file;
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
        jFileChooser.setDialogTitle("Read");
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()).exists()) {
            this.getMyModel().loadFromFile(file);
        }
    }

    private void saveToFile() {
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
        jFileChooser.setDialogTitle("Save");
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            int n2;
            Object object;
            Object object2;
            File file = jFileChooser.getSelectedFile();
            if (file.exists()) {
                object2 = "";
                try {
                    object2 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                object = "File " + (String)object2 + " already exists." + "\nDo you want to replace it?";
                n2 = GUIUtilities.confirm(null, (String)object) ? 1 : 0;
                if (n2 == 0) {
                    return;
                }
            }
            try {
                object2 = new FileOutputStream(file);
                object = new PrintWriter(new OutputStreamWriter((OutputStream)object2));
                n2 = this.getMyModel().getRowCount();
                for (int i = 0; i < n2; ++i) {
                    Object e = this.getMyModel().get(i);
                    if (i == 0) {
                        ((PrintWriter)object).println(e.getSummaryTableColumns().getHeaderText());
                        ((PrintWriter)object).println("--");
                    }
                    ((PrintWriter)object).println(e.getSummaryTableColumns().getLineText());
                }
                ((PrintWriter)object).close();
            }
            catch (IOException iOException) {
                GUIUtilities.warning(null, "Failed to save");
                Log.logger((Object)this).log(Level.WARNING, "Failed to save", (Throwable)iOException);
            }
        }
    }

    public void resolveSourceName() {
        NameResolver nameResolver = new NameResolver();
        ObservingToolGui observingToolGui = ObservingToolController.getMyInstance().getGui();
        for (int n : this.basicTable.getSelectedRows()) {
            Object e = this.getMyModel().get(n);
            try {
                FieldTargetPart fieldTargetPart = ((FieldTargetDocument)e).getFieldTargetPart();
                Object object = nameResolver.resolve(fieldTargetPart);
                if (object == null || observingToolGui == null || !(object instanceof NameResolver)) continue;
                observingToolGui.addInformationMessage(nameResolver.getFeedback());
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }
        this.getMyModel().updateRows();
    }

    @Override
    public void repaint() {
        if (this.formEditorPane == null) {
            Container container = this;
            while ((container = container.getParent()) != null) {
                if (!(container instanceof JViewport)) continue;
                this.formEditorPane = (JViewport)container;
                this.formEditorPane.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        SummaryTableEditor.this.repaint();
                    }
                });
                break;
            }
        }
        if (this.formEditorPane != null) {
            this.setPreferredSize(new Dimension((int)this.formEditorPane.getSize().getWidth(), 400));
        }
        super.repaint();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        SummaryTableModel summaryTableModel = new SummaryTableModel(null, observingToolController);
        SummaryTableEditor summaryTableEditor = new SummaryTableEditor(summaryTableModel);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        scienceGoal.setName("SG summary test");
        Rectangle rectangle = Rectangle.createRectangle();
        Rectangle rectangle2 = Rectangle.createRectangle();
        SinglePoint singlePoint = SinglePoint.createSinglePoint();
        SinglePoint singlePoint2 = SinglePoint.createSinglePoint();
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.getCenterFrequency().setContentInGHz(110.20135);
        scienceSpectralWindow.setTransitionName("13CO(1-0)");
        ScienceSpectralWindow scienceSpectralWindow2 = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow2.getCenterFrequency().setContentInGHz(234.0);
        scienceGoal.getSpectralSetupParameters().setType(SpectralSetupParameters.TYPE_FULL);
        scienceGoal.getPerformanceParameters().getDesiredSensitivity().setContent(1.0);
        scienceGoal.getPerformanceParameters().getDesiredAngularResolution().setContent(1.0);
        scienceGoal.getPerformanceParameters().getDesiredLargestScale().setContent(100.0);
        scienceGoal.getSpectralSetupParameters().clearAbstractScienceSpectralWindow();
        scienceGoal.getSpectralSetupParameters().addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
        scienceGoal.getSpectralSetupParameters().addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow2));
        scienceGoal.getSpectralSetupParameters().setRepresentativeSpectralWindow(scienceSpectralWindow);
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        targetParameters.setType(TargetParameters.TYPE_F_SINGLERECTANGLE);
        targetParameters.setSourceName("Sombrero");
        targetParameters.addField((Field)((Object)rectangle));
        TargetParameters targetParameters2 = TargetParameters.createTargetParameters();
        targetParameters2.setType(TargetParameters.TYPE_F_SINGLERECTANGLE);
        targetParameters2.setSourceName("NGC1300");
        targetParameters2.addField((Field)((Object)rectangle2));
        TargetParameters targetParameters3 = TargetParameters.createTargetParameters();
        targetParameters3.setType(TargetParameters.TYPE_F_MULTIPLEPOINTS);
        targetParameters3.setSourceName("W Ser");
        targetParameters3.addField((Field)((Object)singlePoint));
        targetParameters3.addField((Field)((Object)singlePoint2));
        scienceGoal.addTargetParameters(targetParameters);
        scienceGoal.addTargetParameters(targetParameters2);
        scienceGoal.addTargetParameters(targetParameters3);
        ScienceGoal scienceGoal2 = scienceGoal.deepCopy();
        BOCollection bOCollection = new BOCollection(ScienceGoal.class, "ScienceGoal", "ScienceGoals"){
            Collection<ScienceGoal> c = new ArrayList<ScienceGoal>();

            @Override
            public void add(BusinessObject businessObject) {
                this.c.add((ScienceGoal)businessObject);
            }

            @Override
            public int count() {
                return this.c.size();
            }

            @Override
            public BusinessObject[] getCollection() {
                return (BusinessObject[])this.c.toArray(new ScienceGoal[this.c.size()]);
            }

            @Override
            public boolean expandsRow() {
                return true;
            }

            @Override
            public boolean showsControlButtons() {
                return true;
            }
        };
        bOCollection.add((BusinessObject)scienceGoal);
        bOCollection.add((BusinessObject)scienceGoal2);
        summaryTableModel.setDocument(scienceGoal);
        JFrame jFrame = new JFrame(summaryTableEditor.getClass().getSimpleName());
        jFrame.setPreferredSize(new Dimension(1024, 600));
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(summaryTableEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

