/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.models.misc.SummaryTableColumns;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;

public class TargetSummaryTableColumns
implements SummaryTableColumns {
    protected static final int COL_SOURCENAME = 0;
    protected static final int COL_RA = 1;
    protected static final int COL_DEC = 2;
    protected static final int COL_PATTERNTYPE = 3;
    protected static final int COL_TRANSITION = 4;
    protected static final int COL_RESTFREQUENCY = 5;
    protected static final int COL_RECEIVERBAND = 6;
    protected static final int COL_NUMBBCS = 7;
    protected static final int COL_SENSITIVITY = 8;
    protected static final int COL_CALIBRATOR = 9;
    protected static final int NUM_COLUMNS = 10;
    public static Object[] longValues = new Object[]{"Source Name", " 00:00:00.000", "+00:00:00.000", "Rectangle", "CH3OH(2,1-1,1A)", "123.456 GHz", "ALMA_RB_10", "4", "0.00 mJy", "Phs,Amp,Plr"};
    private Target target;

    public TargetSummaryTableColumns(Target target) {
        this.target = target;
    }

    @Override
    public int getSummaryColumnCount() {
        return 10;
    }

    @Override
    public String getSummaryColumnName(int n) {
        switch (n) {
            case 0: {
                return "SourceName";
            }
            case 1: {
                return "RA";
            }
            case 2: {
                return "Dec";
            }
            case 3: {
                return "PatternType";
            }
            case 4: {
                return "Transition";
            }
            case 5: {
                return "RestFrequency";
            }
            case 6: {
                return "ReceiverBand";
            }
            case 7: {
                return "#BBC";
            }
            case 8: {
                return "Sensitivity Goal";
            }
            case 9: {
                return "Calibrator";
            }
        }
        return "";
    }

    @Override
    public Object getSummaryValueAt(int n) {
        try {
            switch (n) {
                case 0: {
                    return this.target.getFieldSource().getSourceName();
                }
                case 1: {
                    return this.target.getFieldSource().getSourceCoordinates().getICRSSkyCoordinates().getLongitude();
                }
                case 2: {
                    return this.target.getFieldSource().getSourceCoordinates().getICRSSkyCoordinates().getLatitude();
                }
                case 3: {
                    return this.target.getFieldSource().getFieldPatternType();
                }
                case 4: {
                    return this.target.getSpectralSpec().getTransitionName();
                }
                case 5: {
                    return this.target.getSpectralSpec().getRestFrequency();
                }
                case 6: {
                    return this.target.getSpectralSpec().getReceiverBand().getName();
                }
                case 7: {
                    return this.target.getSpectralSpec().getBaseBandConfigCount();
                }
                case 8: {
                    return ((ScienceParameters)((Object)this.target.getObservingParameters(AddInteractor.ObjectType.SCIENCEPARAMETERS))).getSensitivityGoal();
                }
                case 9: {
                    return this.getCalibratorString();
                }
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void setSummaryValueAt(Object object, int n) {
    }

    private String getCalibratorString() {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ",";
        if (this.target.hasPhaseCalParameters()) {
            stringBuffer.append("Phs" + string2);
        }
        if (this.target.hasAmplitudeCalParameters()) {
            stringBuffer.append("Amp" + string2);
        }
        if (this.target.hasPolarizationCalParameters()) {
            stringBuffer.append("Pol" + string2);
        }
        if (this.target.hasPointingCalParameters()) {
            stringBuffer.append("Pnt" + string2);
        }
        if (this.target.hasAtmosphericCalParameters()) {
            stringBuffer.append("Atm" + string2);
        }
        if (this.target.hasDelayCalParameters()) {
            stringBuffer.append("Dly" + string2);
        }
        if (this.target.hasCheckSourceCalParameters()) {
            stringBuffer.append("CkS" + string2);
        }
        if (this.target.hasBandpassCalParameters()) {
            stringBuffer.append("Bnd" + string2);
        }
        if (this.target.hasFocusCalParameters()) {
            stringBuffer.append("Fcs" + string2);
        }
        if (this.target.hasOpticalPointingParameters()) {
            stringBuffer.append("Opt" + string2);
        }
        if (this.target.hasRadiometricPointingParameters()) {
            stringBuffer.append("Rad" + string2);
        }
        if ((n = (string = stringBuffer.toString()).lastIndexOf(string2)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    @Override
    public String getHeaderText() {
        return null;
    }

    @Override
    public String getLineText() {
        return null;
    }

    @Override
    public Object[] getLongValues() {
        return longValues;
    }

    @Override
    public Class<?> getSummaryColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Longitude.class;
            }
            case 2: {
                return Latitude.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Frequency.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return Sensitivity.class;
            }
            case 9: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object[] getSummaryColumnKnownItemList(int n) {
        return null;
    }

    @Override
    public SummaryTableRow getSummaryTableRow() {
        return this.target;
    }

    @Override
    public boolean isSummaryCellEditable(int n) {
        return false;
    }

    @Override
    public boolean isSummaryCellEnable(int n) {
        return true;
    }
}

