/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.editors.misc.ValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueUnitPairParser;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public abstract class ValueUnitPairCellEditor
extends ValueCellEditor {
    protected ValueUnitPairParser parser = new ValueUnitPairParser();
    protected Class cl;

    @Override
    public Object getCellEditorValue() {
        String string = this.textField.getText();
        return this.parser.parse(string, this.cl);
    }

    @Override
    public boolean verify(String string) {
        return this.parser.parse(string, this.cl) != null;
    }

    @Override
    public void setValue(Object object) {
        super.setValue(object);
        AbstractDoubleWithUnit abstractDoubleWithUnit = (AbstractDoubleWithUnit)object;
        this.textField.setText(abstractDoubleWithUnit.toBasicString());
    }

    @Override
    protected void setAllTextSelector(final JTextField jTextField) {
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ObservingToolController observingToolController = ObservingToolController.getMyInstance();
                if (observingToolController == null) {
                    return;
                }
                ObservingToolGui observingToolGui = observingToolController.getGui();
                if (observingToolGui == null) {
                    return;
                }
                if (observingToolGui.isFieldReplace()) {
                    jTextField.setCaretPosition(0);
                    String string = jTextField.getText();
                    int n = string.indexOf(32);
                    if (n != -1) {
                        jTextField.moveCaretPosition(n);
                    }
                }
            }
        };
        jTextField.addFocusListener(focusListener);
    }

    public static class TEMultipleEditor
    extends ValueUnitPairCellEditor {
        public TEMultipleEditor() {
            this.cl = Time.class;
        }

        @Override
        public boolean verify(String string) {
            if (super.verify(string)) {
                Time time = (Time)this.parser.parse(string, Time.class);
                double d = time.getContentInUnits(Time.UNIT_MS) / 48.0;
                boolean bl = d - Math.floor(d) == 0.0;
                return bl;
            }
            return false;
        }
    }

    public static class TimeEditor
    extends ValueUnitPairCellEditor {
        public TimeEditor() {
            this.cl = Time.class;
        }
    }

    public static class SensitivityEditor
    extends ValueUnitPairCellEditor {
        public SensitivityEditor() {
            this.cl = Sensitivity.class;
        }
    }

    public static class AngularVelocityEditor
    extends ValueUnitPairCellEditor {
        public AngularVelocityEditor() {
            this.cl = AngularVelocity.class;
        }
    }

    public static class UserAngleEditor
    extends ValueUnitPairCellEditor {
        public UserAngleEditor() {
            this.cl = UserAngle.class;
        }
    }

    public static class AngleEditor
    extends ValueUnitPairCellEditor {
        public AngleEditor() {
            this.cl = Angle.class;
        }
    }

    public static class FrequencyEditor
    extends ValueUnitPairCellEditor
    implements KeyListener {
        private boolean validateReceiver;

        public FrequencyEditor() {
            this(true);
        }

        @Override
        public void finalizeUserEdits() {
            if (this.verify(this.textField.getText())) {
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }

        public FrequencyEditor(boolean bl) {
            this.cl = Frequency.class;
            this.textField.addKeyListener(this);
            this.validateReceiver = bl;
            FocusListener focusListener = new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    this.validateUserDefinedFrequency();
                }
            };
            this.textField.addFocusListener(focusListener);
        }

        private void validateUserDefinedFrequency() {
            this.textField.setForeground(!this.verify(this.textField.getText()) ? Color.RED : Color.BLACK);
        }

        @Override
        public boolean verify(String string) {
            boolean bl = super.verify(string);
            if (bl && this.validateReceiver) {
                Frequency frequency = (Frequency)this.parser.parse(string, Frequency.class);
                try {
                    ReceiverBand.getReceiverBand(frequency);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.validateUserDefinedFrequency();
            this.textField.setForeground(!this.verify(this.textField.getText()) ? Color.RED : Color.BLACK);
        }
    }
}

