/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersQuerySourceEditorDialog;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersTableModel;
import alma.obsprep.ot.editors.obsproject.CalibrationTargetParametersDialog;
import alma.obsprep.ot.editors.obsproject.CalibratorTableElement;
import alma.obsprep.ot.editors.obsproject.NewCalibratorDialog;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.CalibratedGoalModel;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.ot.models.obsproject.CalibrationTargetParametersModel;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalModel;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CalibrationSetupParametersEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    private static final String EDIT_CALIBRATOR_QUERY_BUTTON_TEXT = "Edit Criteria...";
    private static final String EDIT_FIXED_CALIBRATOR_BUTTON_TEXT = "Edit Target...";
    public static final FieldID SYSTEM_CALIBRATORS_STANDARD = new FieldID("CalibratorSetupParametersEditor system calibrator query FID");
    public static final FieldID SYSTEM_CALIBRATORS_AMPLITUDE = new FieldID("CalibratorSetupParametersEditor system calibrator amplitude query FID");
    public static final FieldID MANUAL_CALIBRATORS = new FieldID("CalibratorSetupParametersEditor manual calibrator query FID");
    public static final FieldID EDIT_CALIBRATOR_QUERY = new FieldID("CalibratorSetupParametersEditor edit calibrator query FID");
    public static final FieldID ADD_CALIBRATOR_QUERY = new FieldID("CalibratorSetupParametersEditor add calibrator FID");
    public static final FieldID ADD_FIXED_CALIBRATOR = new FieldID("CalibratorSetupParametersEditor add fixed calibrator FID");
    public static final FieldID DELETE_CALIBRATOR_QUERY = new FieldID("CalibratorSetupParametersEditor delete calibrator FID");
    private JLabel helpLabel;
    private JLabel userHelpLabel;
    private JPanel calibratorsPanel;
    private JPanel buttonPanel;
    private JButton addDynamicCalibratorButton;
    private JButton addFixedCalibratorButton;
    private JButton removeCalibratorButton;
    private JTable table;
    private JRadioButton systemCalibratorsStandardButton;
    private JRadioButton userCalibratorsButton;
    private ButtonGroup buttonGroup;
    private JScrollPane scrollPane;
    private JPanel spacer;
    private final CalibrationSetupParametersTableModel tableModel = new CalibrationSetupParametersTableModel();
    private final CalibratorExpertModel cem;
    private final CalibrationTargetParametersModel targetModel;
    private final CalibrationSetupParametersModel calibratorsModel;
    private JRadioButton systemCalibratorsModifiedAmplitudeStrategyButton;

    public CalibrationSetupParametersEditor(CalibratedGoalModel calibratedGoalModel) {
        this.setName("CalibratorSetupParametersEditor");
        this.calibratorsModel = calibratedGoalModel.getCalibrationSetupParametersModel();
        this.setModel(this.calibratorsModel);
        this.cem = this.calibratorsModel.getCalibratorExpertModel();
        this.targetModel = this.calibratorsModel.getCalibrationTargetParametersModel();
        this.initCalibratorsPanel();
        this.build();
        this.calibratorsModel.publish();
    }

    @Override
    protected void addComponents(String string) {
        this.initCalibratorsPanel();
        this.initQueryColumn(this.table, this.table.getColumnModel().getColumn(5));
    }

    @Override
    protected void build() {
        super.build("CalibrationSetupParametersEditor");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addNonCollapsingGroup(0, this, gridBagLayout, gridBagConstraints, this.calibratorsPanel, "Goal Calibrators");
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (CalibrationSetupParametersModel.CALIBRATOR_TABLE_ELEMENTS.equals(fieldID) && object != null) {
            if (object instanceof List) {
                List list = (List)object;
                this.tableModel.setCalibrators(list);
                this.setRemoveCalibratorButtonState();
                this.packRows(this.table, 0);
                return;
            }
            throw new IllegalArgumentException("Non-List published for calibrator table elements");
        }
        if (SYSTEM_CALIBRATORS_STANDARD.equals(fieldID)) {
            this.systemCalibratorsStandardButton.setSelected(true);
            this.scrollPane.setVisible(false);
            this.userHelpLabel.setVisible(false);
            this.addDynamicCalibratorButton.setVisible(false);
            this.addFixedCalibratorButton.setVisible(false);
            this.removeCalibratorButton.setVisible(false);
            this.spacer.setVisible(true);
        } else if (SYSTEM_CALIBRATORS_AMPLITUDE.equals(fieldID)) {
            this.systemCalibratorsModifiedAmplitudeStrategyButton.setSelected(true);
            this.scrollPane.setVisible(false);
            this.userHelpLabel.setVisible(false);
            this.addDynamicCalibratorButton.setVisible(false);
            this.addFixedCalibratorButton.setVisible(false);
            this.removeCalibratorButton.setVisible(false);
            this.spacer.setVisible(true);
        } else if (MANUAL_CALIBRATORS.equals(fieldID)) {
            this.userCalibratorsButton.setSelected(true);
            this.scrollPane.setVisible(true);
            this.userHelpLabel.setVisible(true);
            this.addDynamicCalibratorButton.setVisible(true);
            this.addFixedCalibratorButton.setVisible(true);
            this.removeCalibratorButton.setVisible(true);
            this.spacer.setVisible(false);
        } else if (ADD_FIXED_CALIBRATOR.equals(fieldID) || ADD_CALIBRATOR_QUERY.equals(fieldID)) {
            if (object != null) {
                this.getController().widgetUpdated(this, EDIT_CALIBRATOR_QUERY, object);
            }
            return;
        }
        super.modelChanged(model, fieldID, object);
    }

    private void initCalibratorsPanel() {
        this.calibratorsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.addDynamicCalibratorButton = this.makeButton(ADD_CALIBRATOR_QUERY, "Add Dynamic Calibrator...", "Add search criteria for calibrator selection at execution time");
        this.addFixedCalibratorButton = this.makeButton(ADD_FIXED_CALIBRATOR, "Add Fixed Calibrator...", "Choose a specific source to be used for calibration");
        this.removeCalibratorButton = this.makeButton(DELETE_CALIBRATOR_QUERY, "Delete Selected Calibration", "Delete the selected calibrator");
        this.helpLabel = new JLabel();
        this.userHelpLabel = new JLabel();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.buttonGroup = new ButtonGroup();
        this.systemCalibratorsStandardButton = new JRadioButton();
        this.systemCalibratorsModifiedAmplitudeStrategyButton = new JRadioButton();
        this.userCalibratorsButton = new JRadioButton();
        this.scrollPane = new ScrollWhenFocusedPane();
        this.spacer = new JPanel();
        this.initEvents(this.systemCalibratorsStandardButton, SYSTEM_CALIBRATORS_STANDARD);
        this.initEvents(this.systemCalibratorsModifiedAmplitudeStrategyButton, SYSTEM_CALIBRATORS_AMPLITUDE);
        this.initEvents(this.userCalibratorsButton, MANUAL_CALIBRATORS);
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(0);
        this.scrollPane.setViewportView(this.table);
        this.calibratorsPanel.setLayout(new GridBagLayout());
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.helpLabel.setText("<html>By default, calibrators will be selected automatically at runtime and a single observation will be used to calibrate the bandpass and flux scale.</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.helpLabel, gridBagConstraints);
        this.buttonGroup.add(this.systemCalibratorsStandardButton);
        this.systemCalibratorsStandardButton.setText("System-defined calibration (recommended)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.systemCalibratorsStandardButton, gridBagConstraints);
        this.buttonGroup.add(this.systemCalibratorsModifiedAmplitudeStrategyButton);
        this.systemCalibratorsModifiedAmplitudeStrategyButton.setText("System-defined calibration (force separate amplitude calibration using solar-system object)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.systemCalibratorsModifiedAmplitudeStrategyButton, gridBagConstraints);
        this.buttonGroup.add(this.userCalibratorsButton);
        this.userCalibratorsButton.setText("User-defined calibration");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.userCalibratorsButton, gridBagConstraints);
        this.userHelpLabel.setFont(this.userHelpLabel.getFont().deriveFont(this.userHelpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.userHelpLabel.setText("<html><ul><li>When first selected, the table shows a reasonable set of calibrators to include.</li><li><i>Dynamic Calibrators</i> are found by a source catalogue query executed at project execution time. Edit the query with <i>Edit Criteria...</i>.</li><li><i>Fixed Calibrators</i> are calibrators specified now, at project creation time. Specify which calibrator should be observed with <i>Edit Target...</i>.</li></ul></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.userHelpLabel, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.addDynamicCalibratorButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addFixedCalibratorButton).addGap(18, 18, 18).addComponent(this.removeCalibratorButton)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addDynamicCalibratorButton).addComponent(this.addFixedCalibratorButton).addComponent(this.removeCalibratorButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.calibratorsPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calibratorsPanel.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calibratorsPanel.add((Component)this.spacer, gridBagConstraints);
        this.addDynamicCalibratorButton.setName("CalibrationSetupParametersEditor.addDynamicCalibratorButton");
        this.addFixedCalibratorButton.setName("CalibrationSetupParametersEditor.addFixedCalibratorButton");
        this.buttonPanel.setName("CalibrationSetupParametersEditor.buttonPanel");
        this.calibratorsPanel.setName("CalibrationSetupParametersEditor.calibratorsPanel");
        this.helpLabel.setName("CalibrationSetupParametersEditor.helpLabel");
        this.removeCalibratorButton.setName("CalibrationSetupParametersEditor.removeCalibratorButton");
        this.scrollPane.setName("CalibrationSetupParametersEditor.scrollPane");
        this.spacer.setName("CalibrationSetupParametersEditor.spacer");
        this.systemCalibratorsStandardButton.setName("CalibrationSetupParametersEditor.systemCalibratorsButton");
        this.table.setName("CalibrationSetupParametersEditor.table");
        this.userCalibratorsButton.setName("CalibrationSetupParametersEditor.userCalibratorsButton");
        this.userHelpLabel.setName("CalibrationSetupParametersEditor.userHelpLabel");
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (ADD_CALIBRATOR_QUERY.equals(fieldID)) {
            NewCalibratorDialog newCalibratorDialog = new NewCalibratorDialog(null, this.getModel().getParentModel().getDocument());
            newCalibratorDialog.setVisible(true);
            String string = newCalibratorDialog.getSelected();
            return string;
        }
        if (ADD_FIXED_CALIBRATOR.equals(fieldID)) {
            NewCalibratorDialog newCalibratorDialog = new NewCalibratorDialog(null, this.getModel().getParentModel().getDocument());
            newCalibratorDialog.setVisible(true);
            String string = newCalibratorDialog.getSelected();
            return string;
        }
        if (DELETE_CALIBRATOR_QUERY.equals(fieldID)) {
            int n = this.table.getSelectedRow();
            return this.tableModel.getValueAt(n, 5);
        }
        if (EDIT_CALIBRATOR_QUERY.equals(fieldID)) {
            if (object instanceof IQuerySource) {
                IQuerySource iQuerySource = (IQuerySource)object;
                IQuerySource iQuerySource2 = iQuerySource.deepCopy();
                QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(iQuerySource);
                this.cem.setDocument(querySourceAdapter);
                CalibrationSetupParametersQuerySourceEditorDialog calibrationSetupParametersQuerySourceEditorDialog = new CalibrationSetupParametersQuerySourceEditorDialog(this.cem, null, true);
                String string = iQuerySource.getIntendedUse();
                calibrationSetupParametersQuerySourceEditorDialog.setTitle(string + " Calibrator Query Editor");
                CalibrationSetupParametersEditor.resizeDialog(calibrationSetupParametersQuerySourceEditorDialog);
                calibrationSetupParametersQuerySourceEditorDialog.setVisible(true);
                if (calibrationSetupParametersQuerySourceEditorDialog.wasCancelled) {
                    CalibrationSetupParametersEditor.copyIQuerySource(iQuerySource2, iQuerySource);
                }
                return iQuerySource;
            }
            if (object instanceof CalibrationTargetParameters) {
                CalibrationTargetParameters calibrationTargetParameters = (CalibrationTargetParameters)object;
                CalibrationTargetParametersDialog calibrationTargetParametersDialog = CalibrationTargetParametersDialog.getInstance();
                calibrationTargetParametersDialog.setDocument(calibrationTargetParameters);
                String string = calibrationTargetParameters.getIntendedUse();
                calibrationTargetParametersDialog.setTitle(string + " Calibration Source Editor");
                CalibrationSetupParametersEditor.resizeDialog(calibrationTargetParametersDialog);
                calibrationTargetParametersDialog.setVisible(true);
                return calibrationTargetParameters;
            }
            throw new IllegalArgumentException("Non-string published as edit intent");
        }
        return object;
    }

    private static void copyIQuerySource(IQuerySource iQuerySource, IQuerySource iQuerySource2) {
        if (iQuerySource == null) {
            return;
        }
        iQuerySource2.setIntendedUse(iQuerySource.getIntendedUse());
        iQuerySource2.setMaxFlux(iQuerySource.getMaxFlux().deepCopy());
        iQuerySource2.setMaxFrequency(iQuerySource.getMaxFrequency().deepCopy());
        iQuerySource2.setMaxSources(iQuerySource.getMaxSources());
        iQuerySource2.setMaxTimeSinceObserved(iQuerySource.getMaxTimeSinceObserved().deepCopy());
        iQuerySource2.setMinFlux(iQuerySource.getMinFlux().deepCopy());
        iQuerySource2.setMinFrequency(iQuerySource.getMinFrequency().deepCopy());
        iQuerySource2.setMinTimeSinceObserved(iQuerySource.getMinTimeSinceObserved().deepCopy());
        iQuerySource2.setQueryCenter(iQuerySource.getQueryCenter().deepCopy());
        iQuerySource2.setSearchRadius(iQuerySource.getSearchRadius().deepCopy());
        iQuerySource2.setUse(iQuerySource.getUse());
    }

    private int getPreferredRowHeight(JTable jTable, int n, int n2) {
        int n3 = jTable.getRowHeight();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
            Component component = jTable.prepareRenderer(tableCellRenderer, n, i);
            int n4 = component.getPreferredSize().height + 2 * n2;
            n3 = Math.max(n3, n4);
        }
        return n3;
    }

    private void packRows(JTable jTable, int n) {
        this.packRows(jTable, 0, jTable.getRowCount(), n);
    }

    private void packRows(JTable jTable, int n, int n2, int n3) {
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n4 = this.getPreferredRowHeight(jTable, i, n3);
            if (jTable.getRowHeight(i) == n4) continue;
            jTable.setRowHeight(i, n4);
        }
    }

    private void resizeColumn(JTable jTable, TableColumn tableColumn, TableCellRenderer tableCellRenderer, int n) {
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n);
        int n2 = component.getPreferredSize().width;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(i, n);
            component = tableCellRenderer2.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n2);
    }

    private void initQueryColumn(JTable jTable, TableColumn tableColumn) {
        ButtonCellRenderer buttonCellRenderer = new ButtonCellRenderer();
        tableColumn.setCellRenderer(buttonCellRenderer);
        this.resizeColumn(jTable, tableColumn, buttonCellRenderer, 2);
        ButtonCellEditor buttonCellEditor = new ButtonCellEditor();
        tableColumn.setCellEditor(buttonCellEditor);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setRemoveCalibratorButtonState();
    }

    private void setRemoveCalibratorButtonState() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 1 && this.table.isEnabled()) {
            this.removeCalibratorButton.setEnabled(true);
        } else {
            this.removeCalibratorButton.setEnabled(false);
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        final ObservatoryGoalModel observatoryGoalModel = new ObservatoryGoalModel(null);
        final ObservatoryGoal observatoryGoal = ObservatoryGoal.createCalibratorSurveyGoal();
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE);
        observatoryGoal.getCalibrationSetupParameters().setSelection(CalibrationSetupParameters.SELECTION_USER);
        observatoryGoal.getCalibrationSetupParameters().addQuerySource(querySource);
        CalibratorExpert.SourceCatalog.setEnableOfflineCatalogAccess(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
                }
                CalibrationSetupParametersEditor calibrationSetupParametersEditor = new CalibrationSetupParametersEditor(observatoryGoalModel);
                observatoryGoalModel.setDocument(observatoryGoal);
                JFrame jFrame = new JFrame("ObservatoryGoalTargetsEditor");
                jFrame.setDefaultCloseOperation(3);
                jFrame.getContentPane().add(calibrationSetupParametersEditor);
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }

    class CalibratorTypeComboBoxCellRenderer
    extends ComboBoxCellRenderer {
        public CalibratorTypeComboBoxCellRenderer() {
            for (String string : QuerySource.getKnownIntendedUseList()) {
                this.comboBox.addItem(string);
            }
        }
    }

    abstract class ComboBoxCellRenderer
    implements TableCellRenderer {
        protected final JComboBox comboBox = new JComboBox();

        ComboBoxCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.comboBox.setSelectedItem(object);
            return this.comboBox;
        }
    }

    class ButtonCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JButton button = new JButton("Edit Criteria...");

        ButtonCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            CalibratorTableElement calibratorTableElement = CalibrationSetupParametersEditor.this.tableModel.get(n);
            if (calibratorTableElement.getQuerySource() != null) {
                CalibrationSetupParametersEditor.this.getController().widgetUpdated(CalibrationSetupParametersEditor.this, EDIT_CALIBRATOR_QUERY, calibratorTableElement.getQuerySource());
            } else {
                CalibrationSetupParametersEditor.this.getController().widgetUpdated(CalibrationSetupParametersEditor.this, EDIT_CALIBRATOR_QUERY, calibratorTableElement.getCalibrationTargetParameters());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ButtonCellEditor.this.stopCellEditing();
                }
            });
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.getText();
        }
    }

    class ButtonCellRenderer
    implements TableCellRenderer {
        private JButton editQueryButton = new JButton("Edit Criteria...");
        private JButton editTargetButton = new JButton("Edit Target...");

        public ButtonCellRenderer() {
            this.editQueryButton.setToolTipText("Edit the search criteria to be used at execution time for calibrator selection");
            this.editTargetButton.setToolTipText("Edit the parameters for your specified calibration source");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CalibratorTableElement calibratorTableElement = CalibrationSetupParametersEditor.this.tableModel.get(n);
            if (calibratorTableElement == null) {
                return this.editQueryButton;
            }
            if (calibratorTableElement.getQuerySource() != null) {
                return this.editQueryButton;
            }
            return this.editTargetButton;
        }
    }
}

