/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.ot.editors.obsproject.BusinessObjectListItem;
import alma.obsprep.ot.editors.obsproject.DependencyEditor;
import alma.obsprep.ot.gui.resources.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class DependencyDialog
extends JDialog
implements PropertyChangeListener,
ActionListener {
    private Vector<BusinessObjectListItem> excludedObsUnits = new Vector();
    private Vector<BusinessObjectListItem> includedObsUnits = new Vector();
    private JList excludedList = new JList<BusinessObjectListItem>(this.excludedObsUnits);
    private JList includedList = new JList<BusinessObjectListItem>(this.includedObsUnits);
    private JButton excludeButton = new JButton(" \u21da ");
    private JButton includeButton = new JButton(" \u21db ");
    private JOptionPane optionPane;

    public DependencyDialog(JFrame jFrame, DependencyEditor dependencyEditor) {
        super(jFrame);
        this.setModal(true);
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        jPanel2.add(new JPanel());
        this.includeButton.setFont(this.includeButton.getFont().deriveFont(14.0f));
        this.excludeButton.setFont(this.excludeButton.getFont().deriveFont(14.0f));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.includeButton);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.add(this.excludeButton);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("Not Dependent On");
        jLabel.setFont(jLabel.getFont().deriveFont(1, 14.0f));
        jPanel3.add((Component)jLabel, "North");
        jPanel3.add((Component)new ScrollWhenFocusedPane(this.excludedList), "Center");
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        jPanel3 = new JPanel(new BorderLayout());
        jLabel = new JLabel("Dependent On");
        jLabel.setFont(jLabel.getFont().deriveFont(1, 14.0f));
        jPanel3.add((Component)jLabel, "North");
        jPanel3.add((Component)new ScrollWhenFocusedPane(this.includedList), "Center");
        jPanel.add(jPanel3);
        String string = "Set the Unit Dependencies";
        Object[] objectArray = new Object[]{string, jPanel};
        Object[] objectArray2 = new Object[]{"OK", "Cancel"};
        this.optionPane = new JOptionPane(objectArray, 3, 0, Icons.obsUnitSet, objectArray2, objectArray2[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DependencyDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.optionPane.addPropertyChangeListener(this);
        this.optionPane.addPropertyChangeListener(dependencyEditor);
        this.includeButton.addActionListener(this);
        this.excludeButton.addActionListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isVisible() && propertyChangeEvent.getSource() == this.optionPane && ("value".equals(string) || "inputValue".equals(string))) {
            Object object = this.optionPane.getValue();
            if (object == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            this.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray;
        if (actionEvent.getSource() == this.includeButton && this.excludedList.getSelectedIndex() != -1) {
            nArray = this.excludedList.getSelectedIndices();
            for (n = 0; n < nArray.length; ++n) {
                this.includedObsUnits.add(this.excludedObsUnits.get(nArray[n]));
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                this.excludedObsUnits.remove(nArray[n]);
            }
            this.resetLists();
        }
        if (actionEvent.getSource() == this.excludeButton && this.includedList.getSelectedIndex() != -1) {
            nArray = this.includedList.getSelectedIndices();
            for (n = 0; n < nArray.length; ++n) {
                this.excludedObsUnits.add(this.includedObsUnits.get(nArray[n]));
            }
            for (n = nArray.length - 1; n >= 0; --n) {
                this.includedObsUnits.remove(nArray[n]);
            }
            this.resetLists();
        }
    }

    public void resetLists() {
        this.excludedList.setListData(this.excludedObsUnits);
        this.includedList.setListData(this.includedObsUnits);
    }

    public Vector<BusinessObjectListItem> getExcludedObsUnits() {
        return this.excludedObsUnits;
    }

    public Vector<BusinessObjectListItem> getIncludedObsUnits() {
        return this.includedObsUnits;
    }
}

