/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.editors.obsproject.BusinessObjectListItem;
import alma.obsprep.ot.editors.obsproject.DependencyDialog;
import alma.obsprep.ot.models.obsproject.ObsUnitModel;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DependencyEditor
extends JPanel
implements PropertyChangeListener,
ActionListener {
    protected static final String OK_STRING = "OK";
    protected static final String CANCEL_STRING = "Cancel";
    private ObsUnitModel obsUnitModel = null;
    private JButton showButton = new JButton("View / Edit");
    private DependencyDialog dependencyDialog = null;

    public DependencyEditor() {
        String string = "List of units which this unit depends on.";
        JLabel jLabel = new JLabel("Dependency List");
        this.setToolTipText(string);
        jLabel.setToolTipText(string);
        this.showButton.setToolTipText(string);
        this.showButton.addActionListener(this);
        this.add(jLabel);
        this.add(this.showButton);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue().equals(OK_STRING)) {
            this.updateUnitDependencies();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (this.dependencyDialog == null) {
            serializable = SwingUtilities.getRoot(this);
            JFrame jFrame = null;
            if (serializable instanceof JFrame) {
                jFrame = (JFrame)serializable;
            }
            this.dependencyDialog = new DependencyDialog(jFrame, this);
        }
        this.fillGUI();
        serializable = new Point(0, 0);
        SwingUtilities.convertPointToScreen((Point)serializable, this);
        this.dependencyDialog.setLocation((Point)serializable);
        this.dependencyDialog.pack();
        this.dependencyDialog.setVisible(true);
    }

    public void setObsUnitModel(ObsUnitModel obsUnitModel) {
        this.obsUnitModel = obsUnitModel;
    }

    private void fillGUI() {
        ObsUnit obsUnit = (ObsUnit)this.obsUnitModel.getDocument();
        String[] stringArray = obsUnit.getUnitDependencies().getDependencyList();
        Vector<String> vector = null;
        if (stringArray != null && stringArray.length > 0) {
            vector = new Vector<String>(Arrays.asList(stringArray));
        }
        Vector<BusinessObjectListItem> vector2 = this.dependencyDialog.getIncludedObsUnits();
        vector2.clear();
        Vector<BusinessObjectListItem> vector3 = this.dependencyDialog.getExcludedObsUnits();
        vector3.clear();
        List<SchedBlock> list = null;
        try {
            list = this.getSBsInOUSStructure((SchedBlock)((Object)obsUnit));
        }
        catch (UnknownEntityException | SchedBlock.UnableToFindParentScienceGoalException throwable) {
            Log.logger(DependencyEditor.class).info("Unable to determine SBs in the OUS : " + throwable.getMessage());
            return;
        }
        for (IBusinessObject iBusinessObject : list) {
            if (iBusinessObject != obsUnit) {
                if (iBusinessObject instanceof SchedBlock) {
                    if (vector != null && ((SchedBlock)iBusinessObject).getEntityID() != null && vector.contains(((SchedBlock)iBusinessObject).getEntityID())) {
                        vector2.add(new BusinessObjectListItem((BusinessObject)iBusinessObject));
                    } else {
                        vector3.add(new BusinessObjectListItem((BusinessObject)iBusinessObject));
                    }
                }
                if (!(iBusinessObject instanceof ObsUnitSet)) continue;
                if (vector != null && ((ObsUnitSet)iBusinessObject).getEntityPartId() != null && vector.contains(((ObsUnitSet)iBusinessObject).getEntityPartId())) {
                    vector2.add(new BusinessObjectListItem((BusinessObject)iBusinessObject));
                    continue;
                }
                vector3.add(new BusinessObjectListItem((BusinessObject)iBusinessObject));
                continue;
            }
            this.dependencyDialog.setTitle("Unit Dependency List (" + new BusinessObjectListItem((BusinessObject)iBusinessObject) + ")");
        }
        this.dependencyDialog.resetLists();
    }

    private void updateUnitDependencies() {
        Vector<BusinessObjectListItem> vector = this.dependencyDialog.getIncludedObsUnits();
        ObsUnit obsUnit = (ObsUnit)this.obsUnitModel.getDocument();
        obsUnit.getUnitDependencies().clearDependencyList();
        BusinessObject businessObject = null;
        for (int i = 0; i < vector.size(); ++i) {
            businessObject = vector.get(i).getBusinessObject();
            if (businessObject instanceof SchedBlock) {
                obsUnit.getUnitDependencies().addDependencyList(((SchedBlock)businessObject).getEntityID());
            }
            if (!(businessObject instanceof ObsUnitSet)) continue;
            obsUnit.getUnitDependencies().addDependencyList(((ObsUnitSet)businessObject).getEntityPartId());
        }
    }

    private List<SchedBlock> getSBsInOUSStructure(SchedBlock schedBlock) throws UnknownEntityException, SchedBlock.UnableToFindParentScienceGoalException {
        List<SchedBlock> list = new ArrayList<SchedBlock>();
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsUnitSet");
        }
        SchedBlock schedBlock2 = schedBlock;
        AbstractScienceGoal abstractScienceGoal = schedBlock.getParentScienceGoal();
        if (abstractScienceGoal != null) {
            list = SchedBlockWorker.findSBsInSG(schedBlock.getParentScienceGoal());
        }
        return list;
    }
}

