/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class NewCalibratorDialog
extends GuiFactory.Dialog {
    private JRadioButton amplitude;
    private JRadioButton atmospheric;
    private JRadioButton bandpass;
    private ButtonGroup buttonGroup;
    private JButton create;
    private JButton cancel;
    private JRadioButton delay;
    private JLabel dialogHelp;
    private JRadioButton focus;
    private JPanel panel;
    private JPanel standardButtonPanel;
    private JRadioButton phase;
    private JRadioButton pointing;
    private JRadioButton polarization;
    private final Map<String, JRadioButton> radioButtons = new LinkedHashMap<String, JRadioButton>();
    private String selected;
    private boolean addingCalibrationsToScienceGoal = false;

    public String getSelected() {
        return this.selected;
    }

    public NewCalibratorDialog(Frame frame, Object object) {
        assert (object != null);
        if (object instanceof ScienceGoal) {
            this.addingCalibrationsToScienceGoal = true;
        }
        this.setModal(true);
        this.setTitle("Add Calibration");
        this.initComponents();
        this.radioButtons.put(QuerySource.INTENDEDUSE_AMPLITUDE, this.amplitude);
        this.radioButtons.put(QuerySource.INTENDEDUSE_BANDPASS, this.bandpass);
        this.radioButtons.put(QuerySource.INTENDEDUSE_PHASE, this.phase);
        this.radioButtons.put(QuerySource.INTENDEDUSE_POLARIZATION, this.polarization);
        if (!this.addingCalibrationsToScienceGoal) {
            this.radioButtons.put(QuerySource.INTENDEDUSE_ATMOSPHERIC, this.atmospheric);
            this.radioButtons.put(QuerySource.INTENDEDUSE_POINTING, this.pointing);
            this.radioButtons.put(QuerySource.INTENDEDUSE_FOCUS, this.focus);
            this.radioButtons.put(QuerySource.INTENDEDUSE_DELAY, this.delay);
        }
        this.amplitude.setSelected(true);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.centreOnMonitor();
        }
        super.setVisible(bl);
    }

    public void setUnselectable(Collection<String> collection) {
        ArrayList<JRadioButton> arrayList = new ArrayList<JRadioButton>(this.radioButtons.values());
        for (String string : collection) {
            JRadioButton jRadioButton = this.radioButtons.get(string);
            arrayList.remove(jRadioButton);
            jRadioButton.setEnabled(false);
        }
        if (arrayList.size() > 0) {
            JRadioButton jRadioButton = (JRadioButton)arrayList.get(0);
            jRadioButton.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.panel = new JPanel();
        this.panel.setName("NewCalibratorDialog");
        this.standardButtonPanel = new JPanel();
        this.standardButtonPanel.setName("NewCalibratorDialog.standardButtonPanel");
        this.dialogHelp = new JLabel();
        this.dialogHelp.setName("NewCalibratorDialog.SelectCalibrationLabel");
        this.amplitude = new JRadioButton();
        this.amplitude.setName("NewCalibratorDialog.RadioAmplitudeButton");
        this.atmospheric = new JRadioButton();
        this.atmospheric.setName("NewCalibratorDialog.RadioAtmosphericButton");
        this.focus = new JRadioButton();
        this.focus.setName("NewCalibratorDialog.RadioFocusButton");
        this.pointing = new JRadioButton();
        this.pointing.setName("NewCalibratorDialog.RadioPointingButton");
        this.delay = new JRadioButton();
        this.delay.setName("NewCalibratorDialog.RadioDelayButton");
        this.bandpass = new JRadioButton();
        this.bandpass.setName("NewCalibratorDialog.RadioBandpassButton");
        this.phase = new JRadioButton();
        this.phase.setName("NewCalibratorDialog.RadioPhaseButton");
        this.polarization = new JRadioButton();
        this.polarization.setName("NewCalibratorDialog.RadioPolarizationButton");
        this.create = new JButton();
        this.create.setName("NewCalibratorDialog.CreateButton");
        this.cancel = new JButton();
        this.cancel.setName("NewCalibratorDialog.CancelButton");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewCalibratorDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panel.setLayout(new GridBagLayout());
        this.dialogHelp.setFont(this.dialogHelp.getFont().deriveFont(this.dialogHelp.getFont().getStyle() & 0xFFFFFFFE));
        this.dialogHelp.setText("<html><p>Select the calibration to create:</p></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.panel.add((Component)this.dialogHelp, gridBagConstraints);
        this.buttonGroup.add(this.amplitude);
        this.amplitude.setText(QuerySource.INTENDEDUSE_AMPLITUDE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 24, 0, 0);
        this.panel.add((Component)this.amplitude, gridBagConstraints);
        if (!this.addingCalibrationsToScienceGoal) {
            this.buttonGroup.add(this.atmospheric);
            this.atmospheric.setText(QuerySource.INTENDEDUSE_ATMOSPHERIC);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            this.panel.add((Component)this.atmospheric, gridBagConstraints);
        }
        this.buttonGroup.add(this.bandpass);
        this.bandpass.setText(QuerySource.INTENDEDUSE_BANDPASS);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.panel.add((Component)this.bandpass, gridBagConstraints);
        if (!this.addingCalibrationsToScienceGoal) {
            this.buttonGroup.add(this.delay);
            this.delay.setText(QuerySource.INTENDEDUSE_DELAY);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            this.panel.add((Component)this.delay, gridBagConstraints);
        }
        if (!this.addingCalibrationsToScienceGoal) {
            this.buttonGroup.add(this.focus);
            this.focus.setText(QuerySource.INTENDEDUSE_FOCUS);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            this.panel.add((Component)this.focus, gridBagConstraints);
        }
        this.buttonGroup.add(this.phase);
        this.phase.setText(QuerySource.INTENDEDUSE_PHASE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.panel.add((Component)this.phase, gridBagConstraints);
        if (!this.addingCalibrationsToScienceGoal) {
            this.buttonGroup.add(this.pointing);
            this.pointing.setText(QuerySource.INTENDEDUSE_POINTING);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            this.panel.add((Component)this.pointing, gridBagConstraints);
        }
        this.buttonGroup.add(this.polarization);
        this.polarization.setText(QuerySource.INTENDEDUSE_POLARIZATION);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.panel.add((Component)this.polarization, gridBagConstraints);
        this.create.setText("Create");
        this.create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewCalibratorDialog.this.createActionPerformed(actionEvent);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewCalibratorDialog.this.selected = null;
                NewCalibratorDialog.this.dispose();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(18, 12, 12, 18);
        this.standardButtonPanel.add((Component)this.create, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.standardButtonPanel.add((Component)this.cancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(18, 12, 12, 0);
        this.panel.add((Component)this.standardButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panel, gridBagConstraints);
        this.pack();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.selected = null;
    }

    private void createActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        for (JRadioButton jRadioButton : this.radioButtons.values()) {
            if (!jRadioButton.isSelected()) continue;
            this.selected = jRadioButton.getText();
            break;
        }
        this.dispose();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
                }
                NewCalibratorDialog newCalibratorDialog = new NewCalibratorDialog((Frame)new JFrame(), (Object)null);
                newCalibratorDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(QuerySource.INTENDEDUSE_AMPLITUDE);
                arrayList.add(QuerySource.INTENDEDUSE_PHASE);
                newCalibratorDialog.setUnselectable(arrayList);
                newCalibratorDialog.setVisible(true);
            }
        });
    }
}

