/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsattachment.data.DocumentLinkData;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTBasicTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.investigator.InvestigatorsEditor;
import alma.obsprep.ot.editors.obsproject.OpenDuplicationsURLAction;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.ObservingToolGuiProjectCompartment;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.util.GUIUtilities;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.help.CSH;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class ObsProposalEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = -7266042743152960270L;
    private static AlmaPolicies apol = AlmaPolicies.getInstance();
    private static int MAX_ABSTRACT_CHARACTERS = apol.getMaxAbstractCharacters();
    private static int MAX_SCIENCE_CASE_PAGES = apol.getMaxScienceCasePages();
    private static int MAX_SCIENCE_CASE_LARGE_PROGRAM_PAGES = apol.getMaxLargeProgramScienceCasePages();
    public static final String DUPLICATIONS_INFO_LINK = "http://almascience.org/proposing/duplications";
    public static FieldID THIS_FID = new FieldID("ObsProposalEditor");
    public static FieldID CATEGORY_FID = new FieldID("ObsProposalEditor.scientificCategory");
    public static FieldID KEYWORDS_FID = new FieldID("ObsProposalEditor.keywords");
    public static FieldID ABSTRACT_FID = new FieldID("ObsProposalEditor.abstract");
    public static FieldID PROPOSALTYPE_FID = new FieldID("ObsProposalEditor.proposalType");
    public static FieldID ADVANCEDPROPOSALTYPE_FID = new FieldID("ObsProposalEditor.advancedProposalType");
    public static FieldID SUPPORTREQ_FID = new FieldID("ObsProposalEditor.supportRequired");
    public static FieldID RELATEDPROPS_FID = new FieldID("ObsProposalEditor.relatedProposals");
    public static FieldID PREVIOUSPROPS_FID = new FieldID("ObsProposalEditor.previousProposals");
    public static FieldID DUPLICATE_OBSERVATION_FID = new FieldID("ObsProposalEditor.duplicateObservatons");
    public static FieldID DATERECEIVED_FID = new FieldID("ObsProposalEditor.dateReceived");
    public static FieldID PRCGRADE_FID = new FieldID("ObsProposalEditor.prcGrade");
    public static FieldID CYCLE_FID = new FieldID("ObsProposalEditor.cycle");
    public static FieldID STAFFCONTACT_FID = new FieldID("ObsProposalEditor.staffContact");
    public static FieldID CONTACTPERSON_FID = new FieldID("ObsProposalEditor.contactPerson");
    public static FieldID AVAILABILITY_MSG_FID = new FieldID("ObsProposalEditor.availabilityMessage");
    public static FieldID ATTACH_DOC_FID = new FieldID("ObsProposalEditor.attachScienceCase");
    public static FieldID DETACH_DOC_FID = new FieldID("ObsProposalEditor.detachScienceCase");
    public static FieldID SCIDOCUMENT_FID = new FieldID("ObsProposalEditor.scienceCaseDocument");
    public static FieldID VIEW_DOC_FID = new FieldID("ObsProposalEditor.viewScienceCase");
    public static FieldID ATTACH_TECHDOC_FID = new FieldID("ObsProposalEditor.attachTechnicalCase");
    public static FieldID DETACH_TECHDOC_FID = new FieldID("ObsProposalEditor.detachTechnicalCase");
    public static FieldID TECHDOCUMENT_FID = new FieldID("ObsProposalEditor.TechnicalCaseDocument");
    public static FieldID VIEW_TECHDOC_FID = new FieldID("ObsProposalEditor.viewTechnicalCase");
    public static FieldID ATTACH_FIGS_FID = new FieldID("ObsProposalEditor.attachFigures");
    public static FieldID DETACH_FIGS_FID = new FieldID("ObsProposalEditor.detachFigures");
    public static FieldID FIGURES_FID = new FieldID("ObsProposalEditor.figures");
    public static FieldID VIEW_FIGS_FID = new FieldID("ObsProposalEditor.viewFigures");
    public static FieldID ATTACH_TABS_FID = new FieldID("ObsProposalEditor.attachTables");
    public static FieldID DETACH_TABS_FID = new FieldID("ObsProposalEditor.detachTables");
    public static FieldID TABLES_FID = new FieldID("ObsProposalEditor.tables");
    public static FieldID VIEW_TABS_FID = new FieldID("ObsProposalEditor.viewTables");
    public static FieldID STUDENT_FID = new FieldID("ObsProposalEditor.student");
    public static FieldID FID_SCIENCE_CASE_LABEL = new FieldID("ObsProposalEditor.scienceCaseLabel");
    public static FieldID FID_DUPLICATIONS_LABEL = new FieldID("ObsProposalEditor.duplicationsLabel");
    private JFileChooser chooser;
    private final ObservingToolController otc;
    private static final int FILENAME_COLUMNS = 30;
    private static final int EDITOR_WIDTH = 800;
    private static final int LABEL_WIDTH = 80;
    private static final int FIGURES_MAX_PAGES = 2;
    private static final int TECHNICAL_CASE_MAX_PAGES = 2;
    private static final int TABLES_MAX_PAGES = 2;
    private JPanel documentsGroupPanel;
    private GridBagLayout documentsGroupLayout;
    private GridBagConstraints documentsGroupConstraints;
    static final Map<FieldID, String> tooltips = new HashMap<FieldID, String>();
    private OTButtonGroup categoryButtons;
    private JList<String> keywordList;
    private OTButtonGroup normalProposalButtons;
    private OTButtonGroup advancedProposalButtons;
    private JTextArea prevProposals;
    private static Map<FieldID, String> documentClassMap;
    private static Map<String, Long> attachmentMaxSizes;
    private static Map<String, Integer> attachmentMaxPages;
    private File dummy = new File("");

    public ObsProposalEditor(Model model, ObservingToolController observingToolController) {
        this.setName("ObsProposalEditor");
        this.otc = observingToolController;
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public ObsProposalModel getModel() {
        return (ObsProposalModel)super.getModel();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (FieldIDs.projectStatusFID.equals(fieldID) && object instanceof String) {
            String string = (String)object;
            if (ObsProject.STATUS_NEWPHASE1.equals(string) || ObsProject.STATUS_NEWPHASE2.equals(string)) {
                this.setProposalTypeButtonsEnabled(true);
            } else {
                this.setProposalTypeButtonsEnabled(false);
            }
        }
        super.modelChanged(model, fieldID, object);
    }

    private void setProposalTypeButtonsEnabled(boolean bl) {
        this.normalProposalButtons.setEnabled(bl);
        this.advancedProposalButtons.setEnabled(bl);
    }

    @Override
    protected void addComponents(String string) {
        this.addProposalGroup();
        this.addInvestigatorsGroup();
        this.addDocumentGroup();
        this.addDuplicateObservationGroup();
        this.addFeedbackGroup();
    }

    private void addProposalGroup() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.projectNameFID, "Proposal Title", tooltips.get(FieldIDs.projectNameFID));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JTextField jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, CYCLE_FID, "Proposal Cycle", tooltips.get(CYCLE_FID));
        jTextField.setEditable(false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addOTTextArea(jPanel, gridBagLayout, gridBagConstraints, ABSTRACT_FID, 720, 150, "<html>Abstract<br>(max. " + MAX_ABSTRACT_CHARACTERS + " characters)</html>", tooltips.get(ABSTRACT_FID), true);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        String[] stringArray = apol.getKnownProposalTypes();
        String[] stringArray2 = apol.getObservatoryTypes();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        this.normalProposalButtons = this.addOTButtonGroup(jPanel, gridBagLayout, gridBagConstraints, PROPOSALTYPE_FID, "Proposal Type", tooltips.get(PROPOSALTYPE_FID), stringArray, 3, 150);
        this.advancedProposalButtons = this.addOTButtonGroup(jPanel, gridBagLayout, gridBagConstraints, ADVANCEDPROPOSALTYPE_FID, "Proposal Type", tooltips.get(ADVANCEDPROPOSALTYPE_FID), stringArray3, 3, 150);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        String[] stringArray4 = apol.getKnownScientificCategories();
        this.categoryButtons = this.addOTButtonGroup(jPanel, gridBagLayout, gridBagConstraints, CATEGORY_FID, "Scientific Category", tooltips.get(CATEGORY_FID), stringArray4, 3, 150);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.keywordList = this.addJList(jPanel, gridBagLayout, gridBagConstraints, KEYWORDS_FID, "<html>Keywords<br>(max. 2 keywords)</html>", tooltips.get(KEYWORDS_FID), new String[0]);
        this.keywordList.setSelectionMode(2);
        this.keywordList.setLayoutOrientation(0);
        this.keywordList.setVisibleRowCount(5);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JPanel jPanel2 = this.createLineContainer();
        JCheckBox jCheckBox = this.makeCheckBox(STUDENT_FID, "<html>This option should be checked if the proposed project <br>is intended to obtain data for a student thesis</html>");
        jPanel2.add(jCheckBox);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Student project", (JComponent)jPanel2);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addJTextArea(jPanel, gridBagLayout, gridBagConstraints, RELATEDPROPS_FID, 720, 50, "Related Proposals", tooltips.get(RELATEDPROPS_FID));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.prevProposals = this.addJTextArea(jPanel, gridBagLayout, gridBagConstraints, PREVIOUSPROPS_FID, 720, 50, "Previous Proposals", tooltips.get(PREVIOUSPROPS_FID));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JPanel jPanel3 = (JPanel)this.addNonCollapsingGroup(jPanel, "Proposal Information");
        CSH.setHelpIDString((Component)jPanel3, (String)"TOC-The Phase 1 Proposal: Basic Details-Proposal Information");
    }

    public void setAdvancedProposalsVisible(boolean bl) {
        bl = false;
        if (bl) {
            if (!this.advancedProposalButtons.isVisible()) {
                this.advancedProposalButtons.setVisible(true);
                try {
                    String string = this.normalProposalButtons.getSelectedItem();
                    if (string == null) {
                        this.advancedProposalButtons.clearSelection();
                    } else {
                        this.getModel().publish(ADVANCEDPROPOSALTYPE_FID, string);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    this.getModel().resetProposalType();
                    this.advancedProposalButtons.clearSelection();
                }
            }
            if (this.normalProposalButtons.isVisible()) {
                this.normalProposalButtons.setVisible(false);
            }
        } else {
            if (!this.normalProposalButtons.isVisible()) {
                this.normalProposalButtons.setVisible(true);
                try {
                    String string = this.advancedProposalButtons.getSelectedItem();
                    String[] stringArray = this.normalProposalButtons.getAllItems();
                    boolean bl2 = false;
                    for (String string2 : stringArray) {
                        if (!string.equals(string2)) continue;
                        this.getModel().publish(PROPOSALTYPE_FID, string);
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        this.getModel().resetProposalType();
                        this.normalProposalButtons.clearSelection();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    this.getModel().resetProposalType();
                    this.normalProposalButtons.clearSelection();
                }
            }
            if (this.advancedProposalButtons.isVisible()) {
                this.advancedProposalButtons.setVisible(false);
            }
        }
    }

    private void addInvestigatorsGroup() {
        InvestigatorsEditor investigatorsEditor = new InvestigatorsEditor(this.getModel(), this.otc);
        this.registerSubView(investigatorsEditor);
        JPanel jPanel = (JPanel)this.addNonCollapsingGroup(investigatorsEditor, "Investigators");
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-The Phase 1 Proposal: Basic Details-Investigators");
    }

    private void addDocumentGroup() {
        this.documentsGroupPanel = this.createNewGroup();
        this.documentsGroupLayout = this.createNewLayout(this.documentsGroupPanel);
        this.documentsGroupConstraints = this.createNewConstraints();
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        componentCollection.remember(this.makeLabel(AVAILABILITY_MSG_FID, "", null));
        this.addComponentArray(this.documentsGroupPanel, this.documentsGroupLayout, this.documentsGroupConstraints, componentCollection);
        componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        JLabel jLabel = this.makeLabel("Science Case (Mandatory, PDF, " + MAX_SCIENCE_CASE_PAGES + " pages max.)");
        this.register(jLabel, FID_SCIENCE_CASE_LABEL);
        componentCollection.remember(jLabel);
        JTextField jTextField = this.makeTextField(SCIDOCUMENT_FID, false, tooltips.get(SCIDOCUMENT_FID));
        jTextField.setColumns(30);
        jTextField.setFocusable(false);
        componentCollection.remember(jTextField);
        componentCollection.remember(this.makeButton(ATTACH_DOC_FID, "Attach...", tooltips.get(ATTACH_DOC_FID)));
        componentCollection.remember(this.makeButton(DETACH_DOC_FID, "Detach", tooltips.get(DETACH_DOC_FID)));
        JButton jButton = this.makeButton(VIEW_DOC_FID, "View...", tooltips.get(VIEW_DOC_FID));
        componentCollection.remember(jButton);
        this.addComponentArray(this.documentsGroupPanel, this.documentsGroupLayout, this.documentsGroupConstraints, componentCollection);
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JPanel jPanel = (JPanel)this.addNonCollapsingGroup(this.documentsGroupPanel, "Science Case");
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-The Phase 1 Proposal: Basic Details-Science Case");
    }

    private void addDuplicateObservationGroup() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        JButton jButton = this.addButton(jPanel, gridBagLayout, gridBagConstraints, FID_DUPLICATIONS_LABEL, "<HTML><p>Briefly justify any new observations that duplicate archival data or accepted programs.</p><p>Information regarding the ALMA Duplication Policy and how to search archival data and accepted programs can be found at:</p><p><a href =\"http://almascience.org/proposing/duplications\">http://almascience.org/proposing/duplications</a>.</p></HTML>", DUPLICATIONS_INFO_LINK);
        jButton.setActionCommand(DUPLICATIONS_INFO_LINK);
        jButton.setHorizontalAlignment(2);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setOpaque(false);
        jButton.addActionListener(new OpenDuplicationsURLAction());
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        OTBasicTextArea oTBasicTextArea = this.makeOTBasicTextArea(DUPLICATE_OBSERVATION_FID, tooltips.get(FieldIDs.duplicateObservationsFID), 720, 80, true);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, oTBasicTextArea);
        oTBasicTextArea.setFocusable(true);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JPanel jPanel2 = (JPanel)this.addNonCollapsingGroup(jPanel, "Duplicate observations");
        CSH.setHelpIDString((Component)jPanel2, (String)"TOC-The Phase 1 Proposal: Basic Details-Duplicate observations");
    }

    private void addFeedbackGroup() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        JTextField jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.codeFID, "Project Code", tooltips.get(FieldIDs.codeFID));
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, PRCGRADE_FID, "PRC Grade", tooltips.get(PRCGRADE_FID));
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, DATERECEIVED_FID, "Date Received", tooltips.get(DATERECEIVED_FID));
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JPanel jPanel2 = this.addGroup(jPanel, "Observatory Use Only", true);
        CSH.setHelpIDString((Component)jPanel2, (String)"TOC-The Phase 1 Proposal: Basic Details-Observatory Use Only");
    }

    @Override
    protected void build() {
        super.build("ObsProposal");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        Object object2;
        if (fieldID.equals(THIS_FID)) {
            this.setButtons();
            return;
        }
        if (fieldID.equals(SCIDOCUMENT_FID) || fieldID.equals(FIGURES_FID) || fieldID.equals(TECHDOCUMENT_FID) || fieldID.equals(TABLES_FID)) {
            DocumentLink documentLink = (DocumentLink)((Object)object);
            String string = documentLink == null ? "" : documentLink.getFileName();
            super.update(fieldID, string);
            return;
        }
        if (fieldID.equals(ATTACH_DOC_FID) || fieldID.equals(ATTACH_FIGS_FID) || fieldID.equals(ATTACH_TECHDOC_FID) || fieldID.equals(ATTACH_TABS_FID)) {
            try {
                this.attachDocument(documentClassMap.get(fieldID));
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new AssertionError((Object)"cannot perform this operation when attachments are unavailable");
            }
            this.setButtons();
            return;
        }
        if (fieldID.equals(DETACH_DOC_FID) || fieldID.equals(DETACH_FIGS_FID) || fieldID.equals(DETACH_TECHDOC_FID) || fieldID.equals(DETACH_TABS_FID)) {
            try {
                this.detachDocument(documentClassMap.get(fieldID));
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new AssertionError((Object)"cannot perform this operation when attachments are unavailable");
            }
            this.setButtons();
            return;
        }
        if (fieldID.equals(VIEW_DOC_FID) || fieldID.equals(VIEW_FIGS_FID) || fieldID.equals(VIEW_TECHDOC_FID) || fieldID.equals(VIEW_TABS_FID)) {
            try {
                File file = this.getModel().getAttachments().getDocumentLink(documentClassMap.get(fieldID)).getTemporaryFileToView();
                if (file != null && file.exists()) {
                    this.showFile(file);
                }
            }
            catch (IOException iOException) {
                GUIUtilities.warning(null, "Could not create a temporary file : " + iOException.getMessage());
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new AssertionError((Object)"cannot perform this operation when attachments are unavailable");
            }
            return;
        }
        if (fieldID.equals(DATERECEIVED_FID)) {
            object2 = null;
            if (object != null) {
                object2 = object instanceof String ? (String)object : ((Date)object).toString();
            }
            super.update(fieldID, object2);
        }
        if (fieldID.equals(CATEGORY_FID)) {
            if (object.equals("")) {
                this.categoryButtons.clearSelection();
                this.keywordList.clearSelection();
                this.keywordList.setListData((String[])new String[0]);
            } else {
                object2 = apol.getScienceCodeForCategory((String)object);
                ObsProposal obsProposal = this.getModel().getObsProposal();
                String[] stringArray = obsProposal.getKeyword();
                String[] stringArray2 = apol.getScienceKeywords((String)object2);
                if (stringArray2 == null) {
                    stringArray2 = new String[]{};
                }
                this.suspendEvents(this.keywordList);
                this.keywordList.setListData((String[])stringArray2);
                this.resumeEvents(this.keywordList);
                super.update(KEYWORDS_FID, stringArray);
            }
        } else if (fieldID.equals(PROPOSALTYPE_FID)) {
            ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment;
            if (object.equals("")) {
                this.normalProposalButtons.clearSelection();
            }
            if ((observingToolGuiProjectCompartment = ((ObservingToolGui)(object2 = this.otc.getGui())).primaryProjectCompartment()) != null) {
                Action action = observingToolGuiProjectCompartment.getProjectTiedActions().runProjectSummaryDisplay;
                if (object.equals("VLBI")) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
                String string = StringUtils.containsIgnoreCase((CharSequence)((String)object), (CharSequence)"large") ? String.format("Science Case (Mandatory, PDF, %d pages max.)", MAX_SCIENCE_CASE_LARGE_PROGRAM_PAGES) : String.format("Science Case (Mandatory, PDF, %d pages max.)", MAX_SCIENCE_CASE_PAGES);
                assert (string != null);
                JLabel jLabel = (JLabel)this.retrieve(FID_SCIENCE_CASE_LABEL);
                jLabel.setText(string);
            }
        } else if (fieldID.equals(ADVANCEDPROPOSALTYPE_FID)) {
            if (object.equals("")) {
                this.advancedProposalButtons.clearSelection();
            }
        } else if (fieldID.equals(CYCLE_FID) && (object2 = this.getModel()) != null) {
            String string = ((ObsProposalModel)object2).isDDT() ? " (DDT)" : "";
            super.update(CYCLE_FID, object + string);
            return;
        }
        super.update(fieldID, object);
    }

    private void attachDocument(String string) throws UnknownEntityException {
        JFileChooser jFileChooser = this.getFileChooser();
        jFileChooser.setDialogTitle("Open");
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            Object object;
            File file = jFileChooser.getSelectedFile();
            boolean bl = false;
            try {
                ObsAttachment obsAttachment = this.getModel().getObsProposal().getDocuments();
                if (obsAttachment != null) {
                    object = obsAttachment.getDocumentLink();
                    for (int i = 0; i < ((DocumentLink[])object).length; ++i) {
                        if (!object[i].getFileName().equals(file.getName())) continue;
                        bl = true;
                    }
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
            if (bl) {
                object = "Duplicate filename: " + file.getName() + " already attached";
                GUIUtilities.error(null, object);
                return;
            }
            try {
                this.validateFile(file, string);
                this.getModel().attachDocument(file, string);
            }
            catch (IllegalAttachmentException illegalAttachmentException) {
                GUIUtilities.warning(null, illegalAttachmentException.getMessage());
            }
        }
    }

    private void validateFile(File file, String string) throws IllegalAttachmentException {
        if (!file.exists()) {
            String string2 = "File does not exist : " + file.getName();
            throw new IllegalAttachmentException(string2);
        }
        long l = file.length();
        ObsProposal obsProposal = this.getModel().getObsProposal();
        assert (obsProposal != null);
        long l2 = attachmentMaxSizes.get(string);
        int n = attachmentMaxPages.get(string);
        if (string.equals(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE) && obsProposal.isLargeProgram()) {
            n = attachmentMaxPages.get("DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE");
            l2 = attachmentMaxSizes.get("DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE");
        }
        if (l > l2) {
            String string3 = String.format("%s document must be smaller than %.1f MB : %s %.1f MB", string, (double)l2 / 1024.0 / 1024.0, file.getName(), (double)l / 1024.0 / 1024.0);
            throw new IllegalAttachmentException(string3);
        }
        try (PdfReader pdfReader = null;){
            pdfReader = new PdfReader((InputStream)new FileInputStream(file));
            if (!pdfReader.isOpenedWithFullPermissions()) {
                String string4 = "You can not use a pdf file protected by a password.";
                throw new IllegalAttachmentException(string4);
            }
            int n2 = pdfReader.getNumberOfPages();
            if (n2 > n) {
                String string5 = String.format("Maximum number of pages allowed for the %s document is %d, while %s has %d pages.", string, n, file.getName(), n2);
                throw new IllegalAttachmentException(string5);
            }
        }
    }

    private void detachDocument(String string) throws UnknownEntityException {
        this.getModel().detachDocument(string);
    }

    public void setButtons() {
        boolean bl;
        ObsAttachment obsAttachment;
        if (this.documentsGroupPanel == null) {
            return;
        }
        try {
            obsAttachment = this.getModel().gettrueAttachments();
            bl = true;
        }
        catch (UnknownEntityException unknownEntityException) {
            obsAttachment = null;
            bl = false;
        }
        boolean bl2 = obsAttachment != null && obsAttachment.gettrueDocumentLink(DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE) != null;
        this.retrieve(ATTACH_DOC_FID).setEnabled(bl);
        this.retrieve(DETACH_DOC_FID).setEnabled(bl & bl2);
        this.retrieve(VIEW_DOC_FID).setEnabled(bl & bl2);
        ((JLabel)this.retrieve(AVAILABILITY_MSG_FID)).setText(bl ? "" : "NOTE: DOCUMENTS ARE NOT AVAILABLE");
    }

    private void showFile(File file) {
        Desktop desktop;
        if (!file.exists()) {
            GUIUtilities.warning(null, "File not found : " + file);
            return;
        }
        Log.Logger logger = Log.logger((Object)this);
        try {
            desktop = Desktop.getDesktop();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            GUIUtilities.warning(null, "Cannot launch viewer: Either your platform doesn't support this feature or it is not configured");
            return;
        }
        try {
            if (logger.fine()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(">>>>>>>>>>>> ObsProposal <<<<<<<<<<<<<<<<");
                stringBuffer.append(this.getModel().getObsProposal().toXml());
                stringBuffer.append("\n");
                stringBuffer.append(">>>>>>>>>>>> ObsAttachment <<<<<<<<<<<<<<<<");
                try {
                    stringBuffer.append(this.getModel().getAttachments().toXml());
                }
                catch (Exception exception) {
                    stringBuffer.append("problem: " + exception);
                }
                logger.fine(stringBuffer.toString());
            }
            desktop.open(file);
            return;
        }
        catch (IOException iOException) {
            if (!file.canRead()) {
                GUIUtilities.warning(null, "Can not open the file : " + file);
                return;
            }
            String string = System.getProperty("os.name");
            if (string != null && string.toLowerCase().startsWith("windows")) {
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll, FileProtocolHandler " + file.getAbsolutePath());
                    return;
                }
                catch (IOException iOException2) {
                    logger.warning(iOException.getMessage());
                    logger.warning(iOException2.getMessage());
                }
            }
            return;
        }
    }

    private JFileChooser getFileChooser() {
        if (this.chooser == null) {
            this.chooser = GuiFactory.getFactory().giveFileChooser(this);
        }
        this.chooser.setSelectedFile(this.dummy);
        this.chooser.setSelectedFiles(new File[]{this.dummy});
        this.chooser.repaint();
        return this.chooser;
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        ObsProposalModel obsProposalModel = new ObsProposalModel(null);
        ObsProposalEditor obsProposalEditor = new ObsProposalEditor((Model)obsProposalModel, observingToolController);
        obsProposalModel.setDocument((Object)obsProposal);
        EditorWithGridBagLayout.runTestApp(obsProposalEditor, 800, 1000);
    }

    static {
        tooltips.put(FieldIDs.projectNameFID, "The title of the proposal.");
        tooltips.put(FieldIDs.codeFID, "Code assigned to the project");
        tooltips.put(CATEGORY_FID, "A scientific category for the proposal, chosen from the list");
        tooltips.put(KEYWORDS_FID, "Select the appropriate science category keywords, maximum 2 keywords");
        tooltips.put(ABSTRACT_FID, "A short, textual, abstract of the proposal, maximum " + MAX_ABSTRACT_CHARACTERS + " characters");
        tooltips.put(PROPOSALTYPE_FID, "<html>Proposal type, chosen from the list </html>");
        tooltips.put(ADVANCEDPROPOSALTYPE_FID, "<html>Proposal type, chosen from the list </html>");
        tooltips.put(SUPPORTREQ_FID, "");
        tooltips.put(PRCGRADE_FID, "Grade assigned to the project");
        tooltips.put(RELATEDPROPS_FID, "<html>Related ALMA proposals from this Cycle (code, title, PI name)</html>");
        tooltips.put(PREVIOUSPROPS_FID, "<html>Related ALMA proposals from previous Cycles (code, title, PI name and Publication Status)</html>");
        tooltips.put(DATERECEIVED_FID, "The date this proposal was submitted to the observatory.");
        tooltips.put(CYCLE_FID, "The proposal submission cycle for which this proposal will be/was first submitted");
        tooltips.put(STAFFCONTACT_FID, "");
        tooltips.put(CONTACTPERSON_FID, "");
        tooltips.put(ATTACH_DOC_FID, "Attach the mandatory science case document (" + MAX_SCIENCE_CASE_PAGES + " pages max, " + MAX_SCIENCE_CASE_LARGE_PROGRAM_PAGES + " for large programs");
        tooltips.put(DETACH_DOC_FID, "Remove the science case document");
        tooltips.put(SCIDOCUMENT_FID, "The filename of the science case document.");
        tooltips.put(VIEW_DOC_FID, "View the document using the default application.");
        tooltips.put(ATTACH_TECHDOC_FID, "Attach the technical case document (2 pages max)");
        tooltips.put(DETACH_TECHDOC_FID, "Remove the technical case document");
        tooltips.put(TECHDOCUMENT_FID, "The filename of the technical case document.");
        tooltips.put(VIEW_TECHDOC_FID, "View the document using the default application.");
        tooltips.put(ATTACH_FIGS_FID, "Attach optional supporting figures (1 file, 2 pages max)");
        tooltips.put(DETACH_FIGS_FID, "Remove the suppoorting document");
        tooltips.put(FIGURES_FID, "The filename of the supporting document");
        tooltips.put(VIEW_FIGS_FID, "View the document using the default application.");
        tooltips.put(ATTACH_TABS_FID, "Attach optional supporting tables (1 file, 2 pages max)");
        tooltips.put(DETACH_TABS_FID, "Remove the suppoorting document");
        tooltips.put(TABLES_FID, "The filename of the supporting document");
        tooltips.put(VIEW_TABS_FID, "View the document using the default application.");
        documentClassMap = new HashMap<FieldID, String>();
        documentClassMap.put(ATTACH_DOC_FID, DocumentLink.DOCUMENTCLASS_SCIENCE_CASE);
        documentClassMap.put(DETACH_DOC_FID, DocumentLink.DOCUMENTCLASS_SCIENCE_CASE);
        documentClassMap.put(VIEW_DOC_FID, DocumentLink.DOCUMENTCLASS_SCIENCE_CASE);
        documentClassMap.put(ATTACH_TECHDOC_FID, DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE);
        documentClassMap.put(DETACH_TECHDOC_FID, DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE);
        documentClassMap.put(VIEW_TECHDOC_FID, DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE);
        documentClassMap.put(ATTACH_FIGS_FID, DocumentLink.DOCUMENTCLASS_FIGURES);
        documentClassMap.put(DETACH_FIGS_FID, DocumentLink.DOCUMENTCLASS_FIGURES);
        documentClassMap.put(VIEW_FIGS_FID, DocumentLink.DOCUMENTCLASS_FIGURES);
        documentClassMap.put(ATTACH_TABS_FID, DocumentLink.DOCUMENTCLASS_TABLES);
        documentClassMap.put(DETACH_TABS_FID, DocumentLink.DOCUMENTCLASS_TABLES);
        documentClassMap.put(VIEW_TABS_FID, DocumentLink.DOCUMENTCLASS_TABLES);
        attachmentMaxSizes = new HashMap<String, Long>();
        attachmentMaxSizes.put("DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE", 0x1E00000L);
        attachmentMaxSizes.put(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE, 0x1400000L);
        attachmentMaxSizes.put(DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE, 0x100000L);
        attachmentMaxSizes.put(DocumentLink.DOCUMENTCLASS_FIGURES, 0x500000L);
        attachmentMaxSizes.put(DocumentLink.DOCUMENTCLASS_TABLES, 0x500000L);
        attachmentMaxPages = new HashMap<String, Integer>();
        attachmentMaxPages.put("DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE", MAX_SCIENCE_CASE_LARGE_PROGRAM_PAGES);
        attachmentMaxPages.put(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE, MAX_SCIENCE_CASE_PAGES);
        attachmentMaxPages.put(DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE, 2);
        attachmentMaxPages.put(DocumentLink.DOCUMENTCLASS_FIGURES, 2);
        attachmentMaxPages.put(DocumentLink.DOCUMENTCLASS_TABLES, 2);
    }

    private class IllegalAttachmentException
    extends Exception {
        private static final long serialVersionUID = -8511679659893303119L;

        public IllegalAttachmentException(String string) {
            super(string);
        }

        public IllegalAttachmentException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

