/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.utilities.TextUtils;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.services.experts.calibrators.DeclinationComparator;
import alma.obsprep.services.experts.calibrators.MeasurementTableModel;
import alma.obsprep.services.experts.spectralline.gui.TableCellRendererFactory;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class ObservatoryGoalTargetSelectorEditor
extends EditorWithGridBagLayout {
    private final Set<Measurement> selected = new HashSet<Measurement>();
    private final MeasurementTableModel tableModel = new MeasurementTableModel();
    private JButton addAllButton;
    private JButton addSelectedButton;
    private JButton submitButton;
    private JPanel buttonPanel;
    private JPanel resultsPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JLabel helpLabel;
    private JLabel infoLabel;
    private JScrollPane scrollPane;
    private JLabel spacer1;
    private JLabel spacer2;
    private JLabel spacer3;
    private JLabel catalogueLabel;
    private JComboBox catalogue;
    private JTable table;
    private JButton selectButton;
    private boolean multipleSelect = false;

    @Override
    public void addComponents(String string) {
        this.resultsPanel = new JPanel();
        this.helpLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.scrollPane = new ScrollWhenFocusedPane();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.buttonPanel = new JPanel();
        this.spacer1 = new JLabel();
        this.spacer2 = new JLabel();
        this.addSelectedButton = new JButton();
        this.addAllButton = new JButton();
        this.spacer3 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.catalogueLabel = new JLabel();
        this.catalogue = new JComboBox();
        this.submitButton = this.makeButton(QuerySourceEditor.filterFID, "Submit Query", "Find source catalog measurements matching your selection criteria");
        this.selectButton = new JButton();
        this.resultsPanel.setName("ObservatoryGoalTargetsEditor.resultsPanel");
        this.helpLabel.setName("ObservatoryGoalTargetsEditor.helpLabel");
        this.infoLabel.setName("ObservatoryGoalTargetsEditor.infoLabel");
        this.scrollPane.setName("ObservatoryGoalTargetsEditor.scrollPane");
        this.table.setName("ObservatoryGoalTargetsEditor.table");
        this.buttonPanel.setName("ObservatoryGoalTargetsEditor.buttonPanel");
        this.spacer1.setName("ObservatoryGoalTargetsEditor.spacer1");
        this.spacer2.setName("ObservatoryGoalTargetsEditor.spacer2");
        this.addSelectedButton.setName("ObservatoryGoalTargetsEditor.addSelectedButton");
        this.addAllButton.setName("ObservatoryGoalTargetsEditor.addAllButton");
        this.spacer3.setName("ObservatoryGoalTargetsEditor.spacer3");
        this.cancelButton.setName("ObservatoryGoalTargetsEditor.cancelButton");
        this.okButton.setName("ObservatoryGoalTargetsEditor.okButton");
        this.catalogueLabel.setName("ObservatoryGoalTargetsEditor.catalogueLabel");
        this.catalogue.setName("ObservatoryGoalTargetsEditor.catalogue");
        this.selectButton.setName("ObservatoryGoalTargetsEditor.selectButton");
        this.setLayout(new GridBagLayout());
        this.resultsPanel.setLayout(new GridBagLayout());
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        if (this.multipleSelect) {
            this.helpLabel.setText("<html><ul><li>Click <i>Submit Query</i> to find source catalog measurements matching your criteria.</li><li>Choose targets from the table using the <i>Add Selected</i> and <i>Add All</i> buttons.</li></ul></html>");
        } else {
            this.helpLabel.setText("<html><ul><li>Click <i>Submit Query</i> to find source catalog measurements matching your criteria.</li><li>Choose a measurement from the table and click <i>Select Calibrator</i> to import the target.</li></ul></html>");
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.resultsPanel.add((Component)this.helpLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.resultsPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.table.setModel(this.tableModel);
        if (this.multipleSelect) {
            this.table.setSelectionMode(2);
        } else {
            this.table.setSelectionMode(0);
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.SEPARATION));
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.table.getColumnModel().getColumn(5);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FLUX_DENSITY));
        tableColumn = this.table.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.DATE));
        this.scrollPane.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.resultsPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.addSelectedButton.setText("Add Selected");
        this.addAllButton.setText("Add All");
        this.cancelButton.setText("Cancel");
        this.okButton.setText("OK");
        this.catalogueLabel.setText("to");
        this.selectButton.setText("Select Calibrator");
        GroupLayout groupLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(groupLayout);
        if (this.multipleSelect) {
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.spacer1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spacer2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addSelectedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spacer3, -1, -1, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton)));
            groupLayout.linkSize(0, this.okButton, this.spacer1);
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spacer1).addComponent(this.spacer2).addComponent(this.addSelectedButton).addComponent(this.addAllButton).addComponent(this.spacer3).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.catalogueLabel).addComponent(this.catalogue, -2, -1, -2).addComponent(this.submitButton)));
        } else {
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.spacer1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spacer2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spacer3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)));
            groupLayout.linkSize(0, this.okButton, this.spacer1);
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spacer1).addComponent(this.spacer2).addComponent(this.selectButton).addComponent(this.spacer3).addComponent(this.okButton).addComponent(this.catalogueLabel).addComponent(this.catalogue, -2, -1, -2).addComponent(this.submitButton)));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.resultsPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    public ObservatoryGoalTargetSelectorEditor(Model model, boolean bl) {
        this.multipleSelect = bl;
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(CalibratorExpertEditor.tableFID)) {
            if (object instanceof List) {
                List list = (List)object;
                this.tableModel.setCalibrators(list);
            }
            if (this.submitButton != null) {
                this.submitButton.setEnabled(true);
            }
        } else if (fieldID.equals(QuerySourceEditor.raFID)) {
            String string = (String)object;
            this.tableModel.setQueryRA(string);
        } else if (fieldID.equals(QuerySourceEditor.decFID)) {
            String string = (String)object;
            this.tableModel.setQueryDec(string);
        } else if (fieldID.equals(QuerySourceEditor.catlocFID)) {
            String string = (String)object;
            this.set2(this.catalogue, object);
            return;
        }
        super.modelChanged(model, fieldID, object);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (QuerySourceEditor.filterFID.equals(fieldID)) {
            this.submitButton.setEnabled(false);
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    protected void build() {
        super.build("ObservatoryGoalTargetsEditor");
        this.catalogue.setModel(new DefaultComboBoxModel<String>(CalibratorExpert.SourceCatalog.getNames()));
        this.initEvents(this.catalogue, QuerySourceEditor.catlocFID);
        this.makeTableSortable();
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservatoryGoalTargetSelectorEditor.this.addAllButtonActionPerformed(actionEvent);
            }
        });
        this.addSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservatoryGoalTargetSelectorEditor.this.addSelectedButtonActionPerformed(actionEvent);
            }
        });
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservatoryGoalTargetSelectorEditor.this.selectButtonActionPerformed(actionEvent);
            }
        });
    }

    void addOkButtonActionListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
    }

    void addCancelButtonActionListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public List<Measurement> getSelectedCalibrators() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        arrayList.addAll(this.selected);
        return arrayList;
    }

    public JButton getSubmitQueryButton() {
        return this.submitButton;
    }

    private void makeTableSortable() {
        TableRowSorter<MeasurementTableModel> tableRowSorter = new TableRowSorter<MeasurementTableModel>(this.tableModel);
        tableRowSorter.setComparator(2, new DeclinationComparator());
        this.table.setRowSorter(tableRowSorter);
    }

    private void displayNumSelectedSummary() {
        int n = this.selected.size();
        Dimension dimension = this.scrollPane.getSize();
        if (n > 1) {
            this.infoLabel.setIcon(Icons.info);
            this.infoLabel.setText("Adding " + n + " results to your target list");
        } else if (n == 1) {
            this.infoLabel.setIcon(Icons.info);
            this.infoLabel.setText("Adding " + n + " result to your target list");
        }
        dimension.setSize(dimension.width, dimension.height - this.infoLabel.getHeight());
        this.scrollPane.setPreferredSize(dimension);
    }

    private void selectButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n != -1) {
            int n2 = this.table.convertRowIndexToModel(n);
            Measurement measurement = this.tableModel.get(n2);
            this.selected.clear();
            this.selected.add(measurement);
            this.infoLabel.setIcon(Icons.info);
            this.infoLabel.setText(TextUtils.join((Collection)measurement.getNames(), (String)";") + " will be selected as a calibrator");
            Dimension dimension = this.scrollPane.getSize();
            dimension.setSize(dimension.width, dimension.height - this.infoLabel.getHeight());
            this.scrollPane.setPreferredSize(dimension);
        }
    }

    private void addSelectedButtonActionPerformed(ActionEvent actionEvent) {
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            Measurement measurement = this.tableModel.get(n2);
            this.selected.add(measurement);
        }
        this.displayNumSelectedSummary();
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        List<Measurement> list = this.tableModel.getCalibrators();
        this.selected.addAll(list);
        this.displayNumSelectedSummary();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        QuerySource querySource = QuerySource.createQuerySource();
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        final CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(querySourceAdapter);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
                }
                ObservatoryGoalTargetSelectorEditor observatoryGoalTargetSelectorEditor = new ObservatoryGoalTargetSelectorEditor(calibratorExpertModel, true);
                JFrame jFrame = new JFrame("ObservatoryGoalTargetSelectorPanel");
                jFrame.setDefaultCloseOperation(3);
                jFrame.getContentPane().add(observatoryGoalTargetSelectorEditor);
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }
}

