/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.obsproject.Polygon;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.PolygonModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class PolygonEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    private SkyCoordsEditor centreEditor = null;
    private JTable table = null;
    private JButton addB = null;
    private JButton delB = null;
    private JButton upB = null;
    private JButton downB = null;
    private JButton printB = null;
    private FieldID addFID = new FieldID("polygonAddButtonFID");
    private FieldID delFID = new FieldID("polygonDeleteButtonFID");
    private FieldID upFID = new FieldID("polygonUpButtonFID");
    private FieldID downFID = new FieldID("polygonDownButtonFID");
    private FieldID printFID = new FieldID("polygonPrintButtonFID");

    public PolygonEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected PolygonEditor() {
    }

    @Override
    protected void build() {
        super.build("Polygon");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = null;
        jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.nameFID, string + " Name", "The name of this " + string);
        this.addNonCollapsingGroup(jPanel, "");
        jPanel = this.createNewGroup();
        gridBagLayout = this.createNewLayout(jPanel);
        gridBagConstraints = this.createNewConstraints();
        this.centreEditor = this.addSkyCoordinates(jPanel, gridBagLayout, gridBagConstraints, this.getMyModel().getCentreModel(), "Centre", "The centre of this polygon");
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.buildTable());
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        JComponent[] jComponentArray = new JComponent[1];
        this.addB = this.makeButton(this.addFID, "Add", "Add a new point");
        jComponentArray[0] = this.addB;
        componentCollection.remember(jComponentArray);
        JComponent[] jComponentArray2 = new JComponent[1];
        this.delB = this.makeButton(this.delFID, "Delete", "Delete the selected point(s)");
        jComponentArray2[0] = this.delB;
        componentCollection.remember(jComponentArray2);
        JComponent[] jComponentArray3 = new JComponent[1];
        this.upB = this.makeButton(this.upFID, "Move Up", "Move the selcted point up the table");
        jComponentArray3[0] = this.upB;
        componentCollection.remember(jComponentArray3);
        JComponent[] jComponentArray4 = new JComponent[1];
        this.downB = this.makeButton(this.downFID, "Move Down", "Move the selected points down the table");
        jComponentArray4[0] = this.downB;
        componentCollection.remember(jComponentArray4);
        JComponent[] jComponentArray5 = new JComponent[1];
        this.printB = this.makeButton(this.printFID, "Print", "Print the table (diagnostic)");
        jComponentArray5[0] = this.printB;
        componentCollection.remember(jComponentArray5);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addGroup(jPanel, string);
    }

    private JScrollPane buildTable() {
        this.table = new Table(this.getMyModel());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.setupUnitsDropDown(this.table.getColumnModel().getColumn(1), UnitMap.getLongitudeUnits());
        this.setupUnitsDropDown(this.table.getColumnModel().getColumn(3), UnitMap.getLatitudeUnits());
        this.initEvents(this.table, FieldIDs.pointTableFID);
        this.table.getSelectionModel().addListSelectionListener(this);
        return new ScrollWhenFocusedPane(this.table);
    }

    private void setupUnitsDropDown(TableColumn tableColumn, UnitMap unitMap) {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        Object[] objectArray = unitMap.getUnitsSorted();
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        Polygon polygon = (Polygon)((Object)this.getMyModel().getDocument());
        int n = this.table.getSelectedRow();
        if (fieldID == FieldIDs.nameFID) {
            super.update(fieldID, object);
        } else if (fieldID == this.getMyModel().raUnitFID || fieldID == this.getMyModel().raValueFID || fieldID == this.getMyModel().decUnitFID || fieldID == this.getMyModel().decValueFID) {
            this.centreEditor.update(fieldID, object);
        } else if (fieldID == this.addFID) {
            this.getMyModel().addPoint(n + 1);
        } else if (fieldID == this.delFID) {
            this.getMyModel().deletePoint(n);
            if (n == 0) {
                if (this.getMyModel().getRowCount() != 0) {
                    this.table.setRowSelectionInterval(n, n);
                }
            } else if (n == this.getMyModel().getRowCount()) {
                this.table.setRowSelectionInterval(n - 1, n - 1);
            } else {
                this.table.setRowSelectionInterval(n, n);
            }
        } else if (fieldID == this.upFID) {
            this.getMyModel().movePointUp(n);
            if (n > 0) {
                this.table.setRowSelectionInterval(n - 1, n - 1);
            }
        } else if (fieldID == this.downFID) {
            this.getMyModel().movePointDown(n);
            if (n != -1 && n + 1 < this.getMyModel().getRowCount()) {
                this.table.setRowSelectionInterval(n + 1, n + 1);
            }
        } else if (fieldID == this.printFID) {
            if (Log.logger((Object)this).info()) {
                Log.logger((Object)this).info(polygon.toString());
            }
        } else if (Log.logger((Object)this).fine()) {
            Log.logger((Object)this).fine("Unknown fieldID " + fieldID + ", value = " + object);
        }
        this.setButtons();
    }

    private PolygonModel getMyModel() {
        return (PolygonModel)this.getModel();
    }

    private void setButtons() {
        Polygon polygon = (Polygon)((Object)this.getMyModel().getDocument());
        int n = this.table.getSelectedRow();
        int n2 = polygon.getPointCount();
        this.setEnabled(this.addB, true);
        this.setEnabled(this.delB, n != -1);
        this.setEnabled(this.upB, false);
        this.setEnabled(this.downB, false);
        if (n2 > 1 && n != -1) {
            this.setEnabled(this.upB, n != 0);
            this.setEnabled(this.downB, n != n2 - 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        PolygonModel polygonModel = new PolygonModel(null);
        PolygonEditor polygonEditor = new PolygonEditor(polygonModel);
        Polygon polygon = Polygon.createPolygon();
        polygonModel.setDocument((Object)polygon);
        EditorWithGridBagLayout.runTestApp(polygonEditor);
    }
}

