/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.GUIUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttachableComponentChooser
extends JDialog {
    private ActionListener actionListener;
    private Container contentPane;
    private JButton attachButton;
    private JButton cancelButton;
    private JButton okButton;
    private JButton detachButton;
    private JList rightList;
    private JList leftList;
    private ListCellRenderer cellRenderer;
    private ListSelectionListener selectionListener;
    private boolean multiple;
    DefaultListModel leftModel = new DefaultListModel();
    DefaultListModel rightModel = new DefaultListModel();
    private Vector allBOVector = new Vector();
    private boolean[] flags;
    private boolean canceled = true;

    private AttachableComponentChooser(JFrame jFrame, BusinessObject[] businessObjectArray, BusinessObject[] businessObjectArray2, boolean bl) {
        super(jFrame, "Attach/Detach", true);
        this.setDefaultCloseOperation(2);
        this.multiple = bl;
        if (!this.multiple) {
            businessObjectArray2 = new BusinessObject[]{};
        }
        this.flags = new boolean[businessObjectArray.length];
        for (int i = 0; i < businessObjectArray.length; ++i) {
            this.allBOVector.add(businessObjectArray[i]);
            this.flags[i] = false;
            for (int j = 0; j < businessObjectArray2.length; ++j) {
                if (businessObjectArray2[j] != businessObjectArray[i]) continue;
                this.flags[i] = true;
            }
        }
        this.build();
    }

    public static Iterator chooseMultiple(BusinessObject[] businessObjectArray) {
        return AttachableComponentChooser.chooseMultiple(null, businessObjectArray, null);
    }

    public static Iterator chooseMultiple(BusinessObject[] businessObjectArray, BusinessObject[] businessObjectArray2) {
        return AttachableComponentChooser.chooseMultiple(null, businessObjectArray, businessObjectArray2);
    }

    public static Iterator chooseMultiple(JFrame jFrame, BusinessObject[] businessObjectArray, BusinessObject[] businessObjectArray2) {
        AttachableComponentChooser attachableComponentChooser = new AttachableComponentChooser(jFrame, businessObjectArray, businessObjectArray2, true);
        List list = attachableComponentChooser.getSelection();
        if (list == null) {
            return null;
        }
        return list.iterator();
    }

    public static BusinessObject chooseSingle(BusinessObject[] businessObjectArray) {
        return AttachableComponentChooser.chooseSingle(null, businessObjectArray);
    }

    public static BusinessObject chooseSingle(JFrame jFrame, BusinessObject[] businessObjectArray) {
        AttachableComponentChooser attachableComponentChooser = new AttachableComponentChooser(jFrame, businessObjectArray, null, false);
        List list = attachableComponentChooser.getSelection();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (BusinessObject)list.get(0);
    }

    protected void setButtons() {
        this.attachButton.setEnabled(this.leftList.getSelectedIndex() != -1);
        this.detachButton.setEnabled(this.rightList.getSelectedIndex() != -1);
        if (!this.multiple) {
            this.okButton.setEnabled(this.leftList.getSelectedIndex() != -1);
        }
    }

    private ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    if (jButton.equals(AttachableComponentChooser.this.attachButton)) {
                        Object e;
                        int n;
                        int n2;
                        int[] nArray = AttachableComponentChooser.this.leftList.getSelectedIndices();
                        for (n2 = 0; n2 < nArray.length; ++n2) {
                            n = nArray[n2];
                            e = AttachableComponentChooser.this.leftModel.get(n);
                            if (!AttachableComponentChooser.this.isExclusiveObject(e)) continue;
                            for (int i = n2 + 1; i < nArray.length; ++i) {
                                if (!AttachableComponentChooser.this.isExclusive(AttachableComponentChooser.this.leftModel.get(nArray[i]), e)) continue;
                                GUIUtilities.error(null, "Can not select these components simultaneously.");
                                return;
                            }
                        }
                        for (n2 = 0; n2 < nArray.length; ++n2) {
                            n = nArray[n2];
                            e = AttachableComponentChooser.this.leftModel.get(n);
                            ((AttachableComponentChooser)AttachableComponentChooser.this).flags[((AttachableComponentChooser)AttachableComponentChooser.this).allBOVector.indexOf(e)] = true;
                            if (!AttachableComponentChooser.this.isExclusiveObject(e)) continue;
                            Enumeration enumeration = AttachableComponentChooser.this.rightModel.elements();
                            while (enumeration.hasMoreElements()) {
                                Object e2 = enumeration.nextElement();
                                if (!AttachableComponentChooser.this.isExclusive(e2, e)) continue;
                                ((AttachableComponentChooser)AttachableComponentChooser.this).flags[((AttachableComponentChooser)AttachableComponentChooser.this).allBOVector.indexOf(e2)] = false;
                            }
                        }
                        AttachableComponentChooser.this.setListModels();
                    } else if (jButton.equals(AttachableComponentChooser.this.detachButton)) {
                        int[] nArray = AttachableComponentChooser.this.rightList.getSelectedIndices();
                        for (int i = 0; i < nArray.length; ++i) {
                            int n = nArray[i];
                            Object e = AttachableComponentChooser.this.rightModel.get(n);
                            ((AttachableComponentChooser)AttachableComponentChooser.this).flags[((AttachableComponentChooser)AttachableComponentChooser.this).allBOVector.indexOf(e)] = false;
                        }
                        AttachableComponentChooser.this.setListModels();
                    } else if (jButton.equals(AttachableComponentChooser.this.okButton)) {
                        AttachableComponentChooser.this.canceled = false;
                        AttachableComponentChooser.this.setVisible(false);
                    } else if (jButton.equals(AttachableComponentChooser.this.cancelButton)) {
                        AttachableComponentChooser.this.leftList.clearSelection();
                        AttachableComponentChooser.this.rightList.clearSelection();
                        AttachableComponentChooser.this.leftModel.clear();
                        AttachableComponentChooser.this.setVisible(false);
                    }
                    AttachableComponentChooser.this.setButtons();
                }
            };
        }
        return this.actionListener;
    }

    private boolean isExclusiveObject(Object object) {
        if (object instanceof FieldSource) {
            return true;
        }
        return object instanceof AbstractInstrumentSpec;
    }

    private boolean isExclusive(Object object, Object object2) {
        if (object.getClass() == object2.getClass()) {
            return true;
        }
        return object instanceof AbstractInstrumentSpec && object2 instanceof AbstractInstrumentSpec;
    }

    private ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = new CellRenderer();
        }
        return this.cellRenderer;
    }

    private void setListModels() {
        this.leftModel.removeAllElements();
        this.rightModel.removeAllElements();
        for (int i = 0; i < this.flags.length; ++i) {
            BusinessObject businessObject = (BusinessObject)this.allBOVector.get(i);
            if (!this.flags[i]) {
                this.leftModel.addElement(businessObject);
                continue;
            }
            this.rightModel.addElement(businessObject);
        }
    }

    private List getSelection() {
        if (this.canceled) {
            return null;
        }
        Vector vector = new Vector();
        if (this.multiple) {
            for (int i = 0; i < this.rightModel.getSize(); ++i) {
                vector.add(this.rightModel.elementAt(i));
            }
        } else {
            int n = this.leftList.getSelectedIndex();
            if (n >= 0) {
                vector.add(this.leftModel.elementAt(n));
            }
        }
        return vector;
    }

    private ListSelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    AttachableComponentChooser.this.setButtons();
                }
            };
        }
        return this.selectionListener;
    }

    private void build() {
        this.contentPane = this.getContentPane();
        this.createComponents();
        this.layoutComponents();
        this.setButtons();
        this.pack();
        this.setVisible(true);
    }

    private void createComponents() {
        this.setListModels();
        this.leftList = new JList(this.leftModel);
        this.rightList = new JList(this.rightModel);
        this.attachButton = new JButton("\u2192");
        this.detachButton = new JButton("\u2190");
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.attachButton.addActionListener(this.getActionListener());
        this.detachButton.addActionListener(this.getActionListener());
        this.okButton.addActionListener(this.getActionListener());
        this.cancelButton.addActionListener(this.getActionListener());
        if (this.multiple) {
            this.leftList.setSelectionMode(2);
            this.rightList.setSelectionMode(2);
        } else {
            this.leftList.setSelectionMode(0);
            this.rightList.setSelectionMode(0);
        }
        this.leftList.getSelectionModel().addListSelectionListener(this.getSelectionListener());
        this.rightList.getSelectionModel().addListSelectionListener(this.getSelectionListener());
        this.leftList.setCellRenderer(this.getCellRenderer());
        this.rightList.setCellRenderer(this.getCellRenderer());
    }

    private void layoutComponents() {
        JPanel jPanel;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.contentPane.setLayout(gridBagLayout);
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel("Attachable Components");
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.contentPane.add(jLabel);
        if (this.multiple) {
            jLabel = new JLabel("Selected");
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.contentPane.add(jLabel);
        }
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.leftList);
        gridBagLayout.setConstraints(scrollWhenFocusedPane, gridBagConstraints);
        this.contentPane.add(scrollWhenFocusedPane);
        if (this.multiple) {
            gridBagConstraints.gridx = 1;
            jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 3));
            jPanel2.add(this.attachButton);
            jPanel2.add(Box.createVerticalStrut(5));
            jPanel2.add(this.detachButton);
            jPanel.add(jPanel2);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.contentPane.add(jPanel);
            gridBagConstraints.gridx = 2;
            scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.rightList);
            gridBagLayout.setConstraints(scrollWhenFocusedPane, gridBagConstraints);
            this.contentPane.add(scrollWhenFocusedPane);
        }
        gridBagConstraints.gridy = 2;
        jPanel = new JPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        if (this.multiple) {
            gridBagConstraints.gridwidth = 0;
        }
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.contentPane.add(jPanel);
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = schedBlock.createTarget();
        ScienceParameters scienceParameters = schedBlock.createScienceParameters();
        scienceParameters.setName("sp1");
        ScienceParameters scienceParameters2 = schedBlock.createScienceParameters();
        scienceParameters2.setName("sp2");
        ScienceParameters scienceParameters3 = schedBlock.createScienceParameters();
        scienceParameters3.setName("sp3");
        ScienceParameters scienceParameters4 = schedBlock.createScienceParameters();
        scienceParameters4.setName("sp4");
        ScienceParameters scienceParameters5 = schedBlock.createScienceParameters();
        scienceParameters5.setName("sp5");
        PhaseCalParameters phaseCalParameters = schedBlock.createPhaseCalParameters();
        phaseCalParameters.setName("ph1");
        FieldSource fieldSource = schedBlock.createFieldSource();
        fieldSource.setName("source1");
        FieldSource fieldSource2 = schedBlock.createFieldSource();
        fieldSource2.setName("source2");
        FieldSource fieldSource3 = schedBlock.createFieldSource();
        fieldSource3.setName("source3");
        FieldSource fieldSource4 = schedBlock.createFieldSource();
        fieldSource4.setName("source4");
        SpectralSpec spectralSpec = schedBlock.createSpectralSpec();
        spectralSpec.setName("spec1");
        BusinessObject[] businessObjectArray = new BusinessObject[]{scienceParameters, scienceParameters2, scienceParameters3, scienceParameters4, scienceParameters5, phaseCalParameters, fieldSource, fieldSource2, fieldSource3, fieldSource4, spectralSpec};
        ObservingParameters[] observingParametersArray = schedBlock.getObservingParameters();
        FieldSource[] fieldSourceArray = schedBlock.getFieldSource();
        target.setFieldSource(fieldSource);
        BusinessObject[] businessObjectArray2 = new BusinessObject[]{target.getFieldSource(), scienceParameters, phaseCalParameters};
        Iterator iterator = AttachableComponentChooser.chooseMultiple(businessObjectArray, businessObjectArray2);
        if (iterator == null) {
            System.out.println("Canceled!!!");
        } else {
            while (iterator.hasNext()) {
                System.out.println("multi  : " + iterator.next());
            }
            System.out.println("multi done");
        }
    }

    private final class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            try {
                BusinessObject businessObject = (BusinessObject)object;
                if (businessObject == null) {
                    this.setText("#" + n + ": null");
                } else {
                    this.setText(businessObject.getShortClassName() + " - " + businessObject.getNameOrDefault());
                }
            }
            catch (ClassCastException classCastException) {
                this.setText(object.toString());
            }
            return this;
        }
    }
}

