/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.util.TextUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;

public abstract class ComboBoxPair {
    protected Editor parentEditor;
    protected JComboBox combo1;
    protected JComboBox combo2;
    protected ActionListener listener1;
    protected ActionListener listener2;
    protected Map<JComboBox, ActionListener> listenerMap = new HashMap<JComboBox, ActionListener>();

    public ComboBoxPair(JComboBox jComboBox, JComboBox jComboBox2) {
        this(null, jComboBox, jComboBox2);
    }

    public ComboBoxPair(Editor editor, JComboBox jComboBox, JComboBox jComboBox2) {
        this.parentEditor = editor;
        this.combo1 = jComboBox;
        this.combo2 = jComboBox2;
        final JComboBox jComboBox3 = jComboBox;
        final JComboBox jComboBox4 = jComboBox2;
        this.listener1 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboBoxPair.this.update(jComboBox3, jComboBox4);
            }
        };
        jComboBox.addActionListener(this.listener1);
        this.listenerMap.put(jComboBox, this.listener1);
        this.listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboBoxPair.this.update(jComboBox4, jComboBox3);
            }
        };
        jComboBox2.addActionListener(this.listener2);
        this.listenerMap.put(jComboBox2, this.listener2);
    }

    public void reset() {
        this.update(this.combo1, this.combo2);
        this.update(this.combo2, this.combo1);
    }

    protected void update(JComboBox jComboBox, JComboBox jComboBox2) {
        ItemCategory[] itemCategoryArray;
        String string = (String)jComboBox.getSelectedItem();
        if (string == null) {
            return;
        }
        String string2 = TextUtils.stripHtmlTags(string);
        String[] stringArray = this.getPlainTextLabels(jComboBox, jComboBox2);
        if (stringArray.length != (itemCategoryArray = this.getCategories(jComboBox, jComboBox2)).length) {
            return;
        }
        int n = jComboBox2.getSelectedIndex();
        ActionListener actionListener = this.listenerMap.get(jComboBox2);
        this.suspendEvents(jComboBox2);
        jComboBox2.removeActionListener(actionListener);
        jComboBox2.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox2.addItem(this.htmlString(stringArray[i], itemCategoryArray[i]));
        }
        jComboBox2.setSelectedIndex(n);
        jComboBox2.addActionListener(actionListener);
        this.resumeEvents(jComboBox2);
    }

    protected void suspendEvents(JComboBox jComboBox) {
        if (this.parentEditor != null) {
            this.parentEditor.suspendEvents(jComboBox);
        }
    }

    protected void resumeEvents(JComboBox jComboBox) {
        if (this.parentEditor != null) {
            this.parentEditor.resumeEvents(jComboBox);
        }
    }

    public abstract ItemCategory[] getCategories(JComboBox var1, JComboBox var2);

    public abstract String[] getPlainTextLabels(JComboBox var1, JComboBox var2);

    protected String htmlString(String string, ItemCategory itemCategory) {
        String string2;
        switch (itemCategory) {
            case OK: {
                string2 = string;
                break;
            }
            case NG: {
                string2 = "<i><font color=gray>" + string + "</font></i>";
                break;
            }
            case NA: {
                string2 = "<s><i><font color=gray>" + string + "</font></i></s>";
                break;
            }
            default: {
                string2 = string;
            }
        }
        return "<html>" + string2 + "</html>";
    }

    protected static enum ItemCategory {
        OK,
        NG,
        NA;

    }
}

