/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.ACASpectralWindow;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DebugSpectralWindowTable
extends JFrame {
    private TableModel model;

    public DebugSpectralWindowTable(AbstractBaseBandConfig abstractBaseBandConfig) {
        Dimension dimension = new Dimension(1024, 200);
        this.setPreferredSize(dimension);
        this.model = new TableModel();
        this.model.setBaseBandConfig(abstractBaseBandConfig);
        JTable jTable = new JTable(this.model);
        jTable.getTableHeader().setReorderingAllowed(false);
        JButton jButton = new JButton("Update");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DebugSpectralWindowTable.this.model.fireTableDataChanged();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 3));
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(jTable);
        container.add(scrollWhenFocusedPane);
        container.add(jButton);
        this.pack();
        this.setTitle("SpectralWindows");
        this.setVisible(true);
    }

    class TableModel
    extends AbstractTableModel {
        public static final int COL_INDEX = 0;
        public static final int COL_NAME = 1;
        public static final int COL_OFFSET = 2;
        public static final int COL_SIDEBAND = 3;
        public static final int COL_ASSOC = 4;
        public static final int COL_USETHIS = 5;
        public static final int COL_EFFBW = 6;
        public static final int COL_EFFCH = 7;
        public static final int COL_POL = 8;
        public static final int COL_AVGFACT = 9;
        public static final int COL_WSFUNC = 10;
        public static final int COL_BITS = 11;
        public static final int COL_OVERSMP = 12;
        public static final int COL_QUANTCOR = 13;
        public static final int COL_FRQREPRO = 14;
        public static final int COL_NCHAVREG = 15;
        public static final int NCOLUMNS = 16;
        private AbstractBaseBandConfig bbc;

        TableModel() {
        }

        public void setBaseBandConfig(AbstractBaseBandConfig abstractBaseBandConfig) {
            this.bbc = abstractBaseBandConfig;
        }

        @Override
        public int getColumnCount() {
            return 16;
        }

        @Override
        public int getRowCount() {
            return this.bbc.getSingleSpectralWindowCount();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "No.";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "offset";
                }
                case 3: {
                    return "Sideband";
                }
                case 4: {
                    return "Associate";
                }
                case 5: {
                    return "use this";
                }
                case 6: {
                    return "Eff BW";
                }
                case 7: {
                    return "Eff Ch";
                }
                case 8: {
                    return "Polz";
                }
                case 9: {
                    return "Avg.Factor";
                }
                case 10: {
                    return "Win.Func.";
                }
                case 11: {
                    return "Corr Bits";
                }
                case 12: {
                    return "OverSampl";
                }
                case 13: {
                    return "Quant.Corr.";
                }
                case 14: {
                    return "Frq.Repro.";
                }
                case 15: {
                    return "N.Ch Avg";
                }
            }
            throw new RuntimeException("Unexpected column number : " + n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.bbc == null) {
                return null;
            }
            AbstractSpectralWindow abstractSpectralWindow = this.bbc.getSingleSpectralWindow(n);
            switch (n2) {
                case 0: {
                    return n;
                }
                case 1: {
                    return abstractSpectralWindow.gettrueName();
                }
                case 2: {
                    return abstractSpectralWindow.getCenterFrequency().getContentInMHz();
                }
                case 3: {
                    return abstractSpectralWindow.getSideBand();
                }
                case 4: {
                    return abstractSpectralWindow.getAssociatedSpectralWindowNumberInPair();
                }
                case 5: {
                    return abstractSpectralWindow.gettrueUseThisSpectralWindow();
                }
                case 6: {
                    return abstractSpectralWindow.getEffectiveBandwidth();
                }
                case 7: {
                    return abstractSpectralWindow.getEffectiveNumberOfChannels();
                }
                case 8: {
                    return abstractSpectralWindow.getPolnProducts();
                }
                case 9: {
                    return abstractSpectralWindow.gettrueSpectralAveragingFactor();
                }
                case 10: {
                    return abstractSpectralWindow.getWindowFunction();
                }
                case 11: {
                    return abstractSpectralWindow.getCorrelatorType() == CorrelatorType.ACA ? null : ((BLSpectralWindow)((Object)abstractSpectralWindow)).getCorrelationBits();
                }
                case 12: {
                    return abstractSpectralWindow.getCorrelatorType() == CorrelatorType.ACA ? null : Boolean.valueOf(((BLSpectralWindow)((Object)abstractSpectralWindow)).getCorrelationNyquistOversampling());
                }
                case 13: {
                    return abstractSpectralWindow.getCorrelatorType() == CorrelatorType.ACA ? null : Boolean.valueOf(((BLSpectralWindow)((Object)abstractSpectralWindow)).getQuantizationCorrection());
                }
                case 14: {
                    return abstractSpectralWindow.getCorrelatorType() == CorrelatorType.ACA ? Boolean.valueOf(((ACASpectralWindow)((Object)abstractSpectralWindow)).getFrqChProfReproduction()) : null;
                }
                case 15: {
                    return abstractSpectralWindow.getChannelAverageRegionCount();
                }
            }
            throw new RuntimeException("Unexpected column number : " + n2);
        }
    }
}

