/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.CrossPatternEditor;
import alma.obsprep.ot.editors.schedblock.FieldPatternEditorTestMain;
import alma.obsprep.ot.editors.schedblock.FillPatternEditor;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.editors.schedblock.RectanglePatternEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.FieldPatternModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FieldPatternEditor
extends EditorWithGridBagLayout {
    public static final FieldID BEAMSIZE_LABEL_FID = new FieldID("FieldPatternEditor.BeamsizeLabelFID");
    public static final FieldID BEAMSIZE_INFO_FID = new FieldID("FieldPatternEditor.BeamsizeInfoFID");
    public static final FieldID FIELDPATTERNTYPELIST_FID = new FieldID("FieldPatternEditor.fieldPatternTypeListFID");
    public static final FieldID REVERT_FID = new FieldID("FieldPatternEditor.RevertFID");
    private final Map<FieldPattern.FieldPatternType, JPanel> fieldPatternEditorPanels = new HashMap<FieldPattern.FieldPatternType, JPanel>();
    private JPanel currentPattern = null;
    protected PointingPatternEditor pointingPatternEditor;
    protected RectanglePatternEditor rectanglePatternEditor;
    protected CrossPatternEditor crossPatternEditor;
    protected FillPatternEditor fillPatternEditor;

    public FieldPatternEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public FieldPatternModel getModel() {
        return (FieldPatternModel)super.getModel();
    }

    @Override
    protected boolean wantGlobalButtons() {
        return false;
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.weightx = 1.0;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        componentCollection.remember(this.makeLabel(BEAMSIZE_LABEL_FID, "", ""));
        JTextField jTextField = this.makeTextField(BEAMSIZE_INFO_FID, 30, false, "<html>Antenna Beamsize (" + Antenna.BEAMSIZE_TIP_STRING + ")");
        jTextField.setFocusable(false);
        componentCollection.remember(jTextField);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        String[] stringArray = FieldPattern.FieldPatternType.getKnownLabels();
        this.addComboBox((JComponent)jPanel, gridBagLayout, gridBagConstraints, FIELDPATTERNTYPELIST_FID, "Type", "The field pattern type", stringArray);
        JButton jButton = this.makeButton(REVERT_FID, "Revert to Rectangle", "Click this if you wish to cancel the pointing mosaic and revert to the rectangle pattern");
        jButton.setVisible(false);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jButton);
        this.addGroup(jPanel, string);
        for (FieldPattern.FieldPatternType fieldPatternType : FieldPattern.FieldPatternType.values()) {
            jPanel = this.addGroup(this.createPatternTypePanel(fieldPatternType), fieldPatternType.getLabel());
            this.fieldPatternEditorPanels.put(fieldPatternType, jPanel);
            jPanel.setVisible(false);
            if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.RECTANGLE)) {
                CSH.setHelpIDString((Component)jPanel, (String)"TOC-Field Sources-FieldPatternEditor-Rectangle");
                continue;
            }
            if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.POINT)) {
                CSH.setHelpIDString((Component)jPanel, (String)"TOC-Field Sources-FieldPatternEditor-Point");
                continue;
            }
            if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.CROSS)) {
                CSH.setHelpIDString((Component)jPanel, (String)"TOC-Field Sources-FieldPatternEditor-Cross");
                continue;
            }
            if (!fieldPatternType.equals((Object)FieldPattern.FieldPatternType.FILL)) continue;
            CSH.setHelpIDString((Component)jPanel, (String)"TOC-Field Sources-FieldPatternEditor-Fill");
        }
    }

    private JPanel createPatternTypePanel(FieldPattern.FieldPatternType fieldPatternType) {
        switch (fieldPatternType) {
            case RECTANGLE: {
                this.rectanglePatternEditor = new RectanglePatternEditor(this.getModel().getRectanglePatternModel());
                this.registerSubView(this.rectanglePatternEditor);
                ActionListener actionListener = actionEvent -> {
                    if (actionEvent.getActionCommand().equals("Convert")) {
                        this.getModel().convertRectangleToPointings();
                    }
                };
                this.rectanglePatternEditor.setConvertButtonAction(actionListener);
                return this.rectanglePatternEditor;
            }
            case POINT: {
                this.pointingPatternEditor = new PointingPatternEditor(this.getModel().getPointingPatternModel());
                this.registerSubView(this.pointingPatternEditor);
                return this.pointingPatternEditor;
            }
            case CROSS: {
                this.crossPatternEditor = new CrossPatternEditor(this.getModel().getCrossPatternModel());
                this.registerSubView(this.crossPatternEditor);
                return this.crossPatternEditor;
            }
            case FILL: {
                this.fillPatternEditor = new FillPatternEditor(this.getModel().getFillPatternModel());
                this.registerSubView(this.fillPatternEditor);
                return this.fillPatternEditor;
            }
        }
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, "Not currently supported");
        return jPanel;
    }

    @Override
    protected void build() {
        super.build("FieldPatternEditor");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FIELDPATTERNTYPELIST_FID) {
            if (this.currentPattern != null) {
                this.currentPattern.setVisible(false);
            }
            FieldPattern.FieldPatternType fieldPatternType = object instanceof FieldPattern.FieldPatternType ? (FieldPattern.FieldPatternType)((Object)object) : FieldPattern.FieldPatternType.getFieldPatternType((String)object);
            super.update(fieldID, fieldPatternType.getLabel());
            this.currentPattern = this.fieldPatternEditorPanels.get((Object)fieldPatternType);
            if (this.currentPattern != null) {
                this.currentPattern.setVisible(true);
            }
            if (fieldPatternType == FieldPattern.FieldPatternType.POINT) {
                ((PointingPatternModel)this.pointingPatternEditor.getModel()).getPointingPatternTableModel().fireTableStructureChanged();
            }
            this.setRevertButton();
            return;
        }
        if (fieldID == BEAMSIZE_LABEL_FID) {
            Frequency frequency = (Frequency)((Object)object);
            String string = "Antenna Beamsize@" + TextUtils.format(frequency, 0);
            super.update(fieldID, string);
            return;
        }
        if (fieldID == BEAMSIZE_INFO_FID) {
            Frequency frequency = (Frequency)((Object)object);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("12m:");
            stringBuffer.append(Antenna.ANTENNA_12M.formatBeamSize(frequency));
            stringBuffer.append(", 7m:");
            stringBuffer.append(Antenna.ANTENNA_7M.formatBeamSize(frequency));
            super.update(fieldID, stringBuffer.toString());
            return;
        }
        if (fieldID == REVERT_FID) {
            return;
        }
        super.update(fieldID, object);
    }

    public PointingPatternEditor getPointingPatternEditor() {
        return this.pointingPatternEditor;
    }

    private void setRevertButton() {
        JButton jButton = (JButton)this.retrieve(REVERT_FID);
        FieldSource fieldSource = this.getModel().getFieldSource();
        boolean bl = fieldSource != null && fieldSource.getFieldPattern() != null && fieldSource.getFieldPatternType().equals(FieldPattern.TYPE_POINT) && fieldSource.getOldFieldPattern() instanceof RectanglePattern;
        jButton.setVisible(bl);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        FieldPatternEditorTestMain.main(stringArray);
    }
}

