/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.FillPatternModel;
import alma.valuetypes.SkyCoordinates;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class FillPatternEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_SCAN_COORD_SYSTEM = new FieldID("FillPatternEditor.scanningCoordinateSystemFID");
    public static final FieldID FID_PATTERN_TYPE = new FieldID("FillPatternEditor.patternTypeFID");
    private CoordsEditor patternCentreCoordsEditor;

    public FillPatternEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        FillPatternModel fillPatternModel = (FillPatternModel)this.getModel();
        this.constraints.insets = new Insets(0, 2, 0, 2);
        this.patternCentreCoordsEditor = new CoordsEditor(true, fillPatternModel.getPatternCenterCoordsModel());
        this.registerSubView(this.patternCentreCoordsEditor);
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Pattern Center Coords", (JComponent)this.patternCentreCoordsEditor);
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, fillPatternModel.getLatitudeLengthModel(), "Lat. length", "The latitude length");
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, fillPatternModel.samplingStepModel(), "Sampling length", "The sampling length");
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, fillPatternModel.getLongitudeLengthModel(), "Long. length", "The longitude length");
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, fillPatternModel.getOrientationModel(), "Orientation", "The fill pattern's orientation");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SkyCoordinates.SYSTEM_J2000, "FK5 J2000");
        String[] stringArray = FillPattern.getKnownScanningCoordinateSystemList();
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.equals(FillPattern.SCANNINGCOORDINATESYSTEM_J2000)) {
                stringArray[n] = "FK5 J2000";
                break;
            }
            ++n;
        }
        JComboBox jComboBox = this.makeComboBox(FID_PATTERN_TYPE, FillPattern.getKnownPatternTypeList(), "The pattern type");
        this.addLabeledComponent((JComponent)this, this.layout, this.constraints, "Pattern Type", (JComponent)jComboBox);
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.addComboBox(this, this.layout, this.constraints, FID_SCAN_COORD_SYSTEM, "Scanning Coordinate System", "Scanning Coordinate System", stringArray, hashMap);
    }

    @Override
    public void build() {
        super.build("FillPatternEditor");
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        FillPattern fillPattern = FillPattern.createFillPattern();
        FillPatternModel fillPatternModel = new FillPatternModel(null);
        FillPatternEditor fillPatternEditor = new FillPatternEditor(fillPatternModel);
        fillPatternModel.setDocument((Object)fillPattern);
        JFrame jFrame = new JFrame("TEST:FillPatternEditor");
        jFrame.setPreferredSize(new Dimension(600, 600));
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.add(fillPatternEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

