/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.MultipageViewException;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.TargetEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.TargetModel;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class NoObservingParameterPanel
extends EditorWithGridBagLayout {
    protected final String labelNew = "Create new";
    public static FieldID FID_OP_OK = new FieldID("fid-op-ok");
    protected ArrayList<FieldID> checkboxFIDs = new ArrayList();
    protected ArrayList<FieldID> comboboxFIDs = new ArrayList();
    private HashMap<FieldID, JComboBox> comboboxes = new HashMap();
    private HashMap<FieldID, AddInteractor.ObjectType> paramtypes = new HashMap();

    public NoObservingParameterPanel(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public TargetModel getModel() {
        return (TargetModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        this.initEvents(jButton, FID_OP_OK);
        jPanel.add(jButton);
        String string2 = "<html><br><br><b>Use this target for what purpose?</b><br>(<i>Check all that apply</i>)<br><br><br></html>";
        this.addLabel(this, this.layout, this.constraints, string2);
        AddInteractor.ObjectType[] objectTypeArray = new AddInteractor.ObjectType[]{AddInteractor.ObjectType.SCIENCEPARAMETERS, AddInteractor.ObjectType.PHASECALPARAMETERS, AddInteractor.ObjectType.POINTINGCALPARAMETERS, AddInteractor.ObjectType.AMPLITUDECALPARAMETERS, AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS, AddInteractor.ObjectType.FOCUSCALPARAMETERS, AddInteractor.ObjectType.DELAYCALPARAMETERS, AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS, AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS, AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS, AddInteractor.ObjectType.BANDPASSCALPARAMETERS};
        for (int i = 0; i < objectTypeArray.length; ++i) {
            this.addObservingParametersOptions(objectTypeArray[i]);
        }
        this.addComponent(jPanel);
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    private void addObservingParametersOptions(AddInteractor.ObjectType objectType) {
        String string = objectType.toString().substring(0, objectType.toString().lastIndexOf(" Parameters"));
        String string2 = "Select if you want to use this target for " + string;
        String string3 = "Select an existing " + objectType.toString() + " to use, " + " or select \"" + "Create new" + "\" to create a new parameter set and attach to this target.";
        FieldID fieldID = new FieldID("ObservingParameters." + string + "Check");
        FieldID fieldID2 = new FieldID("ObservingParameters." + string + "Combo");
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        componentCollection.remember(this.makeLabel(string));
        componentCollection.remember(this.makeCheckBox(fieldID, string2));
        JComponent[] jComponentArray = new JComponent[1];
        JComboBox jComboBox = this.makeComboBox(fieldID2, null, string3);
        jComponentArray[0] = jComboBox;
        componentCollection.remember(jComponentArray);
        jComboBox.setVisible(false);
        this.addComponentArray(this, this.layout, this.constraints, componentCollection);
        this.addObservingParametersOptionList(objectType, fieldID, fieldID2, jComboBox);
    }

    @Override
    protected void build() {
        super.build("No Observing Parameters");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (this.checkboxFIDs.indexOf(fieldID) >= 0) {
            this.setupObservingParametersDropdownList(fieldID);
            return;
        }
        if (this.comboboxFIDs.indexOf(fieldID) >= 0) {
            return;
        }
        if (fieldID.equals(FID_OP_OK)) {
            this.setObservingParameters();
            for (FieldID fieldID2 : this.checkboxFIDs) {
                ((JCheckBox)this.retrieve(fieldID2)).setSelected(false);
            }
            return;
        }
        super.update(fieldID, object);
    }

    private ObservingParameters getSelectedObservingParameters(AddInteractor.ObjectType objectType, JComboBox jComboBox) {
        String string;
        SchedBlock schedBlock = this.getModel().getTarget().getSchedBlock();
        ObservingParameters observingParameters = null;
        int n = jComboBox.getSelectedIndex();
        if (n == 0) {
            observingParameters = schedBlock.createObservingParameters(objectType);
        } else if (n - 1 < schedBlock.getObservingParametersCount(objectType) && !(string = (observingParameters = schedBlock.getObservingParameters(objectType)[n - 1]).getNameOrDefault()).equals(jComboBox.getSelectedItem())) {
            observingParameters = null;
        }
        return observingParameters;
    }

    private void setObservingParameters() {
        ObservingToolGui observingToolGui;
        SchedBlock schedBlock = this.getModel().getTarget().getSchedBlock();
        Target target = this.getModel().getTarget();
        for (FieldID object2 : this.checkboxFIDs) {
            ObservingParameters observingParameters;
            JComboBox multipageViewException = this.comboBox(object2);
            AddInteractor.ObjectType objectType = this.objectType(object2);
            JCheckBox jCheckBox = (JCheckBox)this.retrieve(object2);
            if (!jCheckBox.isSelected() || (observingParameters = this.getSelectedObservingParameters(objectType, multipageViewException)) == null) continue;
            target.addObservingParameters(observingParameters);
        }
        this.getModel().getObservingParameterTabModel().setDocument(target);
        this.getModel().publish(TargetEditor.DOCUMENT_FID, target);
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        if (observingToolController != null && (observingToolGui = observingToolController.getGui()) != null) {
            observingToolGui.refreshCrossHighlight();
            observingToolGui.jumpToBO((BusinessObject)this.getModel().getTarget());
            try {
                observingToolGui.updateEditor();
            }
            catch (MultipageViewException multipageViewException) {
                Log.logger((Object)this).warning("Cannot display component part " + target.getNameOrDefault() + " - " + multipageViewException.getLocalizedMessage());
            }
        }
    }

    private void setupObservingParametersDropdownList(FieldID fieldID) {
        SchedBlock schedBlock = this.getModel().getTarget().getSchedBlock();
        boolean bl = ((JCheckBox)this.retrieve(fieldID)).isSelected();
        JComboBox jComboBox = this.comboBox(fieldID);
        AddInteractor.ObjectType objectType = this.objectType(fieldID);
        jComboBox.setVisible(bl);
        if (bl) {
            ObservingParameters[] observingParametersArray = schedBlock.getObservingParameters(objectType);
            jComboBox.removeAllItems();
            jComboBox.addItem("Create new");
            for (int i = 0; i < observingParametersArray.length; ++i) {
                jComboBox.addItem(observingParametersArray[i].getNameOrDefault());
            }
        }
        this.repaint();
    }

    private void addObservingParametersOptionList(AddInteractor.ObjectType objectType, FieldID fieldID, FieldID fieldID2, JComboBox jComboBox) {
        this.checkboxFIDs.add(fieldID);
        this.comboboxFIDs.add(fieldID2);
        this.comboboxes.put(fieldID, jComboBox);
        this.paramtypes.put(fieldID, objectType);
    }

    protected AddInteractor.ObjectType objectType(FieldID fieldID) {
        return this.paramtypes.get(fieldID);
    }

    protected JComboBox comboBox(FieldID fieldID) {
        return this.comboboxes.get(fieldID);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        TargetModel targetModel = new TargetModel(null, observingToolController);
        NoObservingParameterPanel noObservingParameterPanel = new NoObservingParameterPanel(targetModel);
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        Target target = Target.createTarget();
        schedBlock.addTarget(target);
        targetModel.setDocument(target);
        EditorWithGridBagLayout.runTestApp(noObservingParameterPanel);
    }
}

