/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.editors.misc.DecValueCellEditor;
import alma.obsprep.ot.editors.misc.RAValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.models.schedblock.ObservingGroupAllTargetsTableModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ObservingGroupAllTargetsTable
extends Table {
    public static final int TABLE_WIDTH = 500;
    public static final int TABLE_HEIGHT = 250;

    public ObservingGroupAllTargetsTable(TableModel tableModel) {
        super(tableModel);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("All available targets for this schedule block");
        Dimension dimension = new Dimension(500, 250);
        this.setPreferredScrollableViewportSize(dimension);
        this.setFillsViewportHeight(true);
        this.setupCellEditorAndRenderer();
    }

    private void setupCellEditorAndRenderer() {
        this.setDefaultEditor(Double.class, new ValueCellEditor.Double());
        this.setDefaultEditor(Integer.class, new ValueCellEditor.Integer());
        this.setDefaultEditor(Longitude.class, new RAValueCellEditor());
        this.setDefaultEditor(Latitude.class, new DecValueCellEditor());
        this.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        this.setDefaultRenderer(Object.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Integer.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Double.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Frequency.class, new MyTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                String string2 = "";
                if (object != null) {
                    try {
                        Frequency frequency = (Frequency)((Object)object);
                        string2 = frequency.toString();
                        string = string2.substring(0, string2.indexOf(46) + 2);
                        string = string + string2.substring(string2.indexOf(32));
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        this.setDefaultRenderer(Longitude.class, new MyTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object != null) {
                    try {
                        Longitude longitude = (Longitude)((Object)object);
                        string = longitude.toHHMMSS();
                        string = string.substring(0, string.indexOf(46));
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        this.setDefaultRenderer(Latitude.class, new MyTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object != null) {
                    try {
                        Latitude latitude = (Latitude)((Object)object);
                        string = latitude.toDDMMSS();
                        string = string.substring(0, string.indexOf(46));
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        ColumnResizer.initColumnSizes(this, this.getMyModel().getLongValues());
    }

    public ObservingGroupAllTargetsTableModel getMyModel() {
        return (ObservingGroupAllTargetsTableModel)this.getModel();
    }

    public class MyTableEditorCellRenderer
    extends DefaultTableCellRenderer {
        private Color naColor = UIManager.getColor("TableHeader.background");
        private ObservingGroupAllTargetsTableModel model;

        public MyTableEditorCellRenderer(ObservingGroupAllTargetsTable observingGroupAllTargetsTable2) {
            this.model = (ObservingGroupAllTargetsTableModel)observingGroupAllTargetsTable2.getModel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n >= this.model.getRowCount()) {
                return this;
            }
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            return this;
        }
    }
}

