/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.schedblock.UsedByTargetPanel;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.OpticalCameraSpecModel;
import alma.obsprep.ot.models.schedblock.TargetModel;
import alma.obsprep.ot.models.schedblock.UsedByTargetModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class OpticalCameraSpecEditor
extends EditorWithGridBagLayout {
    private boolean systemView;

    public OpticalCameraSpecEditor(Model model, boolean bl) {
        this.systemView = bl;
        this.setModel(model);
        this.build();
        model.publish();
    }

    public OpticalCameraSpecEditor(Model model) {
        this(model, true);
    }

    @Override
    protected void addComponents(String string) {
        OpticalCameraSpecModel opticalCameraSpecModel = (OpticalCameraSpecModel)this.getModel();
        if (this.systemView) {
            this.addUsedByTargetInfoComponent();
        }
        this.addTextComponent(this, this.layout, this.constraints, FieldIDs.instrumentSpecNameFID, string + " Name", "Name of this " + string);
        this.addComboBox((JComponent)this, this.layout, this.constraints, FieldIDs.filterFID, "Filter", "Filter used", OpticalCameraSpec.getKnownFilterList());
        this.addValueUnitPair((JComponent)this, this.layout, this.constraints, opticalCameraSpecModel.getMinIntegrationTimeModel(), "Min Integration Time", "Mininum integration time for each target star");
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    protected void addUsedByTargetInfoComponent() {
        UsedByTargetModel usedByTargetModel = ((OpticalCameraSpecModel)this.getModel()).getUsedByTargetModel();
        UsedByTargetPanel usedByTargetPanel = new UsedByTargetPanel(usedByTargetModel);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObservingToolGui observingToolGui;
                boolean bl = ((OpticalCameraSpecModel)OpticalCameraSpecEditor.this.getModel()).usedByTarget();
                if (bl && (observingToolGui = ObservingToolController.getMyInstance().getGui()) != null) {
                    TargetModel targetModel = (TargetModel)observingToolGui.getEditors().modelFor(Target.class);
                    targetModel.duplicateInstrumentSpec();
                    observingToolGui.refreshCrossHighlight();
                }
            }
        };
        usedByTargetPanel.addOnlyThisButtonListener(actionListener);
        this.addComponent(usedByTargetPanel);
        this.registerSubView(usedByTargetPanel);
    }

    @Override
    protected void build() {
        super.build("Optical Camera Spec");
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        OpticalCameraSpec opticalCameraSpec = OpticalCameraSpec.createOpticalCameraSpec();
        OpticalCameraSpecModel opticalCameraSpecModel = new OpticalCameraSpecModel(null);
        OpticalCameraSpecEditor opticalCameraSpecEditor = new OpticalCameraSpecEditor(opticalCameraSpecModel);
        opticalCameraSpecModel.setDocument(opticalCameraSpec);
        JFrame jFrame = new JFrame("OpticalCameraSpecEditor");
        jFrame.getContentPane().add(opticalCameraSpecEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

