/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.editors.sciencegoals.TargetParametersEditor;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.sciencegoals.TargetParametersModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;

public class PointingPatternEditorTestMain
extends JFrame {
    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        PointingPatternEditorTestMain pointingPatternEditorTestMain = new PointingPatternEditorTestMain();
        pointingPatternEditorTestMain.testTargetParameters();
    }

    private PointingPatternEditorTestMain() {
        this.setTitle("PointingPatternEditor");
        this.setDefaultCloseOperation(3);
    }

    private void showEditor(Editor editor, Editor editor2) {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 3));
        container.add(editor);
        if (editor2 != null) {
            container.add(editor2);
        }
        this.pack();
        this.setVisible(true);
    }

    private void showEditor(Editor editor) {
        this.showEditor(editor, null);
    }

    private TargetParameters createTestTargetParameters() {
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createOffsetCoordinates();
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        SinglePoint singlePoint = SinglePoint.createSinglePoint(skyCoordinates2);
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_GALACTIC);
        skyCoordinates.getLongitude().setContentAndUnit(15.0, Longitude.UNIT_DEG);
        targetParameters.setSourceCoordinates(skyCoordinates);
        skyCoordinates2.setSystem(SkyCoordinates.SYSTEM_GALACTIC);
        skyCoordinates2.getLongitude().setContentAndUnit(1800.0, Longitude.UNIT_ARCSEC);
        skyCoordinates2.getLatitude().setContentAndUnit(0.0, Longitude.UNIT_ARCSEC);
        targetParameters.addField((Field)((Object)singlePoint));
        return targetParameters;
    }

    private TargetParameters createHorseheadTargetParameters() {
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createOffsetCoordinates();
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        SinglePoint singlePoint = SinglePoint.createSinglePoint(skyCoordinates2);
        skyCoordinates.getLongitude().setContentAndUnit(85.2458, Longitude.UNIT_DEG);
        skyCoordinates.getLatitude().setContentAndUnit(-2.4583, Latitude.UNIT_DEG);
        targetParameters.setSourceCoordinates(skyCoordinates);
        skyCoordinates2.getLongitude().setContentAndUnit(100.0, Longitude.UNIT_ARCSEC);
        skyCoordinates2.getLatitude().setContentAndUnit(0.0, Longitude.UNIT_ARCSEC);
        targetParameters.addField((Field)((Object)singlePoint));
        return targetParameters;
    }

    public void testTargetParameters() {
        TargetParameters targetParameters = this.createHorseheadTargetParameters();
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        obsProposal.addAbstractScienceGoal((AbstractScienceGoal)((Object)scienceGoal));
        scienceGoal.clearTargetParameters();
        scienceGoal.addTargetParameters(targetParameters);
        ScienceSpectralWindow scienceSpectralWindow = scienceGoal.getSpectralSetupParameters().addNewSpectralWindow();
        scienceSpectralWindow.getCenterFrequency().setContent(100.0);
        TargetParametersModel targetParametersModel = new TargetParametersModel(targetParameters);
        TargetParametersEditor targetParametersEditor = new TargetParametersEditor(targetParametersModel);
        targetParametersModel.setDocument(targetParameters);
        this.showEditor(targetParametersEditor);
    }

    private PointingPattern createTestPointingPattern() {
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        SkyCoordinates skyCoordinates2 = SkyCoordinates.createOffsetCoordinates();
        FieldSource fieldSource = FieldSource.createFieldSource();
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_GALACTIC);
        skyCoordinates.getLongitude().setContentAndUnit(15.0, Longitude.UNIT_DEG);
        fieldSource.setSourceCoordinates(skyCoordinates);
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
        skyCoordinates2.setSystem(SkyCoordinates.SYSTEM_GALACTIC);
        skyCoordinates2.getLongitude().setContentAndUnit(1800.0, Longitude.UNIT_ARCSEC);
        skyCoordinates2.getLatitude().setContentAndUnit(0.0, Longitude.UNIT_ARCSEC);
        pointingPattern.addPhaseCenterCoordinates(skyCoordinates2);
        return pointingPattern;
    }

    public void testPointingPattern() {
        PointingPattern pointingPattern = this.createTestPointingPattern();
        final PointingPatternModel pointingPatternModel = new PointingPatternModel(pointingPattern);
        PointingPatternEditor pointingPatternEditor = new PointingPatternEditor(pointingPatternModel);
        pointingPatternModel.setDocument(pointingPattern);
        pointingPatternEditor.setBorder(BorderFactory.createTitledBorder("Pointing Pattern Editor"));
        SkyCoordinates skyCoordinates = pointingPattern.getSourceCoordinates();
        SkyCoordsModel skyCoordsModel = new SkyCoordsModel(skyCoordinates);
        SkyCoordsEditor skyCoordsEditor = new SkyCoordsEditor(skyCoordsModel);
        skyCoordsEditor.setBorder(BorderFactory.createTitledBorder("Phase Center Coordinates"));
        skyCoordsModel.subscribe(new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (fieldID.equals(SkyCoordsModel.FID_SYS)) {
                    pointingPatternModel.originCoordinatesSystemUpdated();
                }
            }
        });
        this.showEditor(skyCoordsEditor, pointingPatternEditor);
    }
}

