/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.SchedBlockObservingGroupTable;
import alma.obsprep.ot.models.schedblock.SchedBlockObservingGroupModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SchedBlockObservingGroupEditor
extends Editor {
    public static final FieldID DOCUMENT_FID = new FieldID("SchedBlockObservingGroupEditor.document");
    private SchedBlockObservingGroupTable m_observingGroupTable = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JButton m_deleteButton = null;

    public SchedBlockObservingGroupEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public SchedBlockObservingGroupModel getModel() {
        return (SchedBlockObservingGroupModel)super.getModel();
    }

    private void createComponents() {
        SchedBlockObservingGroupModel schedBlockObservingGroupModel = this.getModel();
        this.m_observingGroupTable = new SchedBlockObservingGroupTable(schedBlockObservingGroupModel.getObservingGroupTableModel());
        this.m_observingGroupTable.setName("SchedBlockObservingGroupEditor.table");
        this.m_deleteButton = new JButton("Delete");
        this.m_deleteButton.setName("SchedBlockObservingGroupEditor.delBtn");
        this.m_deleteButton.setToolTipText("Delete target from observing group");
        this.m_deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchedBlockObservingGroupEditor.this.deleteTargetsFromObservingGroup();
            }
        });
        this.m_upButton = new JButton("\u2191");
        this.m_upButton.setName("SchedBlockObservingGroupEditor.upBtn");
        this.m_upButton.setToolTipText("Move target up one row");
        this.m_upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchedBlockObservingGroupEditor.this.moveTargetUpOneRow();
            }
        });
        this.m_downButton = new JButton("\u2193");
        this.m_downButton.setName("SchedBlockObservingGroupEditor.downBtn");
        this.m_downButton.setToolTipText("Move target down one row");
        this.m_downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchedBlockObservingGroupEditor.this.moveTargetDownOneRow();
            }
        });
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.m_observingGroupTable);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)scrollWhenFocusedPane, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.m_deleteButton);
        jPanel.add(this.m_upButton);
        jPanel.add(this.m_downButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)jPanel, gridBagConstraints);
    }

    @Override
    protected void build() {
        this.createComponents();
        this.layoutComponents();
    }

    public void deleteTargetsFromObservingGroup() {
        SchedBlock schedBlock = (SchedBlock)this.getModel().getDocument();
        int[] nArray = this.m_observingGroupTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[nArray.length - 1 - i];
        }
        for (int n : nArray2) {
            schedBlock.deleteObservingGroup(n);
        }
        this.getModel().publish();
    }

    public void moveTargetUpOneRow() {
        SchedBlock schedBlock = (SchedBlock)this.getModel().getDocument();
        int n = this.m_observingGroupTable.getRowCount();
        int n2 = this.m_observingGroupTable.getSelectedRow();
        if (n == 0) {
            return;
        }
        if (n2 <= 0 || n2 > n) {
            return;
        }
        schedBlock.moveOrderedTargetUpOneRow(n2);
        this.getModel().publish();
        try {
            this.m_observingGroupTable.setRowSelectionInterval(n2 - 1, n2 - 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.m_observingGroupTable.setRowSelectionInterval(n2, n2);
        }
    }

    public void moveTargetDownOneRow() {
        SchedBlock schedBlock = (SchedBlock)this.getModel().getDocument();
        int n = this.m_observingGroupTable.getRowCount();
        int n2 = this.m_observingGroupTable.getSelectedRow();
        if (n == 0) {
            return;
        }
        if (n2 < 0 || n2 >= n) {
            return;
        }
        schedBlock.moveOrderedTargetDownOneRow(n2);
        this.getModel().publish();
        try {
            this.m_observingGroupTable.setRowSelectionInterval(n2 + 1, n2 + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.m_observingGroupTable.setRowSelectionInterval(n2, n2);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == DOCUMENT_FID) {
            SchedBlock schedBlock = (SchedBlock)object;
            if (schedBlock == null) {
                return;
            }
            super.update(fieldID, object);
        } else {
            super.update(fieldID, object);
        }
    }
}

