/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.editors.misc.DecValueCellEditor;
import alma.obsprep.ot.editors.misc.RAValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueCellEditor;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.models.schedblock.SchedBlockObservingGroupTableModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class SchedBlockObservingGroupTable
extends Table {
    public static final int TABLE_WIDTH = 300;
    public static final int TABLE_HEIGHT = 100;

    public SchedBlockObservingGroupTable(TableModel tableModel) {
        super(tableModel);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("Observing groups table editor");
        Dimension dimension = new Dimension(300, 100);
        this.setPreferredScrollableViewportSize(dimension);
        this.setFillsViewportHeight(true);
        this.setupCellEditorAndRenderer();
    }

    private void setupCellEditorAndRenderer() {
        this.setDefaultEditor(Double.class, new ValueCellEditor.Double());
        this.setDefaultEditor(Integer.class, new ValueCellEditor.Integer());
        this.setDefaultEditor(Longitude.class, new RAValueCellEditor());
        this.setDefaultEditor(Latitude.class, new DecValueCellEditor());
        this.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        this.setDefaultRenderer(Object.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Integer.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Double.class, new MyTableEditorCellRenderer(this));
        this.setDefaultRenderer(Longitude.class, new MyTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object != null) {
                    try {
                        Longitude longitude = (Longitude)((Object)object);
                        string = longitude.toHHMMSS();
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        this.setDefaultRenderer(Latitude.class, new MyTableEditorCellRenderer(this){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object != null) {
                    try {
                        Latitude latitude = (Latitude)((Object)object);
                        string = latitude.toDDMMSS();
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        ColumnResizer.initColumnSizes(this, this.getMyModel().getLongValues());
    }

    public SchedBlockObservingGroupTableModel getMyModel() {
        return (SchedBlockObservingGroupTableModel)this.getModel();
    }

    public class MyTableEditorCellRenderer
    extends DefaultTableCellRenderer {
        private Color naColor = UIManager.getColor("TableHeader.background");
        private SchedBlockObservingGroupTableModel model;

        public MyTableEditorCellRenderer(SchedBlockObservingGroupTable schedBlockObservingGroupTable2) {
            this.model = (SchedBlockObservingGroupTableModel)schedBlockObservingGroupTable2.getModel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n >= this.model.getRowCount()) {
                return this;
            }
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            return this;
        }
    }
}

