/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.ot.editors.misc.FrequencyParser;
import alma.obsprep.ot.editors.schedblock.ComboBoxPair;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JComboBox;

public abstract class SpectralElementComboBoxPair
extends ComboBoxPair {
    private JComboBox nominalBandwidthCombo;
    private ActionListener nominalBandwidthListener;
    private JComboBox resolutionCombo;
    private ActionListener resolutionListener;

    public SpectralElementComboBoxPair(Editor editor, JComboBox jComboBox, JComboBox jComboBox2) {
        super(editor, jComboBox, jComboBox2);
        this.nominalBandwidthCombo = jComboBox;
        this.nominalBandwidthListener = this.listener1;
        this.resolutionCombo = jComboBox2;
        this.resolutionListener = this.listener2;
    }

    public SpectralElementComboBoxPair(JComboBox jComboBox, JComboBox jComboBox2) {
        this(null, jComboBox, jComboBox2);
    }

    public abstract ScienceSpectralWindow getLineSetup();

    @Override
    public void reset() {
        ScienceSpectralWindow scienceSpectralWindow = this.getLineSetup();
        if (scienceSpectralWindow == null) {
            return;
        }
        UserFrequency userFrequency = scienceSpectralWindow.getBandWidth();
        UserFrequency userFrequency2 = scienceSpectralWindow.getSpectralResolution();
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        int n = oTConfigModeDecoder.getNominalBandwidthLabelIndex((Frequency)((Object)userFrequency));
        this.nominalBandwidthCombo.setSelectedIndex(n);
        n = oTConfigModeDecoder.getResolutionLabelIndex((Frequency)((Object)userFrequency2));
        this.resolutionCombo.setSelectedIndex(n);
        super.reset();
    }

    @Override
    public ComboBoxPair.ItemCategory[] getCategories(JComboBox jComboBox, JComboBox jComboBox2) {
        boolean[] blArray;
        boolean[] blArray2;
        Set<CorrConfigMode> set;
        ComboBoxPair.ItemCategory[] itemCategoryArray;
        FrequencyParser frequencyParser = new FrequencyParser();
        ComboBoxPair.ItemCategory[] itemCategoryArray2 = new ComboBoxPair.ItemCategory[]{};
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode(CorrFilter.TFB);
        CorrPolarization corrPolarization = this.getLineSetup().getCorrPolarization();
        if (corrPolarization != null) {
            set2 = oTConfigModeDecoder.findMode(this.getLineSetup().getCorrPolarization(), set2);
        }
        String string = (String)jComboBox.getSelectedItem();
        if (jComboBox == this.nominalBandwidthCombo) {
            itemCategoryArray = frequencyParser.parse(TextUtils.stripHtmlTags(string));
            set = oTConfigModeDecoder.findMode((Frequency)itemCategoryArray, set2);
            blArray2 = oTConfigModeDecoder.resolutionLabelEffectivity(set2);
            blArray = oTConfigModeDecoder.resolutionLabelEffectivity(set);
        } else {
            itemCategoryArray = frequencyParser.parse(TextUtils.stripHtmlTags(string));
            set = oTConfigModeDecoder.findModeByResolution((Frequency)itemCategoryArray, set2);
            blArray2 = oTConfigModeDecoder.nominalBandwidthLabelEffectivity(set2);
            blArray = oTConfigModeDecoder.nominalBandwidthLabelEffectivity(set);
        }
        itemCategoryArray = new ComboBoxPair.ItemCategory[blArray2.length];
        for (int i = 0; i < blArray2.length; ++i) {
            itemCategoryArray[i] = !blArray2[i] ? ComboBoxPair.ItemCategory.NA : (blArray[i] ? ComboBoxPair.ItemCategory.OK : ComboBoxPair.ItemCategory.NG);
        }
        return itemCategoryArray;
    }

    @Override
    public String[] getPlainTextLabels(JComboBox jComboBox, JComboBox jComboBox2) {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        String[] stringArray = jComboBox == this.nominalBandwidthCombo ? oTConfigModeDecoder.getKnownResolutionLabels() : oTConfigModeDecoder.getKnownNominalBandwidthLabels();
        return stringArray;
    }
}

