/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.SpectralElementComboBoxPair;
import alma.obsprep.ot.editors.schedblock.SpectralElementComboBoxPairTestModel;
import alma.valuetypes.Frequency;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;

class SpectralElementComboBoxPairTestEditor
extends EditorWithGridBagLayout {
    public static final FieldID BANDWIDTH_FID = new FieldID("SpectralElementTestEditor.bandwith");
    public static final FieldID RESOLUTION_FID = new FieldID("SpectralElementTestEditor.resolution");
    private OTConfigModeDecoder decoder = OTConfigModeDecoder.getInstance();

    public SpectralElementComboBoxPairTestEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    public SpectralElementComboBoxPairTestModel getMyModel() {
        return (SpectralElementComboBoxPairTestModel)this.getModel();
    }

    @Override
    protected void addComponents(String string) {
        JComboBox jComboBox = this.makeComboBox(BANDWIDTH_FID, this.decoder.getKnownNominalBandwidthLabels(), "Nominal Bandwidth");
        JComboBox jComboBox2 = this.makeComboBox(RESOLUTION_FID, this.decoder.getKnownResolutionLabels(), "Resolution");
        SpectralElementComboBoxPair spectralElementComboBoxPair = new SpectralElementComboBoxPair(this, jComboBox, jComboBox2){

            @Override
            public ScienceSpectralWindow getLineSetup() {
                return SpectralElementComboBoxPairTestEditor.this.getMyModel().getSpectralWindow();
            }
        };
        JButton jButton = new JButton("Print");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScienceSpectralWindow scienceSpectralWindow = SpectralElementComboBoxPairTestEditor.this.getMyModel().getSpectralWindow();
                System.out.println(scienceSpectralWindow.getBandWidth() + " : " + scienceSpectralWindow.getSpectralResolution() + ", channels = " + scienceSpectralWindow.getNumberOfChannels());
            }
        });
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        componentCollection.remember(this.makeLabel("Bandwidth"));
        componentCollection.remember(jComboBox);
        componentCollection.remember(this.makeLabel("Resolution"));
        componentCollection.remember(jComboBox2);
        this.addComponentArray(componentCollection);
        this.addComponent(jButton);
    }

    @Override
    protected void build() {
        super.build("SpectralElementComboBoxPairTest");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(RESOLUTION_FID)) {
            Frequency frequency;
            try {
                frequency = (Frequency)((Object)object);
            }
            catch (ClassCastException classCastException) {
                return;
            }
            int n = this.decoder.getResolutionLabelIndex(frequency);
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            String string = (String)jComboBox.getItemAt(n);
            super.update(fieldID, string);
            return;
        }
        if (fieldID.equals(BANDWIDTH_FID)) {
            Frequency frequency;
            try {
                frequency = (Frequency)((Object)object);
            }
            catch (ClassCastException classCastException) {
                return;
            }
            int n = this.decoder.getNominalBandwidthLabelIndex(frequency);
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            String string = (String)jComboBox.getItemAt(n);
            super.update(fieldID, string);
            return;
        }
    }
}

