/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.ot.editors.misc.ValueUnitPairParser;
import alma.obsprep.ot.editors.schedblock.ComboBoxPair;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;

public abstract class SpectralWindowComboBoxPair
extends ComboBoxPair {
    static Map<ComboBoxPair, Editor> allInstances = new HashMap<ComboBoxPair, Editor>();
    private JComboBox nominalBandwidthCombo;
    private ActionListener nominalBandwidthListener;
    private JComboBox nominalChannelsCombo;
    private ActionListener nominalChannelsListener;
    private ValueUnitPairParser parser = new ValueUnitPairParser();

    public SpectralWindowComboBoxPair(Editor editor, JComboBox jComboBox, JComboBox jComboBox2) {
        super(editor, jComboBox, jComboBox2);
        allInstances.put(this, editor);
        this.nominalBandwidthCombo = jComboBox;
        this.nominalBandwidthListener = this.listener1;
        this.nominalChannelsCombo = jComboBox2;
        this.nominalChannelsListener = this.listener2;
    }

    public abstract SpectralWindowI getSpectralWindow();

    @Override
    public void reset() {
        SpectralWindowI spectralWindowI = this.getSpectralWindow();
        if (spectralWindowI == null) {
            return;
        }
        Frequency frequency = spectralWindowI.getNominalBandwidth();
        int n = spectralWindowI.getNominalNumberOfChannels();
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        int n2 = oTConfigModeDecoder.getNominalBandwidthLabelIndex(frequency);
        this.nominalBandwidthCombo.setSelectedIndex(n2);
        n2 = oTConfigModeDecoder.getNominalChannelLabelIndex(n);
        this.nominalChannelsCombo.setSelectedIndex(n2);
        super.reset();
    }

    @Override
    public ComboBoxPair.ItemCategory[] getCategories(JComboBox jComboBox, JComboBox jComboBox2) {
        boolean[] blArray;
        boolean[] blArray2;
        Set<CorrConfigMode> set;
        ComboBoxPair.ItemCategory[] itemCategoryArray;
        ComboBoxPair.ItemCategory[] itemCategoryArray2 = new ComboBoxPair.ItemCategory[]{};
        Set<CorrConfigMode> set2 = this.getSpectralWindow().getApplicableModeSet();
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        String string = (String)jComboBox.getSelectedItem();
        if (jComboBox == this.nominalBandwidthCombo) {
            itemCategoryArray = (ComboBoxPair.ItemCategory[])this.parser.parse(TextUtils.stripHtmlTags(string), Frequency.class);
            set = oTConfigModeDecoder.findMode((Frequency)itemCategoryArray, set2);
            blArray2 = oTConfigModeDecoder.nominalChannelLabelEffectivity(set2);
            blArray = oTConfigModeDecoder.nominalChannelLabelEffectivity(set);
        } else {
            int n = Integer.parseInt(TextUtils.stripHtmlTags(string));
            set = oTConfigModeDecoder.findMode(n, set2);
            blArray2 = oTConfigModeDecoder.nominalBandwidthLabelEffectivity(set2);
            blArray = oTConfigModeDecoder.nominalBandwidthLabelEffectivity(set);
        }
        itemCategoryArray = new ComboBoxPair.ItemCategory[blArray2.length];
        for (int i = 0; i < blArray2.length; ++i) {
            itemCategoryArray[i] = !blArray2[i] ? ComboBoxPair.ItemCategory.NA : (blArray[i] ? ComboBoxPair.ItemCategory.OK : ComboBoxPair.ItemCategory.NG);
        }
        return itemCategoryArray;
    }

    @Override
    public String[] getPlainTextLabels(JComboBox jComboBox, JComboBox jComboBox2) {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        String[] stringArray = jComboBox == this.nominalBandwidthCombo ? oTConfigModeDecoder.getKnownNominalChannelLabels() : oTConfigModeDecoder.getKnownNominalBandwidthLabels();
        return stringArray;
    }

    @Override
    protected void suspendEvents(JComboBox jComboBox) {
        super.suspendEvents(jComboBox);
    }

    @Override
    protected void resumeEvents(JComboBox jComboBox) {
        super.resumeEvents(jComboBox);
    }
}

