/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.ACASpectralWindow;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.SpectralWindowComboBoxPair;
import alma.obsprep.ot.editors.schedblock.SpectralWindowComboBoxPairTestModel;
import alma.valuetypes.Frequency;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;

class SpectralWindowComboBoxPairTestEditor
extends EditorWithGridBagLayout {
    public static final FieldID CORRTYPE_FID = new FieldID("SpectralWindowTestEditor.corrtype");
    public static final FieldID BANDWIDTH_FID = new FieldID("SpectralWindowTestEditor.bandwidth");
    public static final FieldID CHANNELS_FID = new FieldID("SpectralWindowTestEditor.channels");
    private OTConfigModeDecoder decoder = OTConfigModeDecoder.getInstance();

    public SpectralWindowComboBoxPairTestEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    public SpectralWindowComboBoxPairTestModel getMyModel() {
        return (SpectralWindowComboBoxPairTestModel)this.getModel();
    }

    @Override
    protected void addComponents(String string) {
        JComboBox jComboBox = this.addComboBox((JComponent)this, this.layout, this.constraints, CORRTYPE_FID, "Correlator", "", new String[]{CorrelatorType.ACA.name(), CorrelatorType.BL.name()});
        JComboBox jComboBox2 = this.makeComboBox(BANDWIDTH_FID, this.decoder.getKnownNominalBandwidthLabels(), "Nominal Bandwidth");
        JComboBox jComboBox3 = this.makeComboBox(CHANNELS_FID, this.decoder.getKnownNominalChannelLabels(), "Nominal Number of Channels");
        SpectralWindowComboBoxPair spectralWindowComboBoxPair = new SpectralWindowComboBoxPair(this, jComboBox2, jComboBox3){

            @Override
            public AbstractSpectralWindow getSpectralWindow() {
                return SpectralWindowComboBoxPairTestEditor.this.getMyModel().getSpectralWindow();
            }
        };
        JButton jButton = new JButton("Print");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSpectralWindow abstractSpectralWindow = SpectralWindowComboBoxPairTestEditor.this.getMyModel().getSpectralWindow();
                System.out.println((Object)((Object)abstractSpectralWindow.getNominalBandwidth()) + " : " + abstractSpectralWindow.getNominalNumberOfChannels());
            }
        });
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        componentCollection.remember(this.makeLabel("Bandwidth"));
        componentCollection.remember(jComboBox2);
        componentCollection.remember(this.makeLabel("Channels"));
        componentCollection.remember(jComboBox3);
        this.addComponentArray(componentCollection);
        this.addComponent(jButton);
    }

    @Override
    protected void build() {
        super.build("SpectralWindowComboBoxPairTest");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(CORRTYPE_FID)) {
            if (object.equals(CorrelatorType.ACA.name())) {
                this.getMyModel().setDocument(ACASpectralWindow.createACASpectralWindow());
            } else if (object.equals(CorrelatorType.BL.name())) {
                this.getMyModel().setDocument(BLSpectralWindow.createBLSpectralWindow());
            } else {
                super.update(fieldID, ((CorrelatorType)((Object)object)).name());
            }
            return;
        }
        if (fieldID.equals(CHANNELS_FID)) {
            int n = (Integer)object;
            int n2 = this.decoder.getNominalChannelLabelIndex(n);
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            String string = (String)jComboBox.getItemAt(n2);
            super.update(fieldID, string);
            return;
        }
        if (fieldID.equals(BANDWIDTH_FID)) {
            Frequency frequency;
            try {
                frequency = (Frequency)((Object)object);
            }
            catch (ClassCastException classCastException) {
                return;
            }
            int n = this.decoder.getNominalBandwidthLabelIndex(frequency);
            JComboBox jComboBox = (JComboBox)this.retrieve(fieldID);
            String string = (String)jComboBox.getItemAt(n);
            super.update(fieldID, string);
            return;
        }
    }
}

