/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.ValueUnitPairParser;
import alma.obsprep.ot.editors.schedblock.SpectralWindowComboBoxPairTestEditor;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;

class SpectralWindowComboBoxPairTestModel
extends Model {
    private ValueUnitPairParser vupParser = new ValueUnitPairParser();

    public SpectralWindowComboBoxPairTestModel(Object object) {
        super(object);
    }

    public AbstractSpectralWindow getSpectralWindow() {
        return (AbstractSpectralWindow)this.getDocument();
    }

    @Override
    public void publish() {
        if (this.document == null) {
            return;
        }
        this.publish(SpectralWindowComboBoxPairTestEditor.CORRTYPE_FID, (Object)this.getSpectralWindow().getCorrelatorType());
        this.publish(SpectralWindowComboBoxPairTestEditor.BANDWIDTH_FID, (Object)this.getSpectralWindow().getNominalBandwidth());
        this.publish(SpectralWindowComboBoxPairTestEditor.CHANNELS_FID, this.getSpectralWindow().getNominalNumberOfChannels());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(SpectralWindowComboBoxPairTestEditor.CORRTYPE_FID)) {
            if (object.equals(CorrelatorType.ACA.name())) {
                return CorrelatorType.ACA;
            }
            return CorrelatorType.BL;
        }
        if (fieldID.equals(SpectralWindowComboBoxPairTestEditor.BANDWIDTH_FID)) {
            Frequency frequency;
            String string = TextUtils.stripHtmlTags((String)object);
            try {
                frequency = (Frequency)this.vupParser.parse(string, Frequency.class);
                AbstractSpectralWindow abstractSpectralWindow = this.getSpectralWindow();
                int n = abstractSpectralWindow.getNominalNumberOfChannels();
                abstractSpectralWindow.setBandParameters(frequency, n, SpectralWindowBand.ChannelType.NOMINAL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                frequency = Frequency.createFrequency();
            }
            return frequency;
        }
        if (fieldID.equals(SpectralWindowComboBoxPairTestEditor.CHANNELS_FID)) {
            Integer n;
            try {
                n = Integer.parseInt(TextUtils.stripHtmlTags((String)object));
                AbstractSpectralWindow abstractSpectralWindow = this.getSpectralWindow();
                Frequency frequency = abstractSpectralWindow.getNominalBandwidth();
                abstractSpectralWindow.setBandParameters(frequency, n, SpectralWindowBand.ChannelType.NOMINAL);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            return n;
        }
        return object;
    }
}

