/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock.observingparameters;

import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.ExpertParametersEditor;
import alma.obsprep.ot.editors.schedblock.UsedByTargetPanel;
import alma.obsprep.ot.editors.schedblock.observingparameters.ObservingParameterTabEditor;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.TargetModel;
import alma.obsprep.ot.models.schedblock.UsedByTargetModel;
import alma.obsprep.ot.models.schedblock.observingparameters.ObservingParameterModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ObservingParameterEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_EXPERTKEYWORD = new FieldID("ObservingParameter.expertKeyword");
    public static final FieldID FID_EXPERTVALUE = new FieldID("ObservingParameter.expertValue");
    protected JPanel panel;
    protected GridBagLayout gl;
    protected GridBagConstraints gc;
    private JPanel advpanel;
    protected JPanel advancedParameters = null;
    private GridBagLayout agl;
    private GridBagConstraints agc;
    protected boolean collapse;

    public ObservingParameterEditor(Model model, boolean bl) {
        this.collapse = bl;
        this.setModel(model);
        this.build();
        model.publish();
    }

    public ObservingParameterEditor(Model model) {
        this(model, false);
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.collapse) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    protected void build() {
        super.build("Observing Parameters");
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setAdvancedParametersVisible(boolean bl) {
        if (this.advancedParameters != null) {
            this.advancedParameters.setVisible(bl);
        }
    }

    @Override
    protected void addComponents(String string) {
        this.addUsedByTargetInfoComponent();
        this.addAdvancedPanel();
    }

    protected void addUsedByTargetInfoComponent() {
        UsedByTargetModel usedByTargetModel = ((ObservingParameterModel)this.getModel()).getUsedByTargetModel();
        UsedByTargetPanel usedByTargetPanel = new UsedByTargetPanel(usedByTargetModel);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((ObservingParameterModel)ObservingParameterEditor.this.getModel()).isTargetContext();
                if (bl) {
                    ObservingParameters observingParameters = ((ObservingParameterModel)ObservingParameterEditor.this.getModel()).getObservingParameters();
                    AddInteractor.ObjectType objectType = observingParameters.whatType();
                    ObservingToolGui observingToolGui = ObservingToolController.getMyInstance().getGui();
                    if (observingToolGui != null) {
                        TargetModel targetModel = (TargetModel)observingToolGui.getEditors().modelFor(Target.class);
                        ObservingParameters observingParameters2 = targetModel.duplicateObservingParameters(objectType);
                        ObservingParameterTabEditor observingParameterTabEditor = (ObservingParameterTabEditor)observingToolGui.getEditors().editorFor(EditorManager.EditorType.FORM, ObservingParameters.class);
                        observingParameterTabEditor.setTabSelect(observingParameters2);
                        observingToolGui.refreshCrossHighlight();
                    }
                }
            }
        };
        usedByTargetPanel.addOnlyThisButtonListener(actionListener);
        this.addComponent(usedByTargetPanel);
        this.registerSubView(usedByTargetPanel);
    }

    protected void addAdvancedPanel() {
        this.advpanel = this.createNewGroup();
        this.agl = this.createNewLayout(this.advpanel);
        this.agc = this.createNewConstraints();
        ExpertParametersEditor expertParametersEditor = new ExpertParametersEditor(((ObservingParameterModel)this.getModel()).getExpertParametersModel());
        this.advpanel.add(expertParametersEditor);
        this.advancedParameters = this.addGroup(this.advpanel, "Advanced Parameters", true);
    }
}

