/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock.observingparameters;

import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.GuiApi;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.schedblock.observingparameters.AmplitudeCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.AtmosphericCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.BandpassCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.CheckSourceCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.DelayCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.FocusCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.HolographyParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.OpticalPointingParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.PhaseCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.PointingCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.PolarizationCalParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.RadiometricPointingParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.ScienceParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.SidebandRatioCalParameterEditor;
import alma.obsprep.ot.models.schedblock.observingparameters.ObservingParameterTabModel;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ObservingParameterTabEditor
extends EditorWithGridBagLayout {
    public static final int TAB_SCIENCE_PARAMETERS = 0;
    public static final int TAB_PHASECAL_PARAMETERS = 1;
    public static final int TAB_POINTINGCAL_PARAMETERS = 2;
    public static final int TAB_AMPLITUDECAL_PARAMETERS = 3;
    public static final int TAB_POLARIZATIONCAL_PARAMETERS = 4;
    public static final int TAB_FOCUSCAL_PARAMETERS = 5;
    public static final int TAB_ATMOSPHERICCAL_PARAMETERS = 6;
    public static final int TAB_DELAYCAL_PARAMETERS = 7;
    public static final int TAB_SIDEBANDRATIOCAL_PARAMTERS = 8;
    public static final int TAB_BANDPASSCAL_PARAMETERS = 9;
    public static final int TAB_OPTICALPOINTING_PARAMETERS = 10;
    public static final int TAB_RADIOMETRICPOINTING_PARAMETERS = 11;
    public static final int TAB_HOLOGRAPHY_PARAMETERS = 12;
    public static final int TAB_CHECKSOURCECAL_PARAMETERS = 13;
    private static final int LAST_TAB = 13;
    public String[] tabLabels = new String[]{"Science", "PhaseCal", "PointingCal", "AmplitudeCal", "PolarizationCal", "FocusCal", "AtmosphericCal", "DelayCal", "SidebandRatioCal", "BandpassCal", "OpticalPointing", "RadiometricPointing", "Holography", "CheckSourceCal"};
    public static final FieldID DOCUMENT_FID = new FieldID("ObservingParameterTabEditor.document");
    protected ScienceParameterEditor scienceEditor;
    protected PhaseCalParameterEditor phaseCalEditor;
    protected PointingCalParameterEditor pointingCalEditor;
    protected AmplitudeCalParameterEditor amplitudeCalEditor;
    protected PolarizationCalParameterEditor polarizationCalEditor;
    protected FocusCalParameterEditor focusCalEditor;
    protected AtmosphericCalParameterEditor atmosphericCalEditor;
    protected DelayCalParameterEditor delayCalEditor;
    protected CheckSourceCalParameterEditor checkSourceCalEditor;
    protected SidebandRatioCalParameterEditor sidebandRatioCalEditor;
    protected BandpassCalParameterEditor bandpassCalEditor;
    protected OpticalPointingParameterEditor opticalPointingEditor;
    protected RadiometricPointingParameterEditor radiometricPointingEditor;
    protected HolographyParameterEditor holographyEditor;
    private Vector<Editor> allEditors = new Vector();
    private JTabbedPane tabPane;

    public ObservingParameterTabEditor(Model model) {
        this.setModel(model);
        this.createAllEditors();
        this.build();
        model.publish();
    }

    public JTabbedPane getTabPane() {
        return this.tabPane;
    }

    @Override
    protected void build() {
        super.build("Observing Parameters");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        this.tabPane = new JTabbedPane();
        this.tabPane.setTabLayoutPolicy(0);
        this.tabPane.add(this.tabLabels[0], this.scienceEditor);
        this.tabPane.add(this.tabLabels[1], this.phaseCalEditor);
        this.tabPane.add(this.tabLabels[2], this.pointingCalEditor);
        this.tabPane.add(this.tabLabels[3], this.amplitudeCalEditor);
        this.tabPane.add(this.tabLabels[4], this.polarizationCalEditor);
        this.tabPane.add(this.tabLabels[5], this.focusCalEditor);
        this.tabPane.add(this.tabLabels[6], this.atmosphericCalEditor);
        this.tabPane.add(this.tabLabels[7], this.delayCalEditor);
        this.tabPane.add(this.tabLabels[8], this.sidebandRatioCalEditor);
        this.tabPane.add(this.tabLabels[9], this.bandpassCalEditor);
        this.tabPane.add(this.tabLabels[10], this.opticalPointingEditor);
        this.tabPane.add(this.tabLabels[11], this.radiometricPointingEditor);
        this.tabPane.add(this.tabLabels[12], this.holographyEditor);
        this.tabPane.add(this.tabLabels[13], this.checkSourceCalEditor);
        jPanel.add(this.tabPane);
        this.addGroup(jPanel, string);
    }

    private void createAllEditors() {
        ObservingParameterTabModel observingParameterTabModel = (ObservingParameterTabModel)this.getModel();
        this.scienceEditor = new ScienceParameterEditor(observingParameterTabModel.getScienceModel());
        this.allEditors.add(this.scienceEditor);
        this.phaseCalEditor = new PhaseCalParameterEditor(observingParameterTabModel.getPhaseCalModel());
        this.allEditors.add(this.phaseCalEditor);
        this.pointingCalEditor = new PointingCalParameterEditor(observingParameterTabModel.getPointingCalModel());
        this.allEditors.add(this.pointingCalEditor);
        this.amplitudeCalEditor = new AmplitudeCalParameterEditor(observingParameterTabModel.getAmplitudeCalModel());
        this.allEditors.add(this.amplitudeCalEditor);
        this.polarizationCalEditor = new PolarizationCalParameterEditor(observingParameterTabModel.getPolarizationCalModel());
        this.allEditors.add(this.polarizationCalEditor);
        this.focusCalEditor = new FocusCalParameterEditor(observingParameterTabModel.getFocusCalModel());
        this.allEditors.add(this.focusCalEditor);
        this.atmosphericCalEditor = new AtmosphericCalParameterEditor(observingParameterTabModel.getAtmosphericCalModel());
        this.allEditors.add(this.atmosphericCalEditor);
        this.delayCalEditor = new DelayCalParameterEditor(observingParameterTabModel.getDelayCalModel());
        this.allEditors.add(this.delayCalEditor);
        this.checkSourceCalEditor = new CheckSourceCalParameterEditor(observingParameterTabModel.getCheckSourceCalModel());
        this.allEditors.add(this.checkSourceCalEditor);
        this.sidebandRatioCalEditor = new SidebandRatioCalParameterEditor(observingParameterTabModel.getSidebandRatioCalModel());
        this.allEditors.add(this.sidebandRatioCalEditor);
        this.bandpassCalEditor = new BandpassCalParameterEditor(observingParameterTabModel.getBandpassCalModel());
        this.allEditors.add(this.bandpassCalEditor);
        this.opticalPointingEditor = new OpticalPointingParameterEditor(observingParameterTabModel.getOpticalPointingModel());
        this.allEditors.add(this.opticalPointingEditor);
        this.radiometricPointingEditor = new RadiometricPointingParameterEditor(observingParameterTabModel.getRadiometricPointingModel());
        this.allEditors.add(this.radiometricPointingEditor);
        this.holographyEditor = new HolographyParameterEditor(observingParameterTabModel.getHolographyModel());
        this.allEditors.add(this.holographyEditor);
    }

    public void enableTabForTarget(Target target) {
        boolean bl = target.hasScienceParameters();
        this.tabPane.setEnabledAt(0, bl);
        bl = target.hasPhaseCalParameters();
        this.tabPane.setEnabledAt(1, bl);
        bl = target.hasPointingCalParameters();
        this.tabPane.setEnabledAt(2, bl);
        bl = target.hasAmplitudeCalParameters();
        this.tabPane.setEnabledAt(3, bl);
        bl = target.hasPolarizationCalParameters();
        this.tabPane.setEnabledAt(4, bl);
        bl = target.hasFocusCalParameters();
        this.tabPane.setEnabledAt(5, bl);
        bl = target.hasAtmosphericCalParameters();
        this.tabPane.setEnabledAt(6, bl);
        bl = target.hasDelayCalParameters();
        this.tabPane.setEnabledAt(7, bl);
        bl = target.hasCheckSourceCalParameters();
        this.tabPane.setEnabledAt(13, bl);
        bl = target.hasSidebandRatioCalParameters();
        this.tabPane.setEnabledAt(8, bl);
        bl = target.hasBandpassCalParameters();
        this.tabPane.setEnabledAt(9, bl);
        bl = target.isOpticalPointingTarget();
        this.tabPane.setEnabledAt(10, bl);
        bl = target.hasRadiometricPointingParameters();
        this.tabPane.setEnabledAt(11, bl);
        bl = target.hasHolographyParameters();
        this.tabPane.setEnabledAt(12, bl);
        int n = this.tabPane.getSelectedIndex();
        if (!this.tabPane.isEnabledAt(n)) {
            for (int i = 0; i < 14; ++i) {
                if (!this.tabPane.isEnabledAt(i)) continue;
                this.tabPane.setSelectedIndex(i);
                return;
            }
        }
    }

    public void enableTab(ObservingParameters observingParameters) {
        for (int i = 0; i <= 13; ++i) {
            this.tabPane.setEnabledAt(i, false);
        }
        if (observingParameters instanceof ScienceParameters) {
            this.tabPane.setEnabledAt(0, true);
        } else if (observingParameters instanceof PhaseCalParameters) {
            this.tabPane.setEnabledAt(1, true);
        } else if (observingParameters instanceof PointingCalParameters) {
            this.tabPane.setEnabledAt(2, true);
        } else if (observingParameters instanceof AmplitudeCalParameters) {
            this.tabPane.setEnabledAt(3, true);
        } else if (observingParameters instanceof PolarizationCalParameters) {
            this.tabPane.setEnabledAt(4, true);
        } else if (observingParameters instanceof FocusCalParameters) {
            this.tabPane.setEnabledAt(5, true);
        } else if (observingParameters instanceof AtmosphericCalParameters) {
            this.tabPane.setEnabledAt(6, true);
        } else if (observingParameters instanceof DelayCalParameters) {
            this.tabPane.setEnabledAt(7, true);
        } else if (observingParameters instanceof CheckSourceCalParameters) {
            this.tabPane.setEnabledAt(13, true);
        } else if (observingParameters instanceof SidebandRatioCalParameters) {
            this.tabPane.setEnabledAt(8, true);
        } else if (observingParameters instanceof BandpassCalParameters) {
            this.tabPane.setEnabledAt(9, true);
        } else if (observingParameters instanceof OpticalPointingParameters) {
            this.tabPane.setEnabledAt(10, true);
        } else if (observingParameters instanceof RadiometricPointingParameters) {
            this.tabPane.setEnabledAt(11, true);
        } else if (observingParameters instanceof HolographyParameters) {
            this.tabPane.setEnabledAt(12, true);
        }
        this.setTabSelect(observingParameters);
    }

    public void setTabSelect(ObservingParameters observingParameters) {
        if (observingParameters instanceof ScienceParameters) {
            this.tabPane.setSelectedIndex(0);
        } else if (observingParameters instanceof PhaseCalParameters) {
            this.tabPane.setSelectedIndex(1);
        } else if (observingParameters instanceof PointingCalParameters) {
            this.tabPane.setSelectedIndex(2);
        } else if (observingParameters instanceof AmplitudeCalParameters) {
            this.tabPane.setSelectedIndex(3);
        } else if (observingParameters instanceof PolarizationCalParameters) {
            this.tabPane.setSelectedIndex(4);
        } else if (observingParameters instanceof FocusCalParameters) {
            this.tabPane.setSelectedIndex(5);
        } else if (observingParameters instanceof AtmosphericCalParameters) {
            this.tabPane.setSelectedIndex(6);
        } else if (observingParameters instanceof DelayCalParameters) {
            this.tabPane.setSelectedIndex(7);
        } else if (observingParameters instanceof CheckSourceCalParameters) {
            this.tabPane.setSelectedIndex(13);
        } else if (observingParameters instanceof SidebandRatioCalParameters) {
            this.tabPane.setSelectedIndex(8);
        } else if (observingParameters instanceof BandpassCalParameters) {
            this.tabPane.setSelectedIndex(9);
        } else if (observingParameters instanceof OpticalPointingParameters) {
            this.tabPane.setSelectedIndex(10);
        } else if (observingParameters instanceof RadiometricPointingParameters) {
            this.tabPane.setSelectedIndex(11);
        } else if (observingParameters instanceof HolographyParameters) {
            this.tabPane.setSelectedIndex(12);
        }
    }

    public Iterator<Editor> getAllEditors() {
        return this.allEditors.iterator();
    }

    public AmplitudeCalParameterEditor getAmplitudeCalEditor() {
        return this.amplitudeCalEditor;
    }

    public BandpassCalParameterEditor getBandpassCalEditor() {
        return this.bandpassCalEditor;
    }

    public FocusCalParameterEditor getFocusCalEditor() {
        return this.focusCalEditor;
    }

    public AtmosphericCalParameterEditor getAtmosphericCalEditor() {
        return this.atmosphericCalEditor;
    }

    public DelayCalParameterEditor getDelayCalEditor() {
        return this.delayCalEditor;
    }

    public CheckSourceCalParameterEditor getCheckSourceCalEditor() {
        return this.checkSourceCalEditor;
    }

    public SidebandRatioCalParameterEditor getSidebandRatioCalParameterEditor() {
        return this.sidebandRatioCalEditor;
    }

    public HolographyParameterEditor getHolographyEditor() {
        return this.holographyEditor;
    }

    public OpticalPointingParameterEditor getOpticalPointingEditor() {
        return this.opticalPointingEditor;
    }

    public RadiometricPointingParameterEditor getRadiometricPointingEditor() {
        return this.radiometricPointingEditor;
    }

    public PhaseCalParameterEditor getPhaseCalEditor() {
        return this.phaseCalEditor;
    }

    public PointingCalParameterEditor getPointingCalEditor() {
        return this.pointingCalEditor;
    }

    public PolarizationCalParameterEditor getPolarizationCalEditor() {
        return this.polarizationCalEditor;
    }

    public ScienceParameterEditor getScienceEditor() {
        return this.scienceEditor;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == DOCUMENT_FID) {
            if (object instanceof Target) {
                Target target = (Target)object;
                this.enableTabForTarget(target);
            } else if (object instanceof ObservingParameters) {
                ObservingParameters observingParameters = (ObservingParameters)object;
                this.enableTab(observingParameters);
            }
        } else {
            super.update(fieldID, object);
        }
    }

    @Override
    public void setGuiApi(GuiApi guiApi) {
        Iterator<Editor> iterator = this.getAllEditors();
        while (iterator.hasNext()) {
            iterator.next().setGuiApi(guiApi);
        }
    }
}

