/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.ExpectedPropertiesData;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.editors.schedblock.SolarSystemTargetAwareEditor;
import alma.obsprep.ot.editors.valuetypes.UserUnitValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.sciencegoals.AbstractTargetModel;
import alma.obsprep.services.sfi.SingleFieldScienceGoalEditor;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AbstractTargetEditor
extends SolarSystemTargetAwareEditor {
    private static final long serialVersionUID = -7411788626895411018L;
    public static final FieldID FID_SOURCENAME = new FieldID("TargetEditor.sourceName");
    public static final FieldID FID_NONSIDEREALMOTION = new FieldID("TargetEditor.nonSiderealMotion");
    public static final FieldID FID_SOLARSYSTEMOBJECT = new FieldID("TargetEditor.solarSystemObject");
    public static final FieldID FID_SOURCEEPHEMERIS = new FieldID("TargetEditor.sourceEphemeris");
    public static final FieldID FID_PMRA_VALUE = new FieldID("TargetEditor.pmra.value");
    public static final FieldID FID_PMRA_UNIT = new FieldID("TargetEditor.pmra.unit");
    public static final FieldID FID_PMDEC_VALUE = new FieldID("TargetEditor.pmdec.value");
    public static final FieldID FID_PMDEC_UNIT = new FieldID("TargetEditor.pmdec.unit");
    public static final FieldID FID_PARALLAX_VALUE = new FieldID("TargetEditor.parallax.value");
    public static final FieldID FID_PARALLAX_UNIT = new FieldID("TargetEditor.parallax.unit");
    public static final FieldID FID_SOURCEVELOCITY_VALUE = new FieldID("TargetEditor.sourceVelocity.value");
    public static final FieldID FID_SOURCEVELOCITY_UNIT = new FieldID("TargetEditor.sourceVelocity.unit");
    public static final FieldID FID_SOURCEVELOCITY_SYSTEM = new FieldID("TargetEditor.sourceVelocitySystem");
    public static final FieldID FID_SOURCEVELOCITY_DOPPLER = new FieldID("TargetEditor.sourceVelocityDoppler");
    public static final FieldID FID_SOURCEVELOCITY_REDSHIFT = new FieldID("TargetEditor.sourceVelocityRedshift");
    public static final FieldID FID_RESOLVENAME = new FieldID("TargetEditor.resolveName");
    public static final FieldID FID_RESOLVECANCEL = new FieldID("TargetEditor.resolveCancel");
    public static final FieldID FID_PEAKFLUXDENSITY_VALUE = new FieldID("TargetEditor.peakFluxDensity.value");
    public static final FieldID FID_PEAKFLUXDENSITY_UNIT = new FieldID("TargetEditor.peakFluxDensity.unit");
    public static final FieldID FID_PEAKLINEFLUXDENSITY_VALUE = new FieldID("TargetEditor.peakLineFluxDensity.value");
    public static final FieldID FID_PEAKLINEFLUXDENSITY_UNIT = new FieldID("TargetEditor.peakLineFluxDensity.unit");
    public static final FieldID FID_CONTINUUM_LINEAR_POLARIZATION = new FieldID("TargetEditor.continuumPolarizationPercentage");
    public static final FieldID FID_SPECTRALLINE_CIRCULAR_POLARIZATION = new FieldID("TargetEditor.spectralLineCircularLinePolarizationPercentage");
    public static final FieldID FID_CONTINUUM_CIRCULAR_POLARIZATION = new FieldID("TargetEditor.continuumCircularLinePolarizationPercentage");
    public static final FieldID FID_LINEWIDTH_VALUE = new FieldID("TargetEditor.linewidth.value");
    public static final FieldID FID_LINEWIDTH_UNIT = new FieldID("TargetEditor.linewidth.unit");
    public static final FieldID FID_LINE_POLARIZATION_PERCENTAGE = new FieldID("TargetEditor.desiredLinePolarizationPercentage");
    private static final FieldID FID_STANDARD_EXPECTED_PROPERTIES_PANEL = new FieldID("TargetEditor.stdPropertiesPanel");
    private static final FieldID FID_SOLAR_EXPECTED_PROPERTIES_PANEL = new FieldID("TargetEditor.solarPropertiesPanel");
    public static final FieldID FID_SOLAR_ACTIVITY = new FieldID("TargetEditor.solarActivity");
    private String groupType = "Source";
    private boolean collapse;

    public AbstractTargetEditor(Model model, boolean bl) {
        this.setModel(model);
        this.collapse = bl;
    }

    public AbstractTargetEditor(Model model) {
        this(model, true);
    }

    @Override
    protected void build() {
        super.build(this.groupType);
    }

    @Override
    protected boolean wantGlobalButtons() {
        return false;
    }

    protected abstract void addExtraComponents(JPanel var1, GridBagLayout var2, GridBagConstraints var3);

    protected JPanel createTargetPanel() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        Box box = Box.createHorizontalBox();
        JTextField jTextField = this.makeTextField(FID_SOURCENAME, "Allowed characters: a..zA..Z0..9-+_.");
        jTextField.setColumns(50);
        box.add(jTextField);
        box.add(this.makeButton(FID_RESOLVENAME, "Resolve", "Resolve this source from a catalogue"));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Source Name", (JComponent)box);
        box = Box.createHorizontalBox();
        box.add(this.makeCheckBox(FID_NONSIDEREALMOTION, "This should be checked if the source exhibits non-sidereal motion (planet, asteroid, comet, etc.)"));
        box.add(Box.createHorizontalGlue());
        box.add(this.makeLabel("Name of object "));
        box.add(this.makeComboBox(FID_SOLARSYSTEMOBJECT, FieldSource.getKnownSolarSystemObjectList(), "<html>If the source is a commonly-used solar system object then select its name from the list.<br>If the source is not listed then select he Ephemeris option and provide an ephemeris.</html>"));
        box.add(Box.createHorizontalGlue());
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Choose a Solar System Object?", (JComponent)box);
        this.addOTFileArea(jPanel, gridBagLayout, gridBagConstraints, FID_SOURCEEPHEMERIS, 300, 150, "", "Source ephemeris in HORIZONS format, see manual for details");
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addSolarSystemTargetAwareEditorComponents(jPanel, gridBagLayout, gridBagConstraints);
        this.addExtraComponents(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createStandardExpectedPropertiesPanel() {
        AbstractTargetModel abstractTargetModel = (AbstractTargetModel)this.getModel();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        ValueUnitPairEditor valueUnitPairEditor = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, abstractTargetModel.getExpectedPeakFluxDensity(), "Peak Continuum Flux Density per Synthesized Beam ", "<html><p>Expected peak flux density of source continuum for the <b>weakest</b> source component that you wish to detect</p></html>");
        valueUnitPairEditor.getInput().setName("AbstractTargetEditor.PeakContinuumFluxDensityPerBeamText");
        valueUnitPairEditor.getUnits().setName("AbstractTargetEditor.PeakContinuumFluxDensityPerBeamUnitCombo");
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor));
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        JTextField jTextField = this.makeTextFieldWithDoubleVerifier(FID_CONTINUUM_LINEAR_POLARIZATION, "Expected linear polarization of the source in per cent", 0.0, 100.0);
        componentCollection.remember(this.makeLabel("Continuum Linear Polarization"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jTextField.setColumns(8);
        jPanel2.add(jTextField);
        jPanel2.add(new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, 0)));
        jPanel2.add(this.makeLabel("per cent"));
        jPanel2.add(new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, 0)));
        jPanel2.add(Box.createHorizontalGlue());
        componentCollection.remember(jPanel2);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        JTextField jTextField2 = this.makeTextFieldWithDoubleVerifier(FID_CONTINUUM_CIRCULAR_POLARIZATION, "Expected continuum circular polarization of the source in per cent", 0.0, 100.0);
        componentCollection.remember(this.makeLabel("Continuum Circular Polarization"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        jTextField2.setColumns(8);
        jPanel3.add(jTextField2);
        jPanel3.add(new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, 0)));
        jPanel3.add(this.makeLabel("per cent"));
        jPanel3.add(new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, 0)));
        jPanel3.add(Box.createHorizontalGlue());
        componentCollection.remember(jPanel3);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        ValueUnitPairEditor valueUnitPairEditor2 = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, abstractTargetModel.getExpectedPeakLineFluxDensity(), "Peak Line Flux Density per Synthesized Beam", "<html><p>Expected peak flux density of line emission, relative to the continuum for the <b>weakest</b> source component that you wish to detect</p></html>");
        valueUnitPairEditor2.getInput().setName("AbstractTargetEditor.PeakLineFluxDensityPerBeamText");
        valueUnitPairEditor2.getUnits().setName("AbstractTargetEditor.PeakLineFluxDensityPerBeamUnitCombo");
        valueUnitPairEditor2.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor2));
        componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        Object[] objectArray = UnitMap.getFrequencyUnits().getUnitsSorted();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        UserUnitValueUnitPairEditor userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(abstractTargetModel.getExpectedLineWidth());
        userUnitValueUnitPairEditor.getInput().setName("AbstractTargetEditor.LineWidthText");
        userUnitValueUnitPairEditor.getUnits().setName("AbstractTargetEditor.LineWidthUnitCombo");
        userUnitValueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(userUnitValueUnitPairEditor));
        this.register(userUnitValueUnitPairEditor, FID_LINEWIDTH_VALUE);
        this.registerSubView(userUnitValueUnitPairEditor);
        userUnitValueUnitPairEditor.setToolTipText("Expected width of the lines to be observed (FWHM)");
        componentCollection.remember(this.makeLabel("Line Width"));
        componentCollection.remember(userUnitValueUnitPairEditor);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        componentCollection.remember(this.makeLabel("Line Linear Polarization"));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JTextField jTextField3 = this.makeTextFieldWithDoubleVerifier(FID_LINE_POLARIZATION_PERCENTAGE, "Expected polarization of the line in percent", 0.0, 100.0);
        jTextField3.setColumns(8);
        jPanel4.add(jTextField3);
        jPanel4.add(new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, 0)));
        jPanel4.add(this.makeLabel("per cent"));
        jPanel4.add(new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, 0)));
        jPanel4.add(Box.createHorizontalGlue());
        componentCollection.remember(jPanel4);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        JTextField jTextField4 = this.makeTextFieldWithDoubleVerifier(FID_SPECTRALLINE_CIRCULAR_POLARIZATION, "Expected spectral line circular polarization of the source in per cent", 0.0, 100.0);
        componentCollection.remember(this.makeLabel("Line Circular Polarization"));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        jTextField4.setColumns(8);
        jPanel5.add(jTextField4);
        jPanel5.add(new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, 0)));
        jPanel5.add(this.makeLabel("per cent"));
        jPanel5.add(new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, 0)));
        jPanel5.add(Box.createHorizontalGlue());
        componentCollection.remember(jPanel5);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        return jPanel;
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createTargetPanel();
        this.addGroup(jPanel, string);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        JPanel jPanel3 = this.createStandardExpectedPropertiesPanel();
        this.register(jPanel3, FID_STANDARD_EXPECTED_PROPERTIES_PANEL);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = this.createSolarExpectedPropertiesPanel();
        this.register(jPanel4, FID_SOLAR_EXPECTED_PROPERTIES_PANEL);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = this.addGroup(jPanel2, "Expected Source Properties");
        CSH.setHelpIDString((Component)jPanel5, (String)"TOC-Phase 1 and Phase 2 Science Goals-Field Setup-Expected Source Properties");
    }

    private JPanel createSolarExpectedPropertiesPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        String[] stringArray = new String[]{ExpectedPropertiesData.SOLARACTIVITYLEVEL_ACTIVESUN, ExpectedPropertiesData.SOLARACTIVITYLEVEL_QUIETSUN};
        OTButtonGroup oTButtonGroup = this.addOTButtonGroup(jPanel, gridBagLayout, gridBagConstraints, FID_SOLAR_ACTIVITY, "Solar activity level", "Solar activity level", stringArray, 3, 150);
        this.register(oTButtonGroup, FID_SOLAR_ACTIVITY);
        componentCollection.remember(oTButtonGroup);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        return jPanel;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        AbstractTargetModel abstractTargetModel = (AbstractTargetModel)this.getModel();
        if (fieldID.equals(FID_RESOLVENAME) || fieldID.equals(FID_RESOLVECANCEL)) {
            return;
        }
        if (fieldID.equals(FID_NONSIDEREALMOTION)) {
            boolean bl = (Boolean)object;
            this.retrieve(FID_RESOLVENAME).setVisible(!bl);
            boolean bl2 = bl && (AbstractTargetParameters.SOLARSYSTEMOBJECT_EPHEMERIS.equals(abstractTargetModel.getAbstractTarget().getSolarSystemObject()) || AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN.equals(abstractTargetModel.getAbstractTarget().getSolarSystemObject()));
            JComponent jComponent = this.retrieve(FID_SOURCEEPHEMERIS);
            if (jComponent != null) {
                this.setVisible(jComponent, bl2);
            }
            if ((jComponent = this.retrieve(FID_SOLARSYSTEMOBJECT)) != null) {
                this.setEnabled(jComponent, bl);
            }
            TargetParameters targetParameters = (TargetParameters)abstractTargetModel.getDocument();
            try {
                this.configureEditorForView(SingleFieldScienceGoalModel.getScienceGoalSubview(targetParameters.getScienceGoal()));
            }
            catch (SingleFieldScienceGoalModel.UnableToDetermineSubviewException unableToDetermineSubviewException) {
                Log.logger(AbstractTargetEditor.class).info("Unable to determine subviews to be displayed" + unableToDetermineSubviewException.getMessage());
            }
            this.showExtraSolarSystemComponents(!bl, bl2);
            super.update(fieldID, object);
            return;
        }
        if (fieldID.equals(FID_SOLARSYSTEMOBJECT)) {
            JComponent jComponent = this.retrieve(FID_SOURCEEPHEMERIS);
            if (jComponent != null) {
                this.setVisible(jComponent, abstractTargetModel.getAbstractTarget().getNonSiderealMotion() && (AbstractTargetParameters.SOLARSYSTEMOBJECT_EPHEMERIS.equals(abstractTargetModel.getAbstractTarget().getSolarSystemObject()) || AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN.equals(abstractTargetModel.getAbstractTarget().getSolarSystemObject())));
            }
            TargetParameters targetParameters = (TargetParameters)abstractTargetModel.getDocument();
            try {
                this.configureEditorForView(SingleFieldScienceGoalModel.getScienceGoalSubview(targetParameters.getScienceGoal()));
            }
            catch (SingleFieldScienceGoalModel.UnableToDetermineSubviewException unableToDetermineSubviewException) {
                Log.logger(AbstractTargetEditor.class).info("Unable to determine subviews to be displayed" + unableToDetermineSubviewException.getMessage());
            }
            super.update(fieldID, object);
            return;
        }
        super.update(fieldID, object);
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.collapse) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    public void configureEditorForView(SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews scienceGoalEditorSubviews) {
        if (SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews.SOLAR.equals((Object)scienceGoalEditorSubviews)) {
            this.retrieve(FID_STANDARD_EXPECTED_PROPERTIES_PANEL).setVisible(false);
            this.retrieve(FID_SOLAR_EXPECTED_PROPERTIES_PANEL).setVisible(true);
        } else {
            this.retrieve(FID_STANDARD_EXPECTED_PROPERTIES_PANEL).setVisible(true);
            this.retrieve(FID_SOLAR_EXPECTED_PROPERTIES_PANEL).setVisible(false);
        }
    }
}

