/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateFactory;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.util.TextUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;

public class EstimatedTimeInfoBuilder {
    private PerformanceParameters pp;
    private ScienceGoal sg;
    private Log.Logger logger = Log.logger((Object)this);
    private static Array array = Array.ARRAY_12M;

    public EstimatedTimeInfoBuilder(PerformanceParameters performanceParameters) {
        this.pp = performanceParameters;
        this.sg = performanceParameters.getScienceGoal();
        if (this.sg == null) {
            String string = "Can not find the parent ScienceGoal from this PerformanceParameters";
            throw new IllegalArgumentException(string);
        }
    }

    public JDialog buildTimeEstimateDialogWindow(TimeEstimateModel timeEstimateModel) {
        final JDialog jDialog = new JDialog();
        jDialog.setTitle("Time Estimate");
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setSize(timeEstimateModel.getDialogWindowDimensions());
        jDialog.setDefaultCloseOperation(2);
        Container container = jDialog.getContentPane();
        JLabel jLabel = this.createHeader(timeEstimateModel.getHeader());
        Border border = BorderFactory.createEmptyBorder(10, 60, 10, 10);
        jLabel.setBorder(border);
        container.add((Component)jLabel, "First");
        JTabbedPane jTabbedPane = this.createClusterSpecificTimeEstimateTabbedPane(timeEstimateModel);
        container.add((Component)jTabbedPane, "Center");
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        container.add((Component)jButton, "Last");
        JFrame jFrame = GuiFactory.getFactory().getParentWindow();
        jDialog.setLocationRelativeTo(jFrame);
        return jDialog;
    }

    private JTabbedPane createClusterSpecificTimeEstimateTabbedPane(TimeEstimateModel timeEstimateModel) {
        if (timeEstimateModel == null) {
            throw new NullPointerException("Illegal argument - the argument timeEstimate cannot be null");
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        List<ClusterTimeInfo> list = timeEstimateModel.getSbSpecificInformationBlock();
        assert (list.size() > 0);
        int n = 1;
        for (ClusterTimeInfo clusterTimeInfo : list) {
            JPanel jPanel = new JPanel();
            JScrollPane jScrollPane = null;
            Border border = BorderFactory.createEmptyBorder(5, 3, 5, 3);
            try {
                jScrollPane = this.createTargetListPanel(clusterTimeInfo);
                jScrollPane.setBorder(border);
            }
            catch (InvalidCoordException | OutOfRangeException exception) {
                // empty catch block
            }
            JScrollPane jScrollPane2 = null;
            try {
                jScrollPane2 = this.createConfigurationListPanel(clusterTimeInfo);
                jScrollPane2.setBorder(border);
            }
            catch (InvalidCoordException | OutOfRangeException exception) {
                // empty catch block
            }
            assert (jScrollPane2 != null && jScrollPane != null) : "Unable to create configuration/target list panel";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append("<head><style> table { border-collapse: collapse; }table</style></head>");
            stringBuilder.append("<body>");
            stringBuilder.append("<table cellpadding=1>");
            for (List<String> list2 : clusterTimeInfo.getKeyValuePairs()) {
                assert (list2.size() == 2);
                stringBuilder.append("<tr><td>");
                stringBuilder.append(list2.get(0));
                stringBuilder.append("</td><td>");
                stringBuilder.append(list2.get(1));
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table>");
            stringBuilder.append("</body></html>");
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            Border border2 = BorderFactory.createEmptyBorder(10, 0, 10, 0);
            jPanel.add(jScrollPane);
            JLabel object2 = new JLabel("<html><center><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Possible Configuration Combinations</b></center></html>");
            jPanel.add(object2);
            jPanel.add(jScrollPane2);
            JLabel jLabel = new JLabel();
            jLabel.setText(stringBuilder.toString());
            jLabel.setBorder(border2);
            jPanel.add(jLabel);
            jPanel.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 100), new Dimension(0, 100)));
            JScrollPane jScrollPane3 = new JScrollPane(jPanel);
            jScrollPane3.setBorder(BorderFactory.createLoweredBevelBorder());
            jTabbedPane.addTab(String.format("Cluster %d", n++), jScrollPane3);
        }
        return jTabbedPane;
    }

    private JScrollPane createTargetListPanel(ClusterTimeInfo clusterTimeInfo) throws OutOfRangeException, InvalidCoordException {
        EventListener eventListener;
        Object[] objectArray = new String[]{"Source Name", "RA", "Dec", "Velocity"};
        TargetParameters[] targetParametersArray = clusterTimeInfo.getClusterSpecificScienceGoal().getTargetParameters();
        Object[][] objectArray2 = new Object[targetParametersArray.length][objectArray.length];
        for (int i = 0; i < targetParametersArray.length; ++i) {
            eventListener = targetParametersArray[i];
            objectArray2[i][0] = eventListener.getSourceName();
            objectArray2[i][1] = eventListener.getSourceCoordinates().getLongitude().toHHMMSS();
            objectArray2[i][2] = eventListener.getSourceCoordinates().getLatitude().toDDMMSS();
            objectArray2[i][3] = TextUtils.format(eventListener.getSourceVelocity().getCenterVelocity(), 3);
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        eventListener = new JTable(defaultTableModel);
        ((JTable)eventListener).getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)eventListener));
        ((JTable)eventListener).setFillsViewportHeight(true);
        jScrollPane.setVisible(true);
        ((JTable)eventListener).setPreferredScrollableViewportSize(new Dimension(100, 63));
        ((JComponent)((Object)eventListener)).setBorder(BorderFactory.createLoweredBevelBorder());
        return jScrollPane;
    }

    private JScrollPane createConfigurationListPanel(ClusterTimeInfo clusterTimeInfo) throws OutOfRangeException, InvalidCoordException {
        Object object;
        Object[] objectArray = new String[]{"12-m (1)", "12-m (2)", "7-m", "TP"};
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = clusterTimeInfo.getScienceGoalConfigurations();
        Collections.sort(scienceGoalConfigurations);
        Object[][] objectArray2 = new Object[scienceGoalConfigurations.size()][4];
        for (int i = 0; i < scienceGoalConfigurations.size(); ++i) {
            object = (ConfigurationSet)scienceGoalConfigurations.get(i);
            objectArray2[i][0] = ((ConfigurationSet)object).getTM1Configuration().orElse(Configuration.NO_CONFIG).getName();
            objectArray2[i][1] = ((ConfigurationSet)object).getTM2Configuration().orElse(Configuration.NO_CONFIG).getName();
            objectArray2[i][2] = ((ConfigurationSet)object).isACA7mRequired() ? "Yes" : "No";
            objectArray2[i][3] = ((ConfigurationSet)object).isTPRequired() ? "Yes" : "No";
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        object = new JTable(defaultTableModel);
        ((JTable)object).getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane((Component)object);
        ((JTable)object).setFillsViewportHeight(true);
        jScrollPane.setVisible(true);
        ((JTable)object).setPreferredScrollableViewportSize(new Dimension(100, 92));
        ((JComponent)object).setBorder(BorderFactory.createLoweredBevelBorder());
        return jScrollPane;
    }

    private JLabel createHeader(List<List<String>> list) {
        JLabel jLabel = new JLabel();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<head><style> table { border-collapse: collapse; }table</style></head>");
        stringBuilder.append("<body>");
        stringBuilder.append("<table cellpadding=1>");
        for (List<String> list2 : list) {
            assert (list2.size() == 2);
            stringBuilder.append("<tr><td>");
            stringBuilder.append(list2.get(0));
            stringBuilder.append("</td><td>");
            stringBuilder.append(list2.get(1));
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
        stringBuilder.append("</body></html>");
        jLabel.setText(stringBuilder.toString());
        return jLabel;
    }

    private JLabel createFooter(List<List<String>> list) {
        JLabel jLabel = new JLabel();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<head><style> table { border-collapse: collapse; }table</style></head>");
        stringBuilder.append("<body>");
        stringBuilder.append("<table cellpadding=1>");
        for (List<String> list2 : list) {
            assert (list2.size() == 2);
            stringBuilder.append("<tr><td>");
            stringBuilder.append(list2.get(0));
            stringBuilder.append("</td><td>");
            stringBuilder.append(list2.get(1));
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
        stringBuilder.append("</body></html>");
        jLabel.setText(stringBuilder.toString());
        return jLabel;
    }

    public TimeEstimateModel buildTimeEstimateModel() throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        TimeEstimateInterface timeEstimateInterface;
        SpectralSetupParameters spectralSetupParameters = this.sg.getSpectralSetupParameters();
        if (spectralSetupParameters.isSpectralScan() && this.sg.getPerformanceParameters().getUseACA()) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("The ACA cannot be selected when a science goal is configured as a spectral scan");
        }
        if (spectralSetupParameters.isFullPolarisation().booleanValue() && this.sg.getPerformanceParameters().getUseACA() && !Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("The ACA cannot be selected when full polarization is requested.");
        }
        try {
            timeEstimateInterface = this.sg.isSolarScienceGoal() ? TimeEstimateFactory.getTimeEstimateModelGenerator(TimeEstimateFactory.TimeEstimate.SOLAR) : (this.sg.getObsProposal().isVLBI() ? TimeEstimateFactory.getTimeEstimateModelGenerator(TimeEstimateFactory.TimeEstimate.VLBI) : TimeEstimateFactory.getTimeEstimateModelGenerator(TimeEstimateFactory.TimeEstimate.STANDARD));
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to determine if the science goal is solar : " + unknownEntityException.getMessage());
        }
        assert (timeEstimateInterface != null);
        return timeEstimateInterface.generateTimeEstimateModel(this.sg);
    }

    public static class TimeEstimateModel {
        private Dimension dialogWindowDimensions = null;
        private ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = new ScienceGoalConfigurations();
        private ScienceGoal clusterSpecificScienceGoal = null;
        private List<List<String>> header = new ArrayList<List<String>>();
        private List<ClusterTimeInfo> sbSpecificInformationBlock = new ArrayList<ClusterTimeInfo>();
        private List<List<String>> keyValuePairBuffer = new ArrayList<List<String>>();
        private List<List<String>> footer = new ArrayList<List<String>>();

        public List<ClusterTimeInfo> getSbSpecificInformationBlock() {
            return Collections.unmodifiableList(this.sbSpecificInformationBlock);
        }

        public Dimension getDialogWindowDimensions() {
            return this.dialogWindowDimensions;
        }

        public void setDialogWindowDimensions(Dimension dimension) {
            this.dialogWindowDimensions = dimension;
        }

        public void commitClusterSpecificData() {
            ClusterTimeInfo clusterTimeInfo = new ClusterTimeInfo();
            clusterTimeInfo.setKeyValuePairs(this.keyValuePairBuffer);
            assert (this.clusterSpecificScienceGoal != null);
            clusterTimeInfo.setClusterSpecificScienceGoal(this.clusterSpecificScienceGoal);
            clusterTimeInfo.setScienceGoalConfigurations(this.scienceGoalConfigurations);
            this.scienceGoalConfigurations = new ScienceGoalConfigurations();
            this.sbSpecificInformationBlock.add(clusterTimeInfo);
            this.keyValuePairBuffer = new ArrayList<List<String>>();
            this.clusterSpecificScienceGoal = null;
        }

        public void addClusterSpecificKeyValuePair(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: key");
            }
            this.keyValuePairBuffer.add(Arrays.asList(string, string2));
        }

        public void addToHeader(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: key");
            }
            this.header.add(Arrays.asList(string, string2));
        }

        public void addToFooter(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: key");
            }
            this.footer.add(Arrays.asList(string, string2));
        }

        public List<List<String>> getHeader() {
            return this.header;
        }

        public List<List<String>> getFooter() {
            return this.footer;
        }

        public final void setClusterSpecificScienceGoal(ScienceGoal scienceGoal) {
            this.clusterSpecificScienceGoal = scienceGoal;
        }

        public ScienceGoalConfigurations<ConfigurationSet> getScienceGoalConfigurations() {
            return this.scienceGoalConfigurations;
        }

        public void setScienceGoalConfigurations(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations) {
            this.scienceGoalConfigurations = scienceGoalConfigurations;
        }
    }

    public static class ClusterTimeInfo {
        private List<List<String>> keyValuePairs = new ArrayList<List<String>>();
        private ScienceGoal clusterSpecificScienceGoal = null;
        private ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = new ScienceGoalConfigurations();

        public final ScienceGoal getClusterSpecificScienceGoal() {
            return this.clusterSpecificScienceGoal;
        }

        public final void setClusterSpecificScienceGoal(ScienceGoal scienceGoal) {
            this.clusterSpecificScienceGoal = scienceGoal;
        }

        public final List<List<String>> getKeyValuePairs() {
            return this.keyValuePairs;
        }

        public final void setKeyValuePairs(List<List<String>> list) {
            this.keyValuePairs = list;
        }

        public ScienceGoalConfigurations<ConfigurationSet> getScienceGoalConfigurations() {
            return this.scienceGoalConfigurations;
        }

        public void setScienceGoalConfigurations(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations) {
            this.scienceGoalConfigurations = scienceGoalConfigurations;
        }
    }
}

